/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery.os;

import com.wilibox.discovery.os.ShellException;
import com.wilibox.discovery.os.ShellResult;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

public class Shell {
    protected static final int PING_SIZE = 369;
    protected static final String PING_DEST = "192.168.2.66";
    private static final int OS_UNKNOWN = 0;
    private static final int OS_LINUX = 1;
    private static final int OS_MACOS = 2;
    private static final int OS_WINXP = 3;
    private static final int OS_WIN7 = 4;

    public static void set_verbose() {
    }

    protected static String format(String cmd, Object ... args) {
        return MessageFormat.format(cmd, args);
    }

    private static int getOs() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return 0;
        }
        if (os.equalsIgnoreCase("linux")) {
            return 1;
        }
        if (os.equalsIgnoreCase("windows xp")) {
            return 3;
        }
        if (os.equalsIgnoreCase("windows 7")) {
            return 4;
        }
        if (os.startsWith("Mac")) {
            return 2;
        }
        return 0;
    }

    public static boolean isWindowsXp() {
        return Shell.getOs() == 3;
    }

    public static boolean isWindows7() {
        return Shell.getOs() == 4;
    }

    public static boolean isWindows() {
        return Shell.isWindowsXp() || Shell.isWindows7();
    }

    public static boolean isLinux() {
        return Shell.getOs() == 1;
    }

    public static boolean isMacos() {
        return Shell.getOs() == 2;
    }

    public static Process start(String ... command) throws ShellException {
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        try {
            return builder.start();
        }
        catch (IOException e) {
            throw new ShellException(e);
        }
    }

    public static int wait(Process p) throws IOException {
        InputStream pipeOut = p.getInputStream();
        int exitCode = 0;
        byte[] buffer = new byte[2048];
        while (true) {
            try {
                exitCode = p.exitValue();
            }
            catch (IllegalThreadStateException e) {
                if (pipeOut.available() <= 0) continue;
                pipeOut.read(buffer);
                continue;
            }
            break;
        }
        try {
            pipeOut.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return exitCode;
    }

    public static ShellResult execute(String ... command) throws IOException, ShellException {
        int exitCode = 0;
        byte[] buffer = new byte[2048];
        int count = 0;
        String output = "";
        Process aProcess = Shell.start(command);
        InputStream pipeOut = aProcess.getInputStream();
        while (true) {
            try {
                exitCode = aProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                if (pipeOut.available() <= 0) continue;
                count = pipeOut.read(buffer);
                output = output + new String(buffer, 0, count);
                continue;
            }
            break;
        }
        try {
            pipeOut.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return new ShellResult(exitCode, output);
    }
}

