/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery.os;

import com.wilibox.discovery.os.Shell;
import com.wilibox.discovery.os.ShellException;
import com.wilibox.discovery.os.ShellResult;
import java.io.IOException;

public class MacShell
extends Shell {
    private static final String SHELL_CMD = "open {0}";
    private static final String ARP_ADD_CMD = "arp -s {0} {1} -i {2}";
    private static final String ARP_DEL_CMD = "arp -d {0}";
    private static final String PING_CMD = "ping {0} -s {1} -c {2} -w {3}";
    private static final String RPF_CMD = "set skip on {0}";
    private Process currentProcess;

    public static ShellResult execute(String cmd) throws IOException, ShellException {
        ShellResult result = Shell.execute("open", cmd);
        return result;
    }

    public static Process start(String cmd) throws ShellException {
        return Shell.start("open", cmd);
    }

    public static void setSkipOn(String iface) throws IOException, ShellException {
    }

    private static void addArp(String ip, String mac, String iface) throws IOException, ShellException {
        Object[] args = new Object[]{ip, mac.replace('-', ':'), iface};
        String cmd = MacShell.format(ARP_ADD_CMD, args);
        MacShell.execute(cmd);
    }

    private static void delArp(String ip) throws IOException, ShellException {
        Object[] args = new Object[]{ip};
        String cmd = MacShell.format(ARP_DEL_CMD, args);
        MacShell.execute(cmd);
    }

    private static Process ping(String ip, int timeout) throws IOException, ShellException {
        Object[] args = new Object[]{ip, 369, 15, timeout};
        String cmd = MacShell.format(PING_CMD, args);
        return MacShell.start(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resetStart(String mac, String iface, int timeout) {
        int result;
        if (this.currentProcess != null) {
            return -1;
        }
        try {
            MacShell.delArp("192.168.2.66");
            try {
                MacShell.addArp("192.168.2.66", mac, iface);
                this.currentProcess = MacShell.ping("192.168.2.66", timeout);
                result = MacShell.wait(this.currentProcess);
            }
            finally {
                MacShell.delArp("192.168.2.66");
            }
        }
        catch (ShellException e) {
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
        return result;
    }

    public void resetAbort() {
        if (this.currentProcess == null) {
            return;
        }
        this.currentProcess.destroy();
        this.currentProcess = null;
    }
}

