/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery.os;

import com.wilibox.discovery.os.Shell;
import com.wilibox.discovery.os.ShellException;
import com.wilibox.discovery.os.ShellResult;
import java.io.IOException;

public class LinuxShell
extends Shell {
    private static final String ARP_ADD_CMD = "arp -s {0} {1} -i {2}";
    private static final String ARP_DEL_CMD = "arp -d {0}";
    private static final String PING_CMD = "ping {0} -s {1} -c {2} -w {3}";
    private static final String[] SET_RPF_CMD = new String[]{"sysctl", "net.ipv4.conf.{0}.rp_filter={1}"};
    private static final String[] GET_RPF_CMD = new String[]{"sysctl", "net.ipv4.conf.{0}.rp_filter"};
    private Process currentProcess;

    private static void addArp(String ip, String mac, String iface) throws IOException, ShellException {
        Object[] args = new Object[]{ip, mac.replace('-', ':'), iface};
        String cmd = LinuxShell.format(ARP_ADD_CMD, args);
        LinuxShell.execute(cmd);
    }

    private static void delArp(String ip) throws IOException, ShellException {
        Object[] args = new Object[]{ip};
        String cmd = LinuxShell.format(ARP_DEL_CMD, args);
        LinuxShell.execute(cmd);
    }

    private static Process ping(String ip, int timeout) throws IOException, ShellException {
        Object[] args = new Object[]{ip, 369, 15, timeout};
        String cmd = LinuxShell.format(PING_CMD, args);
        return LinuxShell.start(cmd);
    }

    public static void setRPF(String iface, int state) {
        try {
            Object[] args = new Object[]{iface, state};
            String[] cpy = new String[SET_RPF_CMD.length];
            System.arraycopy(SET_RPF_CMD, 0, cpy, 0, SET_RPF_CMD.length);
            cpy[1] = LinuxShell.format(cpy[1], args);
            LinuxShell.execute(cpy);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public static int getRPF(String iface) {
        String shellOutput = "";
        String results = "";
        int value = -1;
        try {
            Object[] args = new Object[]{iface};
            String[] cpy = new String[GET_RPF_CMD.length];
            System.arraycopy(GET_RPF_CMD, 0, cpy, 0, GET_RPF_CMD.length);
            cpy[1] = LinuxShell.format(cpy[1], args);
            ShellResult shellResults = LinuxShell.execute(cpy);
            shellOutput = shellResults.getOutput();
            results = shellOutput.split("=")[1].trim();
            value = Integer.parseInt(results);
            if (value < 0) {
                throw new Exception("Unable to parse rp_filter value!");
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
            return -1;
        }
        catch (Exception ex) {
            System.err.println(ex);
            return -1;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resetStart(String mac, String iface, int timeout) {
        int result;
        if (this.currentProcess != null) {
            return -1;
        }
        try {
            LinuxShell.delArp("192.168.2.66");
            try {
                LinuxShell.addArp("192.168.2.66", mac, iface);
                this.currentProcess = LinuxShell.ping("192.168.2.66", timeout);
                result = LinuxShell.wait(this.currentProcess);
            }
            finally {
                LinuxShell.delArp("192.168.2.66");
            }
        }
        catch (ShellException e) {
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
        return result;
    }

    public void resetAbort() {
        if (this.currentProcess == null) {
            return;
        }
        this.currentProcess.destroy();
        this.currentProcess = null;
    }
}

