/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.SocketInfo;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;

class SocketContext {
    private MulticastSocket socket;
    private NetworkInterface iface;
    private InetAddress addr;
    private int port;
    private int rp_iface;
    private int rp_all;

    SocketContext(MulticastSocket socket, NetworkInterface iface, InetAddress addr) {
        this.socket = socket;
        this.iface = iface;
        this.addr = addr;
        this.port = -1;
    }

    SocketContext(MulticastSocket socket, NetworkInterface iface, InetAddress addr, int port) {
        this.socket = socket;
        this.iface = iface;
        this.addr = addr;
        this.port = port;
    }

    SocketContext(MulticastSocket socket, NetworkInterface iface, InetAddress addr, int port, int rp_iface, int rp_all) {
        this.socket = socket;
        this.iface = iface;
        this.addr = addr;
        this.port = port;
        this.rp_iface = rp_iface;
        this.rp_all = rp_all;
    }

    public MulticastSocket get_socket() {
        return this.socket;
    }

    public NetworkInterface get_interface() {
        return this.iface;
    }

    public InetAddress get_address() {
        return this.addr;
    }

    public int get_port() {
        return this.port;
    }

    public int get_rp_all() {
        return this.rp_all;
    }

    public int get_rp_iface() {
        return this.rp_iface;
    }

    public String get_interface_name() {
        return this.iface.getName();
    }

    public String get_interface_display() {
        return this.iface.getDisplayName();
    }

    public byte[] get_interface_mac() {
        try {
            return this.iface.getHardwareAddress();
        }
        catch (SocketException ex) {
            return null;
        }
    }

    public String get_interface_ipaddr() {
        return this.addr.getHostAddress();
    }

    public void fill(SocketInfo s) {
        s.setData(this.get_interface_name(), this.get_interface_display(), this.get_interface_mac(), this.get_interface_ipaddr());
    }
}

