/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.AtherosResetAction;
import com.wilibox.discovery.Device;
import com.wilibox.discovery.DiscoveryProto;
import com.wilibox.discovery.DiscoveryProtoListener;
import com.wilibox.discovery.DualBootResetAction;
import com.wilibox.discovery.LanguageFactory;
import com.wilibox.discovery.LegacyProto;
import com.wilibox.discovery.Main;
import com.wilibox.discovery.MulticastResetAction;
import com.wilibox.discovery.PingResetAction;
import com.wilibox.discovery.ResetAction;
import com.wilibox.discovery.ResetDialog;
import java.awt.Frame;
import javax.swing.SwingUtilities;

public class ResetActionHandler
implements Runnable,
DiscoveryProtoListener {
    private Main parent;
    private ResetAction reset;
    private ResetDialog reset_dialog;
    private boolean verbose;

    public ResetActionHandler(Main parent) {
        this.parent = parent;
    }

    public DiscoveryProto getResetHolder() {
        return this.parent.getResetHolder();
    }

    public LegacyProto getDiscoveryHolder() {
        return this.parent.getDiscoveryHolder();
    }

    public void deviceFound(Device dev) {
        if (this.reset == null) {
            return;
        }
        this.reset.deviceFound(dev);
    }

    public void deviceBootState(String mac) {
        if (this.reset == null) {
            return;
        }
        this.reset.deviceBootState(mac);
    }

    public void deviceWorkState(String mac) {
        if (this.reset == null) {
            return;
        }
        this.reset.deviceWorkState(mac);
    }

    public void deviceExtended(String mac) {
        if (this.reset == null) {
            return;
        }
        this.reset.deviceExtended(mac);
    }

    public void deviceReseting(String mac) {
        if (this.reset == null) {
            return;
        }
        this.reset.deviceReseting(mac);
    }

    public void deviceMarked(String mac) {
        if (this.reset == null) {
            return;
        }
        this.reset.deviceMarked(mac);
    }

    public void deviceWrongPin(String mac) {
        if (this.reset == null) {
            return;
        }
        this.reset.deviceWrongPin(mac);
    }

    public int get_branch(String fwVer) {
        int fw_branch = 0;
        if (fwVer == null || fwVer.equals("")) {
            return fw_branch;
        }
        String[] comp = fwVer.split("\\.");
        if (comp.length < 4) {
            return fw_branch;
        }
        String[] brfs = comp[3].split("\\-");
        fw_branch = Integer.parseInt(brfs[0]);
        if (comp[2].equals("v7") && fw_branch >= 0) {
            fw_branch = 77;
        }
        return fw_branch;
    }

    public int get_revision(String fwVer) {
        int fw_revision = 0;
        if (fwVer == null || fwVer.equals("")) {
            return fw_revision;
        }
        String[] comp = fwVer.split("\\.");
        if (comp.length < 9) {
            return fw_revision;
        }
        String rev = comp[comp.length - 3];
        try {
            fw_revision = Integer.parseInt(rev);
        }
        catch (NumberFormatException ex1st) {
            try {
                rev = comp[comp.length - 4];
                fw_revision = Integer.parseInt(rev);
            }
            catch (NumberFormatException ex2nd) {
                return 0;
            }
        }
        return fw_revision;
    }

    public void run() {
        ResetActionHandler resetActionHandler = this;
        this.verbose = resetActionHandler.parent.get_verbose();
        Main.silent_on();
        int row = this.parent.getSelectedIndex();
        if (row == -1) {
            this.parent.setHint(LanguageFactory.get_text("notify-selected", new String[0]));
            return;
        }
        Device reset_device = this.parent.getDevice(row);
        String device_mac = reset_device.getMacAddress();
        String device_fw = reset_device.getFirmwareVersion();
        int fw_branch = this.get_branch(device_fw);
        int fw_revision = this.get_revision(device_fw);
        this.reset_dialog = new ResetDialog((Frame)this.parent, this, LanguageFactory.get_text("resetdlg-caption", device_mac));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ResetActionHandler.this.reset_dialog.setVisible(true);
            }
        });
        if (this.getResetHolder().get_proto_ver() == 2) {
            this.reset = new AtherosResetAction(this, reset_device, this.parent);
        } else if (fw_branch < 77) {
            if (this.verbose) {
                System.out.println(String.format("Using legacy reset for %s - %s", device_mac, device_fw));
            }
            this.reset = new PingResetAction(this, reset_device);
        } else if (fw_revision < 43300) {
            if (this.verbose) {
                System.out.println(String.format("Using multicast reset for %s - %s", device_mac, device_fw));
            }
            this.reset = new MulticastResetAction(this, reset_device);
        } else {
            if (this.verbose) {
                System.out.println(String.format("Using dual-boot reset for %s - %s", device_mac, device_fw));
            }
            this.reset = new DualBootResetAction(this, reset_device);
        }
        this.reset.run();
        if (this.reset.is_canceled()) {
            this.parent.setStatus(LanguageFactory.get_text("status-canceled", new String[0]));
            this.parent.setHint("");
        }
        Main.silent_off();
    }

    public boolean is_verbose() {
        return this.verbose;
    }

    public void reset_cancel() {
        if (this.reset != null) {
            this.reset.stop();
        }
        this.parent.setStatus(LanguageFactory.get_text("status-canceled", new String[0]));
        this.parent.setHint("");
    }

    public void reset_finish(String text, String hint) {
        this.parent.setStatus(text);
        this.parent.setHint(hint);
        this.reset_dialog.setStatus(text);
        this.reset_dialog.setHint(hint);
        this.reset_dialog.delayedExit(1000);
    }

    public void setStatus(String text) {
        this.reset_dialog.setStatus(text);
    }

    public void setHint(String text) {
        this.reset_dialog.setHint(text);
    }
}

