/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.Device;
import com.wilibox.discovery.LanguageFactory;
import com.wilibox.discovery.Main;
import com.wilibox.discovery.OShell;
import com.wilibox.discovery.ResetAction;
import com.wilibox.discovery.ResetActionHandler;

class PingResetAction
extends ResetAction {
    private ResetActionHandler parent;
    private Device reset_device;
    private boolean dev_online;
    private int state_counter;
    private static final int ST_UNKNOWN = 0;
    private static final int ST_RUSTY = 1;
    private static final int ST_DEVICE_OFFLINE = 3;
    private static final int ST_DEVICE_PINGING = 7;
    private static final int ST_DEVICE_ONLINE = 15;
    private static final int ST_USERSTOP = 65535;
    private static final int PING_TIMEOUT = 20;
    private OShell os = new OShell();

    private String strState(int state) {
        switch (state) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Rusty";
            }
            case 3: {
                return "Offline";
            }
            case 7: {
                return "Pinging";
            }
            case 15: {
                return "Online";
            }
            case 65535: {
                return "UserStop";
            }
        }
        return "";
    }

    public PingResetAction(ResetActionHandler parent, Device reset_device) {
        this.parent = parent;
        this.reset_device = reset_device;
        if (Main.get_verbose()) {
            OShell.set_verbose();
        }
    }

    public void deviceFound(Device dev) {
        if (this.reset_device == null) {
            return;
        }
        String fmac = dev.getMacAddress();
        if (this.state_counter == 1) {
            if (fmac.compareTo(this.reset_device.getMacAddress()) == 0) {
                this.dev_online = true;
            }
        } else if (this.state_counter == 7 && fmac.compareTo(this.reset_device.getMacAddress()) == 0) {
            this.state_counter |= 0xF;
        }
    }

    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        this.state_counter = 0;
        String device_mac = this.reset_device.getMacAddress();
        String link_iface = this.reset_device.getInterface();
        if (OShell.is_windows()) {
            link_iface = this.reset_device.getInterfaceIP();
        }
        this.parent.getResetHolder().set_autoextend(false);
        this.legacy_reset(device_mac, link_iface);
        this.parent.getResetHolder().set_autoextend(true);
    }

    public void legacy_reset(String devMac, String iface) {
        this.state_counter |= 1;
        try {
            this.parent.setStatus(LanguageFactory.get_text("status-waiting", new String[0]));
            this.parent.setHint(LanguageFactory.get_text("reset-hint-reboot-wait", new String[0]));
            this.dev_online = true;
            this.state_counter = 3;
            while (this.state_counter < 3) {
                if (!this.dev_online) {
                    this.state_counter |= 3;
                    break;
                }
                this.dev_online = false;
                this.parent.getDiscoveryHolder().send_discovery();
                this.sleep(3000);
            }
            if (this.state_counter == 65535) {
                return;
            }
            this.parent.setStatus(LanguageFactory.get_text("status-attempting", new String[0]));
            this.parent.setHint(LanguageFactory.get_text("reset-hint-reboot-real", new String[0]));
            this.state_counter |= 7;
            if (this.os.reset(devMac, iface, 20) != 0) {
                this.parent.reset_finish(LanguageFactory.get_text("status-failed", new String[0]), LanguageFactory.get_text("status-hint-superuser", new String[0]));
                return;
            }
            this.parent.setStatus(LanguageFactory.get_text("status-devstate", new String[0]));
            this.parent.setHint("");
            while (this.state_counter < 15) {
                this.parent.getDiscoveryHolder().send_discovery();
                this.sleep(3000);
            }
            this.parent.reset_finish(LanguageFactory.get_text("status-complete", new String[0]), "");
        }
        catch (Exception ex) {
            if (this.parent.is_verbose()) {
                ex.printStackTrace();
            }
            this.parent.reset_finish(LanguageFactory.get_text("status-failed", new String[0]), ex.getMessage());
        }
    }

    public void stop() {
        this.state_counter = 65535;
        this.os.cancel_reset();
    }

    public boolean is_canceled() {
        return this.state_counter == 65535;
    }
}

