/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.JTextFieldLimit;
import com.wilibox.discovery.LanguageFactory;
import com.wilibox.discovery.Main;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PinDialog
extends JDialog {
    private Main parent;
    private String pin;
    JButton enterButton;
    JButton cancelButton;
    JLabel pinLabel;
    JLabel errorLabel;
    JTextField pinField;

    public PinDialog(Main parent) {
        super(parent, LanguageFactory.get_text("pindlg-caption", new String[0]), true);
        this.parent = parent;
        this.pin = "";
        this.setSize(new Dimension(350, 200));
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
        this.pinLabel = new JLabel(LanguageFactory.get_text("pindlg-pin", new String[0]));
        this.errorLabel = new JLabel(LanguageFactory.get_text("pindlg-err", "4"));
        this.pinField = new JTextField();
        this.pinField.setDocument(new JTextFieldLimit(4));
        this.pinField.setPreferredSize(new Dimension(50, 25));
        this.pinField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.doit(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.doit(e);
            }

            public void insertUpdate(DocumentEvent e) {
                this.doit(e);
            }

            private void doit(DocumentEvent e) {
                String pin = PinDialog.this.pinField.getText();
                if (pin.length() != 4) {
                    PinDialog.this.errorLabel.setVisible(true);
                    PinDialog.this.errorLabel.setText(LanguageFactory.get_text("pindlg-err", "4"));
                    PinDialog.this.enterButton.setEnabled(false);
                } else {
                    PinDialog.this.errorLabel.setVisible(false);
                    PinDialog.this.errorLabel.setText("");
                    PinDialog.this.enterButton.setEnabled(true);
                }
            }
        });
        this.enterButton = new JButton(new EnterAction(this));
        this.enterButton.setEnabled(false);
        this.cancelButton = new JButton(new CloseAction(this));
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.add(this.enterButton);
        buttonsPanel.add(this.cancelButton);
        JPanel bodyPanel = new JPanel();
        bodyPanel.setLayout(new GridBagLayout());
        this.addItem(bodyPanel, this.pinLabel, 0, 0, 1, 1, 13);
        this.addItem(bodyPanel, this.pinField, 1, 0, 2, 1, 17);
        this.addItem(bodyPanel, this.errorLabel, 0, 2, 3, 1, 10);
        this.addItem(bodyPanel, buttonsPanel, 0, 3, 3, 2, 10);
        this.getContentPane().add((Component)bodyPanel, "Center");
    }

    private void addItem(JPanel p, JComponent c, int x, int y, int width, int height, int align) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.gridwidth = width;
        gc.gridheight = height;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.anchor = align;
        gc.fill = 0;
        p.add((Component)c, gc);
    }

    public void setPin() {
        String tmp = this.pinField.getText();
        if (!tmp.isEmpty()) {
            this.pin = tmp;
        }
    }

    public String getPin() {
        return this.pin;
    }

    class CloseAction
    extends AbstractAction {
        private PinDialog parent;

        public CloseAction(PinDialog parent) {
            super(LanguageFactory.get_text("pindlg-button-close", new String[0]));
            this.parent = null;
            this.parent = parent;
        }

        public void actionPerformed(ActionEvent ev) {
            this.parent.dispose();
        }
    }

    class EnterAction
    extends AbstractAction {
        private PinDialog parent;

        public EnterAction(PinDialog parent) {
            super(LanguageFactory.get_text("pindlg-button-enter", new String[0]));
            this.parent = null;
            this.parent = parent;
        }

        public void actionPerformed(ActionEvent ev) {
            this.parent.setPin();
            this.parent.dispose();
        }
    }
}

