/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;

public class PacketDump {
    static final String HEXES = "0123456789ABCDEF";

    public static void dump(DatagramPacket packet) {
        byte[] data = packet.getData();
        String addr = packet.getAddress().getHostAddress();
        int port = packet.getPort();
        int length = packet.getLength();
        int offset = packet.getOffset();
        System.out.print(String.format("Addr: %s; Port: %d; Offset: %d; Length: %d; Data:", addr, port, offset, length));
        DataInputStream ds = new DataInputStream(new ByteArrayInputStream(data, 0, packet.getLength()));
        try {
            for (int i = 0; i < packet.getLength(); ++i) {
                if (i % 8 == 0) {
                    System.out.print("   ");
                }
                if (i % 16 == 0) {
                    System.out.print("\n\t\t\t");
                }
                byte b = ds.readByte();
                System.out.print(PacketDump.toHex(b) + " ");
            }
            System.out.println();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static String toHex(byte number) {
        StringBuilder hex = new StringBuilder(4);
        hex.append("0x");
        hex.append(HEXES.charAt((number & 0xF0) >> 4)).append(HEXES.charAt(number & 0xF));
        return hex.toString();
    }
}

