/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

public class OShell {
    private static final int PING_SIZE = 369;
    private static final String PING_DEST = "192.168.2.66";
    private static final String UNKNOWN_OS_Q = "";
    private static final String WIN32_Q = "cmd /C \"{0}\"";
    private static final String LINUX_Q = "{0}";
    private static final String MACOS_Q = "open {0}";
    private static final String[] OS_Q = new String[]{"", "{0}", "open {0}", "cmd /C \"{0}\"", "cmd /C \"{0}\""};
    private static final String[] OS_ARPADD_Q = new String[]{"", "arp -s {0} {1} -i {2}", "", "arp -s {0} {1} {2}", "arp -s {0} {1} {2}"};
    private static final String[] OS_ARPDEL_Q = new String[]{"", "arp -d {0}", "", "arp -d {0}", "arp -d {0}"};
    private static final String[] OS_PING_Q = new String[]{"", "ping {0} -s {1} -c {2} -w {3}", "", "ping {0} -l {1} -n {2} -w {3}", "ping {0} -l {1} -n {2} -w {3}"};
    private static final int OS_UNKNOWN = 0;
    private static final int OS_LINUX = 1;
    private static final int OS_MACOS = 2;
    private static final int OS_WINXP = 3;
    private static final int OS_WIN7 = 4;
    private int current_os = OShell.get_os();
    private static boolean verbose = false;
    private static String lastErr = "";
    private static Process aProcess = null;
    private static boolean cancel_seq = false;

    public static void set_verbose() {
        verbose = true;
    }

    private static int get_os() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return 0;
        }
        if (os.equalsIgnoreCase("linux")) {
            return 1;
        }
        if (os.equalsIgnoreCase("windows xp")) {
            return 3;
        }
        if (os.equalsIgnoreCase("windows 7")) {
            return 4;
        }
        if (os.startsWith("Mac")) {
            return 2;
        }
        return 0;
    }

    public static boolean is_windows_xp() {
        return OShell.get_os() == 3;
    }

    public static boolean is_windows_7() {
        return OShell.get_os() == 4;
    }

    public static boolean is_windows() {
        return OShell.is_windows_xp() || OShell.is_windows_7();
    }

    public static boolean is_linux() {
        return OShell.get_os() == 1;
    }

    public static boolean is_macos() {
        return OShell.get_os() == 2;
    }

    public static File get_java() {
        String java_home = System.getProperty("java.home");
        File java_path = new File(new File(new File(java_home), "bin"), "javaw.exe");
        return java_path;
    }

    public static File get_launcher() {
        File launcher_path = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return launcher_path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCmd(String string) {
        InputStream pipeOut = null;
        InputStream pipeErr = null;
        int exitCode = 0;
        byte[] buffer = new byte[2048];
        try {
            aProcess = Runtime.getRuntime().exec(string);
            if (aProcess == null) {
                int n = 1;
                return n;
            }
            pipeOut = aProcess.getInputStream();
            pipeErr = aProcess.getErrorStream();
            while (true) {
                try {
                    exitCode = aProcess.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    int read;
                    if (pipeOut.available() > 0) {
                        read = pipeOut.read(buffer);
                        if (verbose) {
                            System.out.println("Process STDOUT: " + new String(buffer).trim());
                        }
                    }
                    if (pipeErr.available() <= 0) continue;
                    read = pipeErr.read(buffer);
                    if (!verbose) continue;
                    System.out.println("Process STDERR: " + new String(buffer).trim());
                    continue;
                }
                break;
            }
            lastErr = new String(buffer);
            int e = exitCode;
            return e;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (pipeOut != null) {
                try {
                    pipeOut.close();
                }
                catch (IOException e) {}
            }
            if (pipeErr != null) {
                try {
                    pipeErr.close();
                }
                catch (IOException e) {}
            }
            aProcess = null;
        }
    }

    public int executeOsCmd(String cmd) {
        if (this.current_os == 0) {
            return -1;
        }
        String os_cmd = MessageFormat.format(OS_Q[this.current_os], cmd);
        System.out.println("[" + os_cmd + "]");
        return OShell.executeCmd(os_cmd);
    }

    private int addArp(String ip, String mac, String iface) {
        Object[] str_args = new Object[]{ip, this.current_os == 1 ? mac.replace('-', ':') : mac, iface};
        String cmd_ptrn = OS_ARPADD_Q[this.current_os];
        String cmd = MessageFormat.format(cmd_ptrn, str_args);
        return this.executeOsCmd(cmd);
    }

    private int delArp(String ip) {
        Object[] str_args = new Object[]{ip};
        String cmd_ptrn = OS_ARPDEL_Q[this.current_os];
        String cmd = MessageFormat.format(cmd_ptrn, str_args);
        return this.executeOsCmd(cmd);
    }

    private int clearArpCache() {
        if (!OShell.is_windows()) {
            return 0;
        }
        return this.executeOsCmd("netsh interface ip delete arpcache");
    }

    private int ping(String ip, int timeout) {
        Object[] str_args = new Object[]{ip, 369, 15, timeout};
        if (OShell.is_windows()) {
            str_args[2] = timeout;
            str_args[3] = 1000;
        }
        String cmd_ptrn = OS_PING_Q[this.current_os];
        String cmd = MessageFormat.format(cmd_ptrn, str_args);
        return this.executeOsCmd(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reset(String mac, String iface, int timeout) {
        cancel_seq = false;
        int result = this.delArp(PING_DEST);
        try {
            result = this.addArp(PING_DEST, mac, iface);
            if (result != 0) {
                int n = result;
                return n;
            }
            this.ping(PING_DEST, timeout);
        }
        finally {
            result = this.delArp(PING_DEST);
            if (OShell.is_windows()) {
                this.clearArpCache();
            }
        }
        return result;
    }

    public String get_last_err() {
        return lastErr;
    }

    public void cancel_reset() {
        if (aProcess != null) {
            aProcess.destroy();
        }
        aProcess = null;
        cancel_seq = true;
    }
}

