/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.BinUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;

class MCastPacket {
    private byte proto_ver;
    private byte pad1;
    private byte proto_cmd;
    private byte pad2;
    private long srce_id;
    private long dest_id;
    protected byte[] raw_data;
    protected int raw_data_len;

    public MCastPacket(DatagramPacket packet) throws IOException {
        this.raw_data = packet.getData();
        this.raw_data_len = packet.getLength();
        this.parse();
    }

    public MCastPacket(MCastPacket p) {
        this.proto_ver = p.proto_ver;
        this.pad1 = 0;
        this.proto_cmd = p.proto_cmd;
        this.pad2 = 0;
        this.srce_id = p.srce_id;
        this.dest_id = p.dest_id;
        this.raw_data = p.raw_data;
        this.raw_data_len = p.raw_data_len;
    }

    public MCastPacket(byte proto_ver, byte proto_cmd, long srce_id, long dest_id) {
        this.proto_ver = proto_ver;
        this.proto_cmd = proto_cmd;
        this.srce_id = srce_id;
        this.dest_id = dest_id;
        this.pad1 = 0;
        this.pad2 = 0;
    }

    private void parse() throws IOException {
        DataInputStream ds = new DataInputStream(new ByteArrayInputStream(this.raw_data, 0, this.raw_data_len));
        this.proto_ver = ds.readByte();
        ds.readByte();
        this.proto_cmd = ds.readByte();
        ds.readByte();
        this.srce_id = ds.readLong();
        this.dest_id = ds.readLong();
    }

    public boolean no_data() {
        return this.get_size() == this.raw_data_len;
    }

    public int get_size() {
        return 20;
    }

    public byte get_version() {
        return this.proto_ver;
    }

    public byte get_cmd() {
        return this.proto_cmd;
    }

    public long get_srce() {
        return this.srce_id;
    }

    public long get_dest() {
        return this.dest_id;
    }

    public int to_array(byte[] request) {
        BinUtils.extend_arr(request, 0, this.proto_ver);
        BinUtils.extend_arr(request, 1, this.pad1);
        BinUtils.extend_arr(request, 2, this.proto_cmd);
        BinUtils.extend_arr(request, 3, this.pad2);
        BinUtils.extend_arr(request, 4, this.srce_id);
        BinUtils.extend_arr(request, 12, this.dest_id);
        return this.get_size();
    }
}

