/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;

class LegacyResponse {
    private byte proto_ver;
    private byte proto_cmd;
    protected byte[] raw_data;
    protected int raw_data_len;

    public LegacyResponse(DatagramPacket packet) throws IOException {
        this.raw_data = packet.getData();
        this.raw_data_len = packet.getLength();
        this.parse();
    }

    public LegacyResponse(LegacyResponse p) {
        this.proto_ver = p.proto_ver;
        this.proto_cmd = p.proto_cmd;
        this.raw_data = p.raw_data;
        this.raw_data_len = p.raw_data_len;
    }

    private void parse() throws IOException {
        DataInputStream ds = new DataInputStream(new ByteArrayInputStream(this.raw_data, 0, this.raw_data_len));
        this.proto_ver = ds.readByte();
        this.proto_cmd = ds.readByte();
    }

    public boolean no_data() {
        return this.get_size() == this.raw_data_len;
    }

    public int get_size() {
        return 2;
    }

    public byte get_version() {
        return this.proto_ver;
    }

    public byte get_cmd() {
        return this.proto_cmd;
    }
}

