/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.LegacyResponse;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

class LegacyInfoResponse
extends LegacyResponse {
    private byte[] mac;
    private byte[] ip;
    private byte[] fw_version;
    private int fw_len;

    public LegacyInfoResponse(DatagramPacket p) throws IOException {
        super(p);
        this.parse();
    }

    public LegacyInfoResponse(LegacyResponse p) throws IOException {
        super(p);
        this.parse();
    }

    private void parse() throws IOException {
        this.mac = new byte[6];
        this.ip = new byte[4];
        int offset = super.get_size();
        DataInputStream ds = new DataInputStream(new ByteArrayInputStream(this.raw_data, offset, this.raw_data_len));
        ds.read(this.mac, 0, this.mac.length);
        ds.read(this.ip, 0, this.ip.length);
        this.fw_len = ds.readInt();
        if (this.fw_len > 0) {
            this.fw_version = new byte[this.fw_len];
            ds.read(this.fw_version, 0, this.fw_version.length);
        }
    }

    public int get_size() {
        return this.mac.length + this.ip.length + this.fw_version.length + 4;
    }

    public String get_mac() {
        return this.formatMac(this.mac);
    }

    public String get_ip() {
        try {
            String x = InetAddress.getByAddress(this.ip).getHostAddress();
            return x;
        }
        catch (UnknownHostException unknownHostException) {
            return "0.0.0.0";
        }
    }

    public String get_firmware() {
        return new String(this.fw_version).trim();
    }

    private String formatMac(byte[] macAddr) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < macAddr.length; ++i) {
            int b = macAddr[i] & 0xFF;
            int f = b / 16;
            int s = b % 16;
            if (f == 0) {
                str.append("0");
            } else {
                str.append(Integer.toHexString(f).toUpperCase());
            }
            str.append(Integer.toHexString(s).toUpperCase());
            if (i >= macAddr.length - 1) continue;
            str.append('-');
        }
        return str.toString();
    }
}

