/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.BinUtils;
import com.wilibox.discovery.MCastPacket;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;

class ExtendPacket
extends MCastPacket {
    private byte time;
    private byte[] pin;

    public ExtendPacket(DatagramPacket p) throws IOException {
        super(p);
        this.parse();
    }

    public ExtendPacket(MCastPacket p) throws IOException {
        super(p);
        this.parse();
    }

    public ExtendPacket(byte proto_ver, byte proto_cmd, long srce_id, long dest_id, byte time) {
        super(proto_ver, proto_cmd, srce_id, dest_id);
        this.time = time;
    }

    public ExtendPacket(byte proto_ver, byte proto_cmd, long srce_id, long dest_id, byte[] pin) {
        super(proto_ver, proto_cmd, srce_id, dest_id);
        this.pin = pin;
    }

    private void parse() throws IOException {
        int offset = super.get_size();
        DataInputStream ds = new DataInputStream(new ByteArrayInputStream(this.raw_data, offset, this.raw_data_len));
        this.time = ds.readByte();
    }

    public int get_size(int dataLength) {
        return super.get_size() + dataLength;
    }

    public byte get_time() {
        return this.time;
    }

    public int to_array(byte[] request) {
        super.to_array(request);
        if (this.pin == null) {
            BinUtils.extend_arr(request, super.get_size(), this.time);
            return this.get_size(1);
        }
        BinUtils.extend_arr(request, super.get_size(), this.pin);
        return this.get_size(4);
    }
}

