/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.BinUtils;
import com.wilibox.discovery.Device;
import com.wilibox.discovery.DiscoveryProtoListener;
import com.wilibox.discovery.ExtendPacket;
import com.wilibox.discovery.InfoPacket;
import com.wilibox.discovery.MCastPacket;
import com.wilibox.discovery.MulticastQueryServer;
import com.wilibox.discovery.PacketDump;
import com.wilibox.discovery.ProtocolException;
import com.wilibox.discovery.SocketInfo;
import com.wilibox.discovery.StatePacket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DiscoveryProto
implements Runnable {
    private static final Logger logger = Logger.getLogger(DiscoveryProto.class.getName());
    private static boolean verbose = false;
    private static byte proto_version;
    private static final byte[] MULTICAST_ADDR;
    private static final int MULTICAST_PORT = 45678;
    private static final byte PROTO_VERSION_1 = 1;
    private static final byte PROTO_VERSION_2 = 2;
    private static final byte PROTO_CMD_DISCOVERY = 0;
    private static final byte PROTO_CMD_WNMS_HB = 1;
    private static final byte PROTO_CMD_RESET = 2;
    private static final byte PROTO_CMD_STATE = 3;
    private static final byte PROTO_CMD_EXTEND = 4;
    private static final byte PROTO_CMD_BOOT = 5;
    private static final byte PROTO_CMD_PIN = 6;
    public static final byte ST_BOOT = 1;
    public static final byte ST_READY = 2;
    public static final byte ST_RESETING = 4;
    public static final byte ST_EXTENDED = 8;
    public static final byte ST_MARKED = 16;
    public static final byte ST_WRONGPIN = 32;
    public static final long BCAST_ID = -1L;
    private static final byte DEFAULT_EXTEND_TIME_1 = 30;
    private static final byte DEFAULT_EXTEND_TIME_2 = 60;
    private static final int OUTPUT_BUFFER_SIZE = 255;
    private static long self_id;
    private static boolean auto_extend;
    private static byte[] output_buffer;
    protected EventListenerList listenerList = new EventListenerList();
    private Thread readerThread;
    private MulticastQueryServer server;

    public DiscoveryProto(int verbosity) throws ProtocolException {
        boolean bl = verbose = verbosity != 0;
        if (verbose) {
            logger.setLevel(Level.ALL);
        }
        logger.log(Level.FINE, "Initializing Discovery protocol");
        this.server = new MulticastQueryServer(MULTICAST_ADDR, 45678);
        if (verbose) {
            this.server.setVerbose();
        }
        if (this.server.create_sockets() != 0) {
            throw new ProtocolException("Failed reset (v1) protocol sockets create");
        }
        byte[] mac = this.server.get_mac();
        if (mac != null) {
            self_id = BinUtils.arr_to_long(mac);
        } else {
            self_id = BinUtils.random_long();
            logger.log(Level.FINE, "SELF ID generated");
        }
        this.readerThread = new Thread(this);
        this.readerThread.start();
    }

    public MulticastQueryServer getServer() {
        return this.server;
    }

    public void set_autoextend(boolean state) {
        auto_extend = state;
    }

    public boolean get_autoextend() {
        return auto_extend;
    }

    public byte get_proto_ver() {
        return proto_version;
    }

    public int send(byte[] data, int size) {
        InetAddress addr;
        try {
            addr = InetAddress.getByAddress(MULTICAST_ADDR);
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Multicast address cast failed", e);
            return -1;
        }
        DatagramPacket packet = new DatagramPacket(data, size, addr, 45678);
        int status = this.server.write_sockets(packet);
        if (status == 0) {
            this.readerThread.interrupt();
        }
        return status;
    }

    public int send_discovery(long dest_id, byte proto) {
        MCastPacket m_packet = new MCastPacket(proto, 0, self_id, dest_id);
        int size = m_packet.to_array(output_buffer);
        return this.send(output_buffer, size);
    }

    public int send_reset(long dest_id) {
        MCastPacket m_packet = new MCastPacket(proto_version, 2, self_id, dest_id);
        int size = m_packet.to_array(output_buffer);
        return this.send(output_buffer, size);
    }

    public int send_pin(long dest_id, byte[] pin) {
        ExtendPacket e_packet = new ExtendPacket(proto_version, 6, self_id, dest_id, pin);
        int size = e_packet.to_array(output_buffer);
        return this.send(output_buffer, size);
    }

    public int send_extend(long dest_id, byte time) {
        ExtendPacket e_packet = new ExtendPacket(proto_version, 4, self_id, dest_id, time);
        int size = e_packet.to_array(output_buffer);
        return this.send(output_buffer, size);
    }

    public int send_boot(long dest_id) {
        MCastPacket m_packet = new MCastPacket(proto_version, 5, self_id, dest_id);
        int size = m_packet.to_array(output_buffer);
        return this.send(output_buffer, size);
    }

    public int send_state(long dest_id) {
        MCastPacket m_packet = new MCastPacket(proto_version, 3, self_id, dest_id);
        int size = m_packet.to_array(output_buffer);
        return this.send(output_buffer, size);
    }

    public void send_discovery() {
        long dest_id = BinUtils.mac_to_long("FF-FF-FF-FF-FF-FF");
        this.send_discovery(dest_id, (byte)1);
        this.send_discovery(dest_id, (byte)2);
    }

    public int send_discovery(String dest_mac, byte proto) {
        return this.send_discovery(BinUtils.mac_to_long(dest_mac), proto);
    }

    public int send_reset(String dest_mac) {
        return this.send_reset(BinUtils.mac_to_long(dest_mac));
    }

    public int send_pin(String dest_mac, String pin) {
        return this.send_pin(BinUtils.mac_to_long(dest_mac), pin.getBytes());
    }

    public int send_boot(String dest_mac) {
        return this.send_boot(BinUtils.mac_to_long(dest_mac));
    }

    public int send_state(String dest_mac) {
        return this.send_state(BinUtils.mac_to_long(dest_mac));
    }

    public int parse_packet(DatagramPacket packet, SocketInfo sinfo) {
        try {
            String sender = packet.getAddress().getHostAddress();
            String iface = sinfo.getInterface();
            MCastPacket m_packet = new MCastPacket(packet);
            if (m_packet.no_data()) {
                logger.log(Level.INFO, "Received loopback multicast packet");
                return 1;
            }
            if (m_packet.get_version() != 1 && m_packet.get_version() != 2) {
                logger.log(Level.INFO, "Received unknonwn multicast response: {0}", m_packet.get_version());
                return 2;
            }
            proto_version = (byte)2;
            if (m_packet.get_version() == 1) {
                proto_version = 1;
            }
            switch (m_packet.get_cmd()) {
                case 0: {
                    InfoPacket d_packet = new InfoPacket(m_packet);
                    Device dev = new Device(d_packet.get_mac(), InetAddress.getByName(d_packet.get_ip()), d_packet.get_firmware(), sender, sinfo);
                    if (verbose) {
                        System.out.println(String.format("%-15s: device info MAC %s", sender, d_packet.get_mac()));
                    }
                    this.fireDiscoveredDevice(dev);
                    break;
                }
                case 3: {
                    StatePacket s_packet = new StatePacket(m_packet);
                    if (verbose) {
                        System.out.println(String.format("%-15s: device state %d", sender, s_packet.get_state()));
                    }
                    if ((s_packet.get_state() & 1) != 0 && (s_packet.get_state() & 8) == 0) {
                        if (auto_extend) {
                            if (m_packet.get_version() == 2) {
                                this.send_extend(s_packet.get_srce(), (byte)60);
                            } else {
                                this.send_extend(s_packet.get_srce(), (byte)30);
                            }
                            if (verbose) {
                                System.out.println(String.format("Request %-15s: extend boot", sender));
                            }
                        } else {
                            this.send_extend(s_packet.get_srce(), (byte)0);
                            if (verbose) {
                                System.out.println(String.format("Request %-15s: dont extend", sender));
                            }
                        }
                    }
                    if ((s_packet.get_state() & 8) != 0) {
                        this.send_discovery(s_packet.get_srce(), proto_version);
                        if (verbose) {
                            System.out.println(String.format("Request %-15s: device info", sender));
                        }
                    }
                    this.fireDeviceState(s_packet.get_state(), BinUtils.long_to_mac(m_packet.get_srce()));
                    break;
                }
                default: {
                    System.out.println("Received unknown command (" + m_packet.get_cmd() + ") from " + sender);
                    if (!verbose) break;
                    PacketDump.dump(packet);
                }
            }
            return 0;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Parse error, dropping packet", e);
            if (verbose) {
                PacketDump.dump(packet);
            }
            return -1;
        }
    }

    public void run() {
        DatagramPacket packet = new DatagramPacket(new byte[1500], 1500);
        SocketInfo sinfo = new SocketInfo();
        while (true) {
            int status;
            if ((status = this.server.read_sockets(packet, sinfo)) != 0) {
                continue;
            }
            this.parse_packet(packet, sinfo);
        }
    }

    public void addListener(DiscoveryProtoListener l) {
        this.listenerList.add(DiscoveryProtoListener.class, l);
    }

    public void removeListener(DiscoveryProtoListener l) {
        this.listenerList.remove(DiscoveryProtoListener.class, l);
    }

    protected void fireDiscoveredDevice(Device dev) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DiscoveryProtoListener.class) continue;
            DiscoveryProtoListener l = (DiscoveryProtoListener)listeners[i + 1];
            l.deviceFound(dev);
        }
    }

    protected void fireDeviceState(byte state, String mac) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DiscoveryProtoListener.class) continue;
            DiscoveryProtoListener l = (DiscoveryProtoListener)listeners[i + 1];
            if ((state & 1) > 0) {
                l.deviceBootState(mac);
            }
            if ((state & 2) > 0) {
                l.deviceWorkState(mac);
            }
            if ((state & 4) > 0) {
                l.deviceReseting(mac);
            }
            if ((state & 8) > 0) {
                l.deviceExtended(mac);
            }
            if ((state & 0x10) > 0) {
                l.deviceMarked(mac);
            }
            if ((state & 0x20) <= 0) continue;
            l.deviceWrongPin(mac);
        }
    }

    static {
        MULTICAST_ADDR = new byte[]{-23, 89, -68, 1};
        self_id = 0L;
        auto_extend = true;
        output_buffer = new byte[255];
    }
}

