/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.reportform;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.wdm.reportform.TENESlotReport;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public class TENEQuerySlotReportBean
extends TENEExplorerBean {
    private static final int BOARD_IN_POSITION = 1;
    private static final int BOARD_OUT_POSITION = 0;
    private ArrayList slotReportList = new ArrayList();
    private Vector logicBoardList = new Vector();
    private Vector physicsBoardList = new Vector();

    public Datainterface performBussinessProcess(int neID, SubFunc subFuc, Datainterface inputData, Datainterface MemoryData, String user, String ipAddress) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        this.logicBoardList = ne.getBoardList();
        this.physicsBoardList = ne.getPhyBoardList();
        this.slotReportList = this.getSlotReportList(this.logicBoardList, this.physicsBoardList);
        Datainterface sltReportDi = new Datainterface();
        BussinessParams sltReportBParams = new BussinessParams();
        Param tempWdmParam = null;
        if (null != this.slotReportList && this.slotReportList.size() > 0) {
            int slotReportSize = this.slotReportList.size();
            for (int i = 0; i < slotReportSize; ++i) {
                TENESlotReport temtSlotReport = (TENESlotReport)this.slotReportList.get(i);
                RowParams sltReportRParams = new RowParams();
                tempWdmParam = new Param();
                tempWdmParam.setName("serialNum");
                tempWdmParam.setValue(new Integer(i).toString());
                sltReportRParams.addParam(tempWdmParam);
                tempWdmParam = new Param();
                tempWdmParam.setName("slotId");
                tempWdmParam.setValue(new Integer(temtSlotReport.getSlotID()).toString());
                sltReportRParams.addParam(tempWdmParam);
                String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neID, (int)temtSlotReport.getSlotID());
                if (subrackName != null && !subrackName.equals("")) {
                    tempWdmParam = new Param("shelfName", subrackName);
                    sltReportRParams.addParam(tempWdmParam);
                }
                tempWdmParam = new Param();
                tempWdmParam.setName("nePhysicsBd");
                tempWdmParam.setValue(temtSlotReport.getPhyBdName());
                sltReportRParams.addParam(tempWdmParam);
                tempWdmParam = new Param();
                tempWdmParam.setName("neLogicBd");
                tempWdmParam.setValue(temtSlotReport.getLogicBdName());
                sltReportRParams.addParam(tempWdmParam);
                tempWdmParam = new Param();
                tempWdmParam.setName("nebdAttr");
                tempWdmParam.setValue(new Integer(temtSlotReport.getBoardAttr()).toString());
                sltReportRParams.addParam(tempWdmParam);
                sltReportBParams.addRowParams(sltReportRParams);
            }
            sltReportDi.setBussinessParams(sltReportBParams);
        }
        sltReportDi.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
        if (this.isNeedOperationlog()) {
            this.writeLog(neID, subFuc, inputData, user, ipAddress, sltReportDi);
        }
        return sltReportDi;
    }

    public ArrayList getSlotReportList(Vector logicWdmBoardList, Vector physicsBoardList) {
        if (null != this.slotReportList && this.slotReportList.size() > 0) {
            this.slotReportList.clear();
        }
        if (null != logicWdmBoardList && logicWdmBoardList.size() > 0) {
            int logicListSize = logicWdmBoardList.size();
            for (int i = 0; i < logicListSize; ++i) {
                TENESlotReport slotReportItem = new TENESlotReport();
                TEBoard wdmboard = (TEBoard)logicWdmBoardList.get(i);
                slotReportItem.setSlotID(wdmboard.getSlotID());
                slotReportItem.setLogicBdType(wdmboard.getBoardType());
                slotReportItem.setLogicBdName(wdmboard.getBoardName());
                if (null != physicsBoardList && physicsBoardList.size() > 0) {
                    int phyListSize = physicsBoardList.size();
                    for (int j = 0; j < phyListSize; ++j) {
                        TEBoard phyWdmBoard = (TEBoard)physicsBoardList.get(j);
                        if (slotReportItem.getSlotID() != phyWdmBoard.getSlotID()) continue;
                        slotReportItem.setPhyBdType(phyWdmBoard.getBoardType());
                        slotReportItem.setPhyBdName(phyWdmBoard.getBoardName());
                    }
                }
                if (slotReportItem.getLogicBdType() == slotReportItem.getPhyBdType()) {
                    slotReportItem.setBoardAttr(1);
                } else {
                    slotReportItem.setBoardAttr(0);
                }
                this.slotReportList.add(slotReportItem);
            }
        }
        if (null != physicsBoardList && !physicsBoardList.isEmpty()) {
            int phyListSize = physicsBoardList.size();
            for (int i = 0; i < phyListSize; ++i) {
                boolean existFlag = false;
                TEBoard phyWdmBoard = (TEBoard)physicsBoardList.get(i);
                if (null != this.slotReportList && this.slotReportList.size() > 0) {
                    int slotReportSize = this.slotReportList.size();
                    for (int j = 0; j < slotReportSize; ++j) {
                        TENESlotReport tempSlotReport = (TENESlotReport)this.slotReportList.get(j);
                        if (tempSlotReport.getSlotID() != phyWdmBoard.getSlotID()) continue;
                        existFlag = true;
                        break;
                    }
                }
                if (existFlag) continue;
                TENESlotReport slotReportItem = new TENESlotReport();
                slotReportItem.setSlotID(phyWdmBoard.getSlotID());
                slotReportItem.setLogicBdType(-1);
                slotReportItem.setLogicBdName("");
                slotReportItem.setPhyBdName(phyWdmBoard.getBoardName());
                slotReportItem.setBoardAttr(0);
                this.slotReportList.add(slotReportItem);
            }
        }
        Collections.sort(this.slotReportList);
        return this.slotReportList;
    }

    public ArrayList sortSlorReport(ArrayList srcWdmList) {
        ArrayList<TENESlotReport> newslotReport = new ArrayList<TENESlotReport>();
        Collections.sort(srcWdmList);
        if (null != srcWdmList && srcWdmList.size() > 0) {
            int srcListSize = srcWdmList.size();
            for (int i = 0; i < srcListSize; ++i) {
                TENESlotReport tempSlotInfoItem1 = (TENESlotReport)srcWdmList.get(i);
                for (int j = i + 1; j < srcListSize; ++j) {
                    TENESlotReport tempSlotInfoItem2 = (TENESlotReport)srcWdmList.get(j);
                    if (tempSlotInfoItem1.getSlotID() <= tempSlotInfoItem2.getSlotID()) continue;
                    tempSlotInfoItem1 = tempSlotInfoItem2;
                }
                newslotReport.add(tempSlotInfoItem1);
            }
        }
        return newslotReport;
    }

    public boolean isNeedOperationlog() {
        return true;
    }
}

