/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSCache;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSData;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TEPRBSUtility {
    private static List<String> listeners = Collections.synchronizedList(new ArrayList());
    private static TENormalTestNoticeHandler normalNotice = new TENormalTestNoticeHandler();

    public static String getPortName(int neid, int slotid, int portid, int path) {
        String nename = TENEListMgr.getInstance().getNE(neid).getNEName();
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        if (board == null) {
            return "-";
        }
        int boardtype = board.getBoardType();
        String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, portid);
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
        StringBuffer name = new StringBuffer();
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid);
        name.append(nename);
        if (subrackName != null && !subrackName.equals("")) {
            name.append("-").append(subrackName);
            slotid = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid);
        }
        name.append("-" + slotid).append("-" + boardname).append("-").append(portname);
        if (path > 0) {
            name.append("-").append(path);
        }
        return name.toString();
    }

    public static void registerListener(int neID, String hashvalue) {
        try {
            if (listeners.size() == 0) {
                Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neID);
                Operation oper = definitions.getOperation("NSEVT_CFG_PRBS_AUTOREP");
                TENECommMgr.getInstance().registerListener(oper, (NoticeHandler)normalNotice);
            }
            listeners.add(hashvalue);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    public static void unregisterListener(int neID, String hashvalue) {
        try {
            listeners.remove(hashvalue);
            if (listeners.size() == 0) {
                Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neID);
                Operation oper = definitions.getOperation("NSEVT_CFG_PRBS_AUTOREP");
                TENECommMgr.getInstance().unregisterListener(oper, (NoticeHandler)normalNotice);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    public static void registerListener(int neID) {
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSEVT_CFG_PRBS_AUTOREP");
            TENECommMgr.getInstance().registerListener(oper, (NoticeHandler)normalNotice);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    public static void unregisterListener(int neID) {
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSEVT_CFG_PRBS_AUTOREP");
            TENECommMgr.getInstance().unregisterListener(oper, (NoticeHandler)normalNotice);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    static class TENormalTestNoticeHandler
    implements NoticeHandler {
        TENormalTestNoticeHandler() {
        }

        public void handleNotice(int cmdkey, int neID, Operation operation) {
            String slotid = "";
            String portid = "";
            String path = "";
            int testtime = 0;
            long errnum = 0L;
            long prbslosNum = 0L;
            int testStatus = 0;
            Output[] outputArr = operation.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                Part p = outputArr[i].getPart("slotid");
                slotid = p.getValue();
                p = outputArr[i].getPart("portid");
                portid = p.getValue();
                p = outputArr[i].getPart("path");
                path = p.getValue();
                p = outputArr[i].getPart("periodNum");
                testtime = new Integer(p.getValue());
                p = outputArr[i].getPart("prbsLos");
                if (null != p && !p.getValue().equals("")) {
                    prbslosNum = Long.parseLong(p.getValue());
                }
                p = outputArr[i].getPart("incrementNum");
                errnum = Long.parseLong(p.getValue());
                p = outputArr[i].getPart("testStatus");
                testStatus = Integer.parseInt(p.getValue());
            }
            String hashvalue = TEPRBSUtility.getPortName(neID, Integer.parseInt(slotid), Integer.parseInt(portid), Integer.parseInt(path));
            if (testStatus == 0) {
                TEPRBSUtility.unregisterListener(neID, hashvalue);
                return;
            }
            TEPRBSCache testcache = TEPRBSCache.getInstance();
            TEPRBSData testdata = testcache.getCahce(hashvalue);
            if (testdata == null) {
                return;
            }
            if (testdata.getTeststate() == -1) {
                testdata.setTeststate(1);
            }
            if (testdata.getTeststate() != 1) {
                return;
            }
            if (errnum <= 0L) {
                errnum = 0L;
            }
            testdata.refreshdata(testtime, errnum, prbslosNum);
        }
    }
}

