/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSCache;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSData;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSUtility;
import com.huawei.nglct.util.device.board.TEQueryBoardInfoBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class TEPRBSTableInitBean
extends TENEExplorerBean {
    private int slotid = 0;
    private static final int BDTYPE_TNF1ELQM = 2446;
    private List<String> bdModeSpList = new ArrayList<String>();
    private List<String> portModeSpList = new ArrayList<String>();

    /*
     * Enabled aggressive block sorting
     */
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        BussinessParams bussiness = new BussinessParams();
        this.outputData = new Datainterface();
        Param para = rowpara.getParam("slotid");
        RowParams rowdata = null;
        TEPRBSData testdata = null;
        String hashvalue = null;
        TEGenCfgPortAttribute portObj = null;
        int portid = -1;
        this.slotid = Integer.parseInt(para.getValue());
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, this.slotid);
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType());
        if (null == genCfgModel) {
            TELogFactory.getNormalLogger().error("the gencfgmodel of the board is not exist");
            this.outputData.setBussinessParams(bussiness);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        TEGenCfgAttribute attrObj = genCfgModel.getAttrFromId("W32PORT_ATTR_PRBSTEST");
        if (null == attrObj) {
            TELogFactory.getNormalLogger().error("the TEGenCfgAttribute of the board is not exist");
            this.outputData.setBussinessParams(bussiness);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        this.bdModeSpList.addAll(TESpecialAttrMgr.getInstance().getCPAttrListValue(neid, this.slotid, "TE_FUNC_CFG_NGWDM_PRBS", "OTN_PRBS_NOTSUPPORT_PORTSANDPATHS_ONSPECIAL_BOARDMODE"));
        ArrayList portList = attrObj.getPortList();
        if (null == portList || 0 == portList.size()) {
            TELogFactory.getNormalLogger().error("there is not port");
            this.outputData.setBussinessParams(bussiness);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        ArrayList<Integer> slotIdList = new ArrayList<Integer>();
        slotIdList.add(this.slotid);
        TEQueryBoardInfoBean.queryBoardInfo((int)neid, slotIdList);
        int boardMode = this.getBoardMode();
        int i = 0;
        int len = portList.size();
        while (true) {
            block13: {
                if (i >= len) {
                    this.outputData.setBussinessParams(bussiness);
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                    return this.outputData;
                }
                portObj = (TEGenCfgPortAttribute)portList.get(i);
                portid = portObj.getPort();
                if (!TEPRBSTableInitBean.getIsCurrentPayloadType(neid, this.slotid, portid)) break block13;
                switch (board.getBoardType()) {
                    case 2446: {
                        if (boardMode != 23 || portid != 5 && portid != 6) break;
                        break block13;
                    }
                    case 2447: 
                    case 2555: {
                        if (boardMode != 25 && boardMode != 24 || portid != 9 && portid != 10) break;
                        break block13;
                    }
                    case 2415: 
                    case 2557: {
                        if (boardMode == 18 || boardMode == 24) break block13;
                    }
                }
                if (this.checkValidByConfMode(boardMode, this.slotid, portid, portObj.getPath())) {
                    hashvalue = TEPRBSUtility.getPortName(neid, this.slotid, portid, portObj.getPath());
                    testdata = TEPRBSCache.getInstance().getCahce(hashvalue);
                    if (testdata == null) {
                        rowdata = this.getBlankData(portid, portObj.getPath());
                        rowdata.addParam("path", String.valueOf(portObj.getPath()));
                    } else {
                        rowdata = this.getSaveData(testdata);
                    }
                    bussiness.addRowParams(rowdata);
                }
            }
            ++i;
        }
    }

    private static boolean getIsCurrentPayloadType(int neID, int slotID, int port) {
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_GET_PAYLOADTYPE");
            Input input = oper.getInput();
            Part part = input.getPart("slotid");
            part.setValue(String.valueOf(slotID));
            part = input.getPart("port");
            part.setValue(String.valueOf(port));
            part = input.getPart("path");
            part.setValue("1");
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)60).retCode;
            if (result == 0) {
                Output[] outputArr = ((Operation)operationList.get(0)).getOutput();
                for (int j = 0; j < outputArr.length; ++j) {
                    if (outputArr[j].getFaultCount() <= 0 || Integer.parseInt(outputArr[j].getFault(0).getCode()) != 0) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse Qx description file fail!", (Throwable)e);
        }
        return false;
    }

    private int getBoardMode() {
        Output temp;
        ArrayList<Operation> list = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_SUBBDTYPE");
        oper.getInput().getPart("slotid").setValue(String.valueOf(this.slotid));
        list.add(oper);
        int result = this.sendMessage(this.neid, list);
        if (result == 0 && (temp = oper.getOutput(0)).getFault(0).getCode().equals("0")) {
            return Integer.parseInt(temp.getPart("W32BD_ATTR_SUBBDTYPE").getValue());
        }
        return -1;
    }

    private RowParams getBlankData(int portid, int path) {
        RowParams param = new RowParams();
        String portname = TEPRBSUtility.getPortName(this.neid, this.slotid, portid, path);
        param.addParam("portid", portid + "");
        param.addParam("portname", portname);
        param.addParam("channel", "-");
        param.addParam("direction", "1");
        param.addParam("timeunit", "1");
        param.addParam("testtime", "1");
        param.addParam("starttime", "-");
        param.addParam("progress", "0%");
        param.addParam("totalErrNum", "0");
        param.addParam("isaccu", "0");
        param.addParam("teststate", "0");
        return param;
    }

    private RowParams getSaveData(TEPRBSData testdata) {
        this.handledata(testdata);
        RowParams param = new RowParams();
        String portname = TEPRBSUtility.getPortName(this.neid, this.slotid, testdata.getPortid(), testdata.getPath());
        param.addParam("portid", testdata.getPortid() + "");
        param.addParam("portname", portname);
        param.addParam("channel", testdata.getDirection() + "");
        param.addParam("path", testdata.getPath() + "");
        param.addParam("timeunit", testdata.getTimeUnit() + "");
        param.addParam("testtime", testdata.getTesttime() + "");
        param.addParam("starttime", this.getStarttime(testdata));
        param.addParam("progress", testdata.getProgress() + "%");
        param.addParam("totalErrNum", testdata.getTotalErrNum() + "");
        param.addParam("isaccu", testdata.isAccumulation() + "");
        param.addParam("teststate", testdata.getTeststate() + "");
        param.addParam("direction", testdata.getDirection() + "");
        return param;
    }

    private String getStarttime(TEPRBSData testdata) {
        Calendar startTime = Calendar.getInstance();
        startTime.setTimeInMillis(testdata.getStartTime());
        String formatstr = TimeZoneDateBean.getTimeConvertFormat();
        SimpleDateFormat dataFormatterOther = new SimpleDateFormat(formatstr, Locale.ENGLISH);
        return dataFormatterOther.format(startTime.getTime());
    }

    private void handledata(TEPRBSData testdata) {
        if (testdata.getTeststate() == 0 || testdata.getTeststate() == -1) {
            return;
        }
        int timeUnit = testdata.getTimeUnit();
        int abletime = 0;
        abletime = timeUnit == 1 ? 25000 : 900000;
        Date d = new Date();
        long current = d.getTime();
        long lastreporttime = testdata.getLastreportTime();
        if (lastreporttime == 0L && testdata.getQueryList().size() <= 0) {
            testdata.setTeststate(1);
            return;
        }
        if (current - lastreporttime > (long)abletime) {
            testdata.setTeststate(0);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private boolean checkValidByConfMode(int bdMode, int slotid, int portid, int path) {
        boolean result = true;
        if (this.bdModeSpList.isEmpty()) {
            return result;
        }
        if (!this.bdModeSpList.isEmpty() && bdMode != -1) {
            result = this.getCheckResult(this.bdModeSpList, bdMode, slotid, portid, path);
        }
        return result;
    }

    private boolean getCheckResult(List<String> modeStrList, int mode, int slotid, int portid, int path) {
        boolean result = true;
        try {
            List<Object> paths = new ArrayList();
            for (String str : modeStrList) {
                String tempStr;
                int index;
                String tempPort;
                String modeStr = str.substring(0, str.indexOf("("));
                if (!modeStr.equals(mode + "") || !"0".equals(tempPort = (index = (tempStr = str.substring(str.indexOf("(") + 1, str.lastIndexOf(")"))).indexOf("{")) == -1 ? tempStr : tempStr.substring(0, tempStr.indexOf("{"))) && !(portid + "").equals(tempPort)) continue;
                if ("0".equals(tempPort)) {
                    result = false;
                } else {
                    if (index == -1) continue;
                    if ("0".equals(tempStr = tempStr.substring(tempStr.indexOf("{") + 1, tempStr.lastIndexOf("}")))) {
                        result = false;
                    } else {
                        paths = Arrays.asList(tempStr.split(";"));
                        if (!paths.contains("" + path)) continue;
                        result = false;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse failed!", (Throwable)e);
        }
        return result;
    }
}

