/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSCache;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSData;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class TEPRBSStartBean
extends TENEExplorerBean {
    private boolean isLogFlag = true;
    String hashvalue = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            this.handleData(inputData);
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeAllLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        StringBuffer filePath = new StringBuffer("ngwdm").append(File.separator).append("res").append(File.separator).append("prbs").append(File.separator).append("prbsres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        String des = "";
        RowParams rowpara = this.inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        int slotid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("portid");
        int portid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("timeunit");
        int timeunit = Integer.parseInt(para.getValue());
        para = rowpara.getParam("testtime");
        int testtime = Integer.parseInt(para.getValue());
        des = des + resourceUtil.getString("slot") + TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid) + "-" + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid) + "," + resourceUtil.getString("port") + portid + "," + resourceUtil.getString("timeunit") + resourceUtil.getString("timeunit" + timeunit) + "," + resourceUtil.getString("testtime") + testtime + ",";
        para = rowpara.getParam("resParam");
        if (para != null && para.getValue() != null) {
            des = des + resourceUtil.getString("direction") + resourceUtil.getString("direction" + para.getValue());
        }
        return des;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode != 0) {
            TEPRBSUtility.unregisterListener(neid, this.hashvalue);
            TEPRBSCache.getInstance().delCahce(this.hashvalue);
        } else {
            TEPRBSCache.getInstance().getCahce(this.hashvalue).setTeststate(1);
        }
    }

    private void handleData(Datainterface inputData) {
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        int slotid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("neid");
        int neid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("portid");
        int portid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("path");
        int path = Integer.parseInt(para.getValue());
        para = rowpara.getParam("timeunit");
        int timeunit = Integer.parseInt(para.getValue());
        para = rowpara.getParam("testtime");
        int testtime = Integer.parseInt(para.getValue());
        para = rowpara.getParam("isaccu");
        int isaccu = Integer.parseInt(para.getValue());
        para = rowpara.getParam("resParam");
        int direction = 0;
        if (null != para) {
            direction = Integer.parseInt(para.getValue());
        }
        Calendar now = Calendar.getInstance();
        Date date = new Date();
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            date = new Date(now.getTimeInMillis() - (long)(now.get(15) + now.get(16)) + (long)TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).getTimeZone());
        }
        TEPRBSData testdata = new TEPRBSData();
        testdata.setNeid(neid);
        testdata.setSlotid(slotid);
        testdata.setPortid(portid);
        testdata.setPath(path);
        testdata.setTimeUnit(timeunit);
        testdata.setTesttime(testtime);
        testdata.setStartTime(date.getTime());
        testdata.setAccumulation(isaccu);
        testdata.setDirection(direction);
        testdata.setTeststate(-1);
        this.hashvalue = TEPRBSUtility.getPortName(neid, slotid, portid, path);
        TEPRBSUtility.registerListener(neid, this.hashvalue);
        TEPRBSCache.getInstance().addCahce(this.hashvalue, testdata);
    }
}

