/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.prbs;

import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSCache;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSData;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSNum;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Calendar;
import java.util.List;

public class TEPRBSDrawPic {
    private int PIC_HEIGHT_WDM = 220;
    private int PIC_WIDTH_WDM = 800;
    private BufferedImage spectWaveimage = new BufferedImage(this.PIC_WIDTH_WDM, this.PIC_HEIGHT_WDM, 1);
    private TEPRBSData testdata_wdm = null;
    private int x_lefttop_wdm = 90;
    private int y_lefttop_wdm = 30;
    private int y_leftbottom_wdm = this.PIC_HEIGHT_WDM - 20;
    private int x_rightbottom_wdm = this.PIC_WIDTH_WDM - 3;
    private String ystr_wdm = "errnum";
    private String xstr_wdm = "time";
    private Color standcoler_wdm = new Color(239, 239, 239);
    TimeZoneDateBean timezonebean_wdm = null;
    private static TEPRBSDrawPic instance = null;

    private TEPRBSDrawPic() {
    }

    public static synchronized TEPRBSDrawPic getInstance() {
        if (instance == null) {
            instance = new TEPRBSDrawPic();
        }
        return instance;
    }

    private void initres(int neid) {
        StringBuffer filePathWdm = new StringBuffer("ngwdm").append(File.separator).append("res").append(File.separator).append("prbs").append(File.separator).append("prbsres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)neid, (StringBuffer)filePathWdm);
        this.ystr_wdm = resourceUtil.getString(this.ystr_wdm);
        this.xstr_wdm = resourceUtil.getString(this.xstr_wdm);
        this.timezonebean_wdm = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
    }

    public BufferedImage drawBitTestPic(int neid, String hashvalue) {
        this.initres(neid);
        this.testdata_wdm = TEPRBSCache.getInstance().getCahce(hashvalue);
        if (this.testdata_wdm == null) {
            this.drawInitPic();
        } else {
            this.drawDataPic();
        }
        return this.spectWaveimage;
    }

    public void drawInitPic() {
        Graphics2D waveg2dwdm = this.getSVGGraphics();
        this.paintFrame(waveg2dwdm);
        this.paintinitY(waveg2dwdm);
    }

    public Graphics2D getSVGGraphics() {
        Graphics2D waveg2dwdm = (Graphics2D)this.spectWaveimage.getGraphics();
        return waveg2dwdm;
    }

    public void drawDataPic() {
        Graphics2D waveg2dwdm = this.getSVGGraphics();
        this.paintFrame(waveg2dwdm);
        this.paintBitTestData(waveg2dwdm, this.testdata_wdm);
    }

    private long getrealdata(long querydata) {
        if (querydata >= 0xFFFFFFFFL) {
            return 0L;
        }
        return querydata;
    }

    private long[] getYaxisData(TEPRBSData testdata) {
        int isaccu = testdata.isAccumulation();
        long ymaxwdm = 100L;
        if (isaccu == 1) {
            if (ymaxwdm < testdata.getTotalErrNum()) {
                ymaxwdm = testdata.getTotalErrNum();
            }
        } else {
            List relist = testdata.getResultData();
            int len = relist.size();
            for (int i = 0; i < len; ++i) {
                TEPRBSNum testNum = (TEPRBSNum)relist.get(i);
                long num = this.getrealdata(testNum.getErrnum());
                if (num <= ymaxwdm) continue;
                ymaxwdm = num;
            }
        }
        long[] ydata = new long[6];
        if (ymaxwdm <= 120L) {
            ydata[0] = 0L;
            ydata[1] = 20L;
            ydata[2] = 40L;
            ydata[3] = 60L;
            ydata[4] = 80L;
            ydata[5] = ymaxwdm;
        } else {
            long gridy = ymaxwdm / 5L;
            ydata[0] = 0L;
            ydata[1] = gridy * 1L;
            ydata[2] = gridy * 2L;
            ydata[3] = gridy * 3L;
            ydata[4] = gridy * 4L;
            ydata[5] = ymaxwdm;
        }
        return ydata;
    }

    private long[] getErrData(TEPRBSData testdata) {
        int isaccu = testdata.isAccumulation();
        List relist = testdata.getResultData();
        int size = relist.size();
        long[] errdatawdm = new long[size];
        if (isaccu == 1) {
            long sum = testdata.getOldErrNum();
            for (int i = 0; i < size; ++i) {
                long num = ((TEPRBSNum)relist.get(i)).getErrnum();
                long prbslosNum = ((TEPRBSNum)relist.get(i)).getPrbslosNum();
                if (num >= 0xFFFFFFFFL) {
                    errdatawdm[i] = -1L;
                    sum += 0L;
                    continue;
                }
                if (num == 0L) {
                    errdatawdm[i] = prbslosNum > 0L ? -1L : 0L;
                    sum += 0L;
                    continue;
                }
                errdatawdm[i] = sum + num;
                sum += num;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                long num = ((TEPRBSNum)relist.get(i)).getErrnum();
                long prbslosNum = ((TEPRBSNum)relist.get(i)).getPrbslosNum();
                if (num >= 0xFFFFFFFFL) {
                    errdatawdm[i] = -1L;
                    continue;
                }
                if (num == 0L) {
                    if (prbslosNum > 0L) {
                        errdatawdm[i] = -1L;
                        continue;
                    }
                    errdatawdm[i] = 0L;
                    continue;
                }
                errdatawdm[i] = num;
            }
        }
        return errdatawdm;
    }

    private String[] getTimeData(TEPRBSData testdata) {
        String[] timestrwdm = new String[5];
        List relist = testdata.getResultData();
        int size = relist.size();
        int j = 0;
        int i = 0;
        while (i < size) {
            long time = ((TEPRBSNum)relist.get(i)).getHappenTime();
            Calendar calTime = Calendar.getInstance();
            calTime.setTimeInMillis(time);
            timestrwdm[j] = testdata.getQueryList().size() <= 0 ? this.timezonebean_wdm.newCalendarToTime(calTime) : this.timezonebean_wdm.calendarToTime(calTime);
            i += 20;
            ++j;
        }
        for (i = 0; i < timestrwdm.length; ++i) {
            if (timestrwdm[i] != null) continue;
            timestrwdm[i] = "";
        }
        return timestrwdm;
    }

    public void paintBitTestData(Graphics2D dc, TEPRBSData testdata) {
        long[] ydata = this.getYaxisData(testdata);
        long[] errdata = this.getErrData(testdata);
        String[] timedata = this.getTimeData(testdata);
        dc.setColor(Color.BLACK);
        long ymax = ydata[ydata.length - 1];
        int y_gridh = (this.y_leftbottom_wdm - this.y_lefttop_wdm) / 5;
        for (int i = 0; i < ydata.length; ++i) {
            FontMetrics fontmetri = dc.getFontMetrics();
            int cswidth = fontmetri.stringWidth(ydata[i] + "");
            dc.drawString(ydata[i] + "", this.x_lefttop_wdm - cswidth - 3, this.y_leftbottom_wdm + 5 - y_gridh * i);
        }
        int x_gridw = (this.x_rightbottom_wdm - this.x_lefttop_wdm) / 100;
        for (int i = 0; i < timedata.length; ++i) {
            dc.drawString(timedata[i], this.x_lefttop_wdm + x_gridw * i * 20, this.y_leftbottom_wdm + 15);
        }
        int h = this.y_leftbottom_wdm - this.y_lefttop_wdm;
        for (int i = 0; i < errdata.length; ++i) {
            int errh;
            if (errdata[i] == -1L) {
                dc.setColor(Color.YELLOW);
                errh = h;
                dc.fillRect(this.x_lefttop_wdm + x_gridw * (i + 1) - 1, this.y_lefttop_wdm, 3, errh);
                continue;
            }
            if (errdata[i] == 0L) {
                dc.setColor(Color.GREEN);
                errh = h;
                dc.fillRect(this.x_lefttop_wdm + x_gridw * (i + 1) - 1, this.y_lefttop_wdm, 3, errh);
                continue;
            }
            dc.setColor(Color.red);
            errh = (int)((double)errdata[i] / (double)ymax * (double)h);
            dc.fillRect(this.x_lefttop_wdm + x_gridw * (i + 1) - 1, this.y_leftbottom_wdm - errh, 3, errh);
        }
    }

    public void paintinitY(Graphics2D dc) {
        int[] ydata = new int[]{0, 20, 40, 60, 80, 100};
        dc.setColor(Color.BLACK);
        int y_gridh = (this.y_leftbottom_wdm - this.y_lefttop_wdm) / 5;
        for (int i = 0; i < ydata.length; ++i) {
            FontMetrics fontmetri = dc.getFontMetrics();
            int cswidth = fontmetri.stringWidth(ydata[i] + "");
            dc.drawString(ydata[i] + "", this.x_lefttop_wdm - cswidth - 3, this.y_leftbottom_wdm + 5 - y_gridh * i);
        }
    }

    public void paintFrame(Graphics2D dc) {
        dc.setColor(this.standcoler_wdm);
        dc.fillRect(0, 0, 820, 250);
        dc.setColor(Color.BLACK);
        dc.drawLine(this.x_lefttop_wdm, this.y_lefttop_wdm - 2, this.x_lefttop_wdm, this.y_leftbottom_wdm);
        dc.drawLine(this.x_lefttop_wdm, this.y_leftbottom_wdm, this.x_rightbottom_wdm, this.y_leftbottom_wdm);
        int y_gridh = (this.y_leftbottom_wdm - this.y_lefttop_wdm) / 5;
        for (int i = 0; i < 5; ++i) {
            dc.drawLine(this.x_lefttop_wdm - 2, this.y_lefttop_wdm + y_gridh * i, this.x_lefttop_wdm + 2, this.y_lefttop_wdm + y_gridh * i);
        }
        int x_gridw = (this.x_rightbottom_wdm - this.x_lefttop_wdm) / 100;
        for (int j = 1; j <= 100; ++j) {
            dc.setColor(Color.BLACK);
            dc.drawLine(this.x_lefttop_wdm + x_gridw * j, this.y_leftbottom_wdm + 2, this.x_lefttop_wdm + x_gridw * j, this.y_leftbottom_wdm - 2);
            if (j % 10 != 0) continue;
            dc.setColor(Color.blue);
            dc.drawLine(this.x_lefttop_wdm + x_gridw * j, this.y_leftbottom_wdm + 2, this.x_lefttop_wdm + x_gridw * j, this.y_leftbottom_wdm - 5);
        }
        dc.drawString("(" + this.ystr_wdm + ")", this.x_lefttop_wdm + 5, this.y_lefttop_wdm - 10);
        dc.drawString("(" + this.xstr_wdm + ")", this.x_rightbottom_wdm - 32, this.y_leftbottom_wdm + 15);
    }
}

