/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.wdm.prbs.TEPRBSNum;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class TEPRBSData {
    private int neid;
    private int slotid;
    private int portid;
    private int path = 1;
    private int timeUnit;
    private long startTime;
    private int testTime;
    private int isAccumulation;
    private int progress = 0;
    private long oldErrNum = 0L;
    private long totalErrNum = 0L;
    private LinkedList reportResult = new LinkedList();
    private LinkedList queryResult = new LinkedList();
    private int teststatus = 0;
    private int direction = 0;
    private long lastreportTime = 0L;

    public void init() {
        this.setOldErrNum(0L);
        this.totalErrNum = 0L;
        this.queryResult.clear();
    }

    public LinkedList getQueryList() {
        return this.queryResult;
    }

    public List getResultData() {
        if (this.teststatus == 0) {
            if (this.reportResult.size() != 0) {
                return this.reportResult;
            }
            return this.queryResult;
        }
        return this.reportResult;
    }

    private long getrealdata(long querydata) {
        if (querydata >= 0xFFFFFFFFL) {
            return 0L;
        }
        return querydata;
    }

    public void addQueryResult(long errnum, int firstpoint, long prbslosNum) {
        if (this.queryResult.size() >= 100) {
            TEPRBSNum tNum = (TEPRBSNum)this.queryResult.removeFirst();
            this.setOldErrNum(this.getOldErrNum() + this.getrealdata(tNum.getErrnum()));
        }
        TEPRBSNum testnum = new TEPRBSNum();
        testnum.setErrnum(errnum);
        testnum.setPrbslosNum(prbslosNum);
        int size = this.queryResult.size();
        switch (this.timeUnit) {
            case 1: {
                testnum.setHappenTime(this.startTime + (long)(1000 * size));
                break;
            }
            case 2: {
                testnum.setHappenTime(this.startTime + 600000L);
                break;
            }
            case 3: {
                testnum.setHappenTime(this.startTime + 3600000L);
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("TEPRBSData.addQueryResult() timeUnit:" + this.timeUnit + " not in case!");
            }
        }
        this.progress = (int)((double)firstpoint / (double)this.testTime * 100.0);
        if (this.progress > 100) {
            this.progress = 100;
        }
        this.queryResult.add(testnum);
        this.totalErrNum += this.getrealdata(errnum);
    }

    public void addReportResult(TEPRBSNum testnum) {
        if (this.reportResult.size() >= 100) {
            TEPRBSNum tNum = (TEPRBSNum)this.reportResult.removeFirst();
            this.oldErrNum += this.getrealdata(tNum.getErrnum());
        }
        this.reportResult.add(testnum);
        this.totalErrNum += this.getrealdata(testnum.getErrnum());
    }

    synchronized void clearReportResult() {
        this.reportResult.clear();
    }

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public int getNeid() {
        return this.neid;
    }

    public void setSlotid(int slotid) {
        this.slotid = slotid;
    }

    public int getSlotid() {
        return this.slotid;
    }

    public void setPortid(int portid) {
        this.portid = portid;
    }

    public int getPortid() {
        return this.portid;
    }

    public void setPath(int path) {
        this.path = path;
    }

    public int getPath() {
        return this.path;
    }

    public void setTimeUnit(int timeUnit) {
        this.timeUnit = timeUnit;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setAccumulation(int isAccumulation) {
        this.isAccumulation = isAccumulation;
    }

    public int isAccumulation() {
        return this.isAccumulation;
    }

    public void setTesttime(int testtime) {
        this.testTime = testtime;
    }

    public int getTesttime() {
        return this.testTime;
    }

    public void refreshdata(int elapsetime, long errnum, long prbslosNum) {
        switch (this.timeUnit) {
            case 1: {
                this.progress = (int)((double)elapsetime / (double)this.testTime * 100.0);
                break;
            }
            case 2: {
                this.progress = (int)((double)elapsetime / (double)(this.testTime * 10) * 100.0);
                break;
            }
            case 3: {
                this.progress = (int)((double)elapsetime / (double)(this.testTime * 60) * 100.0);
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("TEPRBSData.refreshdata() timeUnit:" + this.timeUnit + " not in case!");
            }
        }
        TEPRBSNum testNum = new TEPRBSNum();
        Date d = new Date();
        testNum.setHappenTime(d.getTime());
        testNum.setErrnum(errnum);
        testNum.setPrbslosNum(prbslosNum);
        this.addReportResult(testNum);
        this.setLastreportTime(d.getTime());
        if (this.progress >= 100) {
            this.progress = 100;
            this.teststatus = 0;
        } else {
            this.teststatus = 1;
        }
    }

    public void setTotalErrNum(long totalErrNum) {
        this.totalErrNum = totalErrNum;
    }

    public long getTotalErrNum() {
        return this.totalErrNum;
    }

    public synchronized void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        if (this.progress > 100) {
            this.progress = 100;
        }
        return this.progress;
    }

    public void setTeststate(int teststate) {
        this.teststatus = teststate;
    }

    public int getTeststate() {
        return this.teststatus;
    }

    public void setOldErrNum(long oldErrNum) {
        this.oldErrNum = oldErrNum;
    }

    public long getOldErrNum() {
        return this.oldErrNum;
    }

    public void setLastreportTime(long lastreportTime) {
        this.lastreportTime = lastreportTime;
    }

    public long getLastreportTime() {
        return this.lastreportTime;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

