/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.portprotection;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEModifyPortProtectionGroup
extends TENEExplorerBean {
    private static final int TIME_OUT = 20;
    private static final String WPROTECTIONUNIT = "2";
    private static final String PPROTECTIONUNIT = "1";
    private static final String CONTROLUNIT = "4";
    private TEResourceUtil resource = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.createOperationList();
            int ret = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)20).retCode;
            this.outputData = new Datainterface();
            if (ret == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)ret));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Exception in the performBussinessProcess method", (Throwable)e);
        }
        return this.outputData;
    }

    public void createOperationList() {
        this.operationList = new ArrayList();
        Operation oper = null;
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        int size = rParams.length;
        for (int i = 0; i < size; ++i) {
            String proType = rParams[i].getParam("protectionType").getValue();
            Input input = null;
            Part part = null;
            if (Integer.parseInt(proType) == 6) {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_DELAYTIME");
                input = oper.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(rParams[i].getParam("groupId").getValue());
                part = input.getPart("protectionUnit");
                part.setValue(CONTROLUNIT);
                part = input.getPart("delayTime");
                part.setValue(rParams[i].getParam("cdelayTime").getValue());
                this.operationList.add(oper);
            } else {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_DELAYTIME");
                input = oper.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(rParams[i].getParam("groupId").getValue());
                part = input.getPart("protectionUnit");
                part.setValue(PPROTECTIONUNIT);
                part = input.getPart("delayTime");
                part.setValue(rParams[i].getParam("pdelayTime").getValue());
                this.operationList.add(oper);
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_DELAYTIME");
                input = oper.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(rParams[i].getParam("groupId").getValue());
                part = input.getPart("protectionUnit");
                part.setValue(WPROTECTIONUNIT);
                part = input.getPart("delayTime");
                part.setValue(rParams[i].getParam("wdelayTime").getValue());
                this.operationList.add(oper);
            }
            if (rParams[i].getParam("revertiveMode") != null) {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_RESTORE_MODE");
                input = oper.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(rParams[i].getParam("groupId").getValue());
                part = input.getPart("revertiveMode");
                part.setValue(rParams[i].getParam("revertiveMode").getValue());
                part = input.getPart("wtrTime");
                part.setValue(rParams[i].getParam("wtrTime").getValue());
                this.operationList.add(oper);
            }
            if (rParams[i].getParam("SDEnable") == null) continue;
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_SDFLAG");
            input = oper.getInput();
            part = input.getPart("neId");
            part.setValue(rParams[i].getParam("neId").getValue());
            part = input.getPart("groupId");
            part.setValue(rParams[i].getParam("groupId").getValue());
            part = input.getPart("SDEnable");
            part.setValue(rParams[i].getParam("SDEnable").getValue());
            this.operationList.add(oper);
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append("wdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("portprotection").append(File.separator).append("portprotectionres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            this.resource = TEGetFilePath.getResource((int)neid, (StringBuffer)sb);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo log = new TELogInfo();
            log.setCmdID(subfunc.getCode());
            log.setLocation(ipAddress);
            log.setUserName(TESysManagerBean.getInstance().getSysUser());
            log.setOperateName(subfunc.getSubFuncDes(neid));
            log.setOperateObject("");
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                log.setOperateObject(String.valueOf(neid));
            } else {
                log.setOperateObject(neObj.getNEName());
            }
            String desc = "";
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            desc = desc + this.resource.getString("protection_group_name") + log.getOperateObject() + "-" + rowParams.getParam("groupId").getValue() + this.resource.getString("protection_type");
            int protectionType = Integer.parseInt(rowParams.getParam("protectionType").getValue());
            String protectionTypeStr = "";
            String controlUnit = "";
            switch (protectionType) {
                case 1: {
                    protectionTypeStr = protectionTypeStr + this.resource.getString("board_protection");
                    break;
                }
                case 3: {
                    protectionTypeStr = protectionTypeStr + this.resource.getString("client_protection");
                    if ("".equals(rowParams.getParam("cwPath").getValue())) break;
                    controlUnit = controlUnit + this.resource.getString("control_unit_working_path") + rowParams.getParam("cwPath").getValue();
                    break;
                }
                case 4: {
                    protectionTypeStr = protectionTypeStr + this.resource.getString("line_protection");
                    break;
                }
            }
            desc = desc + protectionTypeStr + this.resource.getString("working_unit") + rowParams.getParam("workingUnit").getValue() + this.resource.getString("working_unit_delaytime") + (float)Integer.parseInt(rowParams.getParam("wdelayTime").getValue()) / 10.0f + this.resource.getString("time_unit") + this.resource.getString("protection_unit") + rowParams.getParam("protectionUnit").getValue() + this.resource.getString("protection_unit_delaytime") + (float)Integer.parseInt(rowParams.getParam("pdelayTime").getValue()) / 10.0f + this.resource.getString("time_unit") + controlUnit;
            if (rowParams.getParam("revertiveMode") != null) {
                desc = desc + this.resource.getString("revertive_mode");
                int reveMode = Integer.parseInt(rowParams.getParam("revertiveMode").getValue());
                desc = reveMode == 1 ? desc + this.resource.getString("revertive") + this.resource.getString("wtr_time") + rowParams.getParam("wtrTime").getValue() + this.resource.getString("time_unit") : desc + this.resource.getString("non_revertive");
            }
            desc = desc + this.resource.getString("sd_trigger_flag");
            int sdEnable = Integer.parseInt(rowParams.getParam("sdEnable").getValue());
            desc = sdEnable == 1 ? desc + this.resource.getString("enabled") : desc + this.resource.getString("disabled");
            log.setOperateDesc(desc);
            if (errorCode == 0) {
                log.setResult(0);
                log.setErrCode(0);
                log.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(log);
            } else if (errorCode == 2 || errorCode == 1) {
                log.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    log.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    log.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    log.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(log);
                    break;
                }
            } else {
                log.setResult(2);
                log.setErrCode(errorCode);
                log.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(log);
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

