/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.portprotection;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.channel.QueryWDMMode;
import com.huawei.nglct.nemgr.wdm.portprotection.TEAvailableResourceOfPortProtectionGroup;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class TEGetAvailableResourceOfPortProtectionGroup
extends TENEExplorerBean {
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private static final int CONTROL_UNIT = 3;
    private static final int WDM_FUNC_UNIT_LPU = 16384;
    private static final String MANAGE_RANGE_OUT = "4294967295";
    private TENEListMgr neListMgr = TENEListMgr.getInstance();
    private ArrayList availableResList = new ArrayList();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.getAllResource(neid);
        this.filterSeparateProtecitonGroup(operationList);
        operationList.clear();
        this.outputData = this.constructRtnData(neid);
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private void getAllResource(int neid) {
        TENE ne = this.neListMgr.getNE(neid);
        Vector boardList = ne.getBoardList();
        int size = boardList.size();
        for (int x = 0; x < size; ++x) {
            TEAvailableResourceOfPortProtectionGroup availableRes = null;
            ArrayList portList = null;
            TEBoard board = (TEBoard)boardList.get(x);
            int slotId = board.getSlotID();
            int boardType = board.getBoardType();
            int boardWDMFunType = this.mgr.getBoardWDMFunType(neid, board.getBoardType());
            if (boardWDMFunType == 16384) {
                portList = this.mgr.getBoardPortList(neid, boardType);
                if (this.mgr.isDynPortBoardType(neid, boardType)) {
                    portList.removeAll(this.mgr.getSupportedDynPortList(neid, boardType));
                    portList.addAll(this.mgr.getLogicPortList(neid, slotId));
                }
                availableRes = new TEAvailableResourceOfPortProtectionGroup(neid, slotId, boardType, board.getBoardName(), portList, 16384);
            } else if (boardWDMFunType == 4) {
                portList = this.mgr.getBoardPortList(neid, boardType);
                if (this.mgr.isDynPortBoardType(neid, boardType)) {
                    portList.removeAll(this.mgr.getSupportedDynPortList(neid, boardType));
                    portList.addAll(this.mgr.getLogicPortList(neid, slotId));
                }
                availableRes = new TEAvailableResourceOfPortProtectionGroup(neid, slotId, boardType, board.getBoardName(), portList, 4);
            } else if (boardWDMFunType == 16) {
                portList = this.mgr.getBoardPortList(neid, boardType);
                if (this.mgr.isDynPortBoardType(neid, boardType)) {
                    portList.removeAll(this.mgr.getSupportedDynPortList(neid, boardType));
                    portList.addAll(this.mgr.getLogicPortList(neid, slotId));
                }
                availableRes = new TEAvailableResourceOfPortProtectionGroup(neid, slotId, boardType, board.getBoardName(), portList, 16);
            }
            if (availableRes != null && availableRes.getPortList().size() != 0) {
                ArrayList tpmportList = availableRes.getPortList();
                HashSet set = new HashSet(tpmportList);
                tpmportList.clear();
                tpmportList.addAll(set);
            }
            this.doSpecialProcess(neid, slotId, boardType, availableRes);
            if (availableRes == null) continue;
            this.availableResList.add(availableRes);
        }
    }

    private void filterSeparateProtecitonGroup(ArrayList operationList) {
        int length = operationList.size();
        for (int i = 0; i < length; ++i) {
            Operation operation = (Operation)operationList.get(i);
            String operationName = operation.getName();
            if (!operationName.equals("NSCMD_PPS_GET_PROTPAIR_BDPARA")) continue;
            for (Output output : operation.getOutput()) {
                if (!output.getFault(0).getCode().equals("0")) continue;
                String returnNeId = output.getPartValue("returnNeId");
                int protectionGroupUnit = Integer.parseInt(output.getPartValue("protectionGroupUnit"));
                int portId = Integer.parseInt(output.getPartValue("portId"));
                int slotId = Integer.parseInt(output.getPartValue("slotId"));
                int boardType = Integer.parseInt(output.getPartValue("boardType"));
                if (returnNeId.equals(MANAGE_RANGE_OUT) || Integer.parseInt(returnNeId) != this.neid) continue;
                for (int x = this.availableResList.size() - 1; x >= 0; --x) {
                    TEAvailableResourceOfPortProtectionGroup availableRes = (TEAvailableResourceOfPortProtectionGroup)this.availableResList.get(x);
                    if (slotId != availableRes.getSlotID()) continue;
                    availableRes.getPortList().remove(new Integer(portId));
                    if (protectionGroupUnit == 3 && (boardType == 943 || boardType == 1339 || boardType == 2974)) {
                        availableRes.getPortList().remove(new Integer(portId + 1));
                    }
                    if (availableRes.getPortList().size() > 0) continue;
                    this.availableResList.remove(x);
                }
            }
        }
    }

    private Datainterface constructRtnData(int neid) {
        Datainterface datainterface = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        int size = this.availableResList.size();
        for (int i = 0; i < size; ++i) {
            TEAvailableResourceOfPortProtectionGroup res = (TEAvailableResourceOfPortProtectionGroup)this.availableResList.get(i);
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("neId", String.valueOf(res.getNeid()));
            rParams.addParam(param);
            param = new Param("neName", this.mgr.getNE(res.getNeid()).getNEName());
            rParams.addParam(param);
            param = new Param("shelfName", TEBoardUtil.getSubrackNameFromSlot((int)res.getNeid(), (int)res.getSlotID()));
            rParams.addParam(param);
            param = new Param("slotId", String.valueOf(res.getSlotID()));
            rParams.addParam(param);
            param = new Param("boardType", String.valueOf(res.getBoardType()));
            rParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("wdmFuncUnit", String.valueOf(res.getWdmFuncUnit()));
            rParams.addParam(param);
            param = new Param("linkSlot", String.valueOf(res.getLinkSlot()));
            rParams.addParam(param);
            param = new Param("linkPort", String.valueOf(res.getLinkPort()));
            rParams.addParam(param);
            boolean temp = true;
            Param portParam = null;
            Param portNameParam = null;
            Option option = null;
            ArrayList portList = res.getPortList();
            Collections.sort(portList);
            int len = portList.size();
            for (int j = 0; j < len; ++j) {
                String portName = this.mgr.getPortName(neid, res.getSlotID(), res.getBoardType(), ((Integer)portList.get(j)).intValue());
                if (temp) {
                    portParam = new Param("portId", portList.get(j).toString());
                    portNameParam = new Param("portName", portName);
                    temp = false;
                    continue;
                }
                option = new Option(portList.get(j).toString());
                portParam.addOption(option);
                option = new Option(portName);
                portNameParam.addOption(option);
            }
            if (null != portParam) {
                rParams.addParam(portParam);
            }
            if (null != portNameParam) {
                rParams.addParam(portNameParam);
            }
            bParams.addRowParams(rParams);
        }
        datainterface.setBussinessParams(bParams);
        datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        return datainterface;
    }

    private void doSpecialProcess(int neid, int slotId, int boardType, TEAvailableResourceOfPortProtectionGroup availableRes) {
        String boardMode;
        if (2272 == boardType && !"OTN_MODE".equals(boardMode = QueryWDMMode.queryBoardMode((int)neid, (int)slotId))) {
            ArrayList aPortList = availableRes.getPortList();
            Iterator iterator = aPortList.iterator();
            while (iterator.hasNext()) {
                Integer portIdInteger = (Integer)iterator.next();
                if (portIdInteger != 3 && portIdInteger != 4) continue;
                iterator.remove();
            }
        }
    }
}

