/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.opticalpower;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPfmUtility;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class OpticalPowerQueryBean
extends TEGenCfgQueryBean {
    private static final int INPOWER_EVENT = 203;
    private static final int OUTPOWER_EVENT = 200;
    private static final int SUM_INPOWER_EVENT = 212;
    private static final int SUM_OUTPOWER_EVENT = 215;
    private static final int EDTPL_OUTPOWER_EVENT = 123;
    private static final int FILTER_MAX = Integer.MAX_VALUE;
    private static final int FILTER_MIN = Integer.MIN_VALUE;
    private static final int FILTER_INVALID = Short.MAX_VALUE;
    private static final int FIND_NULL_ERROR_CODE_38410 = 38410;
    private static final int FIND_NULL_ERROR_CODE_38662 = 38662;
    private static final int CROSSING_OF_OPTICAL_INTERFACE_NUMBER = 39170;
    private static final int BOARD_TYPE_OPU = 1615;
    private static final String NSCMD_PER_GET_CURDATA_NEW = "NSCMD_PER_GET_CURDATA_2";
    private static final int SDH_INPOWER_EVENT = 107;
    private static final int SDH_OUTPOWER_EVENT = 104;
    private boolean isSDHBoard = false;
    private boolean opticalPowerObjectSupportPathFlag = false;

    public ArrayList getQueryOperationList(TEGenCfgFunCmd funCmd, Datainterface inputData) {
        String reptype = null;
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        Param param = rowParams.getParam("reptype");
        if (param != null) {
            reptype = param.getValue();
        }
        ArrayList operList = super.getQueryOperationList(funCmd, inputData);
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            Operation oper = (Operation)operList.get(i);
            if (oper.getName().indexOf("NSCMD_CFG_GET_ALM_TH") < 0) continue;
            int slotid = Integer.parseInt(oper.getInput().getPart("slotid").getValue());
            this.isSDHBoard = !TESpecialAttrMgr.getInstance().getCPAttrValue(this.neid, slotid, "TE_FUNC_CFG_WDM_PM", "SDH_ATTR_SUPPORT_INPUT_OPTICAL_POWER").isEmpty() || !TESpecialAttrMgr.getInstance().getCPAttrValue(this.neid, slotid, "TE_FUNC_CFG_WDM_PM", "SDH_ATTR_SUPPORT_OUTPUT_OPTICAL_POWER").isEmpty();
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
            if (boardType == 1615) {
                oper.getInput().setPartValue("reptype", "148");
            } else if (this.isSDHBoard) {
                oper.getInput().setPartValue("reptype", "144");
            }
            if (reptype == null) continue;
            oper.getInput().setPartValue("reptype", reptype);
        }
        return operList;
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (this.isSDHBoard) {
            this.getOperationListSDH(neid, operationList);
            this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        } else {
            ArrayList tempOperationList = this.getOperationList(neid, operationList);
            this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)tempOperationList, (ArrayList)filterErrorCodeList);
        }
        RowParams rowParams = null;
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            float maxInpow;
            int intMaxInpow;
            String strMaxInpow;
            float minInpow;
            int intMinInpow;
            String strMinInpow;
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowParams.getParamCount() == 0 || rowParams.getParam("slotid") == null || rowParams.getParam("slotid").getValue().equals("0") || rowParams.getParam("port") == null || rowParams.getParam("port").getValue().equals("0")) continue;
            if (!this.opticalPowerObjectSupportPathFlag && null != rowParams.getParam("path")) {
                rowParams.removeParam(rowParams.getParam("path"));
            }
            if (rowParams.getParam("startTime") != null) {
                rowParams.removeParam(rowParams.getParam("startTime"));
            }
            if (this.isIntValue(rowParams, "W32PORT_ATTR_MININPOW")) {
                strMinInpow = rowParams.getParam("W32PORT_ATTR_MININPOW").getValue();
                intMinInpow = new BigInteger(strMinInpow).intValue();
                if (Integer.MAX_VALUE == intMinInpow || Integer.MIN_VALUE == intMinInpow || Short.MAX_VALUE == intMinInpow) {
                    rowParams.getParam("W32PORT_ATTR_MININPOW").setValue("/");
                } else {
                    minInpow = (float)intMinInpow / 10.0f;
                    rowParams.getParam("W32PORT_ATTR_MININPOW").setValue("" + minInpow);
                }
            }
            if (this.isIntValue(rowParams, "W32PORT_ATTR_MAXINPOW")) {
                strMaxInpow = rowParams.getParam("W32PORT_ATTR_MAXINPOW").getValue();
                intMaxInpow = new BigInteger(strMaxInpow).intValue();
                if (Integer.MAX_VALUE == intMaxInpow || Integer.MIN_VALUE == intMaxInpow || Short.MAX_VALUE == intMaxInpow) {
                    rowParams.getParam("W32PORT_ATTR_MAXINPOW").setValue("/");
                } else {
                    maxInpow = (float)intMaxInpow / 10.0f;
                    rowParams.getParam("W32PORT_ATTR_MAXINPOW").setValue("" + maxInpow);
                }
            }
            if (this.isIntValue(rowParams, "W32PORT_ATTR_MAXINPOWHIGH")) {
                strMinInpow = rowParams.getParam("W32PORT_ATTR_MAXINPOWHIGH").getValue();
                intMinInpow = new BigInteger(strMinInpow).intValue();
                if (Integer.MAX_VALUE == intMinInpow || Integer.MIN_VALUE == intMinInpow || Short.MAX_VALUE == intMinInpow) {
                    rowParams.getParam("W32PORT_ATTR_MAXINPOWHIGH").setValue("/");
                } else {
                    minInpow = (float)intMinInpow / 10.0f;
                    rowParams.getParam("W32PORT_ATTR_MAXINPOWHIGH").setValue("" + minInpow);
                }
            }
            if (this.isIntValue(rowParams, "W32PORT_ATTR_MAXINPOWLOW")) {
                strMaxInpow = rowParams.getParam("W32PORT_ATTR_MAXINPOWLOW").getValue();
                intMaxInpow = new BigInteger(strMaxInpow).intValue();
                if (Integer.MAX_VALUE == intMaxInpow || Integer.MIN_VALUE == intMaxInpow || Short.MAX_VALUE == intMaxInpow) {
                    rowParams.getParam("W32PORT_ATTR_MAXINPOWLOW").setValue("/");
                } else {
                    maxInpow = (float)intMaxInpow / 10.0f;
                    rowParams.getParam("W32PORT_ATTR_MAXINPOWLOW").setValue("" + maxInpow);
                }
            }
            if (this.isIntValue(rowParams, "W32PORT_ATTR_MININPOWHIGH")) {
                strMinInpow = rowParams.getParam("W32PORT_ATTR_MININPOWHIGH").getValue();
                intMinInpow = new BigInteger(strMinInpow).intValue();
                if (Integer.MAX_VALUE == intMinInpow || Integer.MIN_VALUE == intMinInpow || Short.MAX_VALUE == intMinInpow) {
                    rowParams.getParam("W32PORT_ATTR_MININPOWHIGH").setValue("/");
                } else {
                    minInpow = (float)intMinInpow / 10.0f;
                    rowParams.getParam("W32PORT_ATTR_MININPOWHIGH").setValue("" + minInpow);
                }
            }
            if (this.isIntValue(rowParams, "W32PORT_ATTR_MININPOWLOW")) {
                strMaxInpow = rowParams.getParam("W32PORT_ATTR_MININPOWLOW").getValue();
                intMaxInpow = new BigInteger(strMaxInpow).intValue();
                if (Integer.MAX_VALUE == intMaxInpow || Integer.MIN_VALUE == intMaxInpow || Short.MAX_VALUE == intMaxInpow) {
                    rowParams.getParam("W32PORT_ATTR_MININPOWLOW").setValue("/");
                } else {
                    maxInpow = (float)intMaxInpow / 10.0f;
                    rowParams.getParam("W32PORT_ATTR_MININPOWLOW").setValue("" + maxInpow);
                }
            }
            if (this.isIntValue(rowParams, "W32PORT_ATTR_PUMP_OPMIN")) {
                strMinInpow = rowParams.getParam("W32PORT_ATTR_PUMP_OPMIN").getValue();
                intMinInpow = new BigInteger(strMinInpow).intValue();
                if (Integer.MAX_VALUE == intMinInpow || Integer.MIN_VALUE == intMinInpow || Short.MAX_VALUE == intMinInpow) {
                    rowParams.getParam("W32PORT_ATTR_PUMP_OPMIN").setValue("/");
                } else {
                    minInpow = (float)intMinInpow / 10.0f;
                    rowParams.getParam("W32PORT_ATTR_PUMP_OPMIN").setValue("" + minInpow);
                }
            }
            if (this.isIntValue(rowParams, "W32PORT_ATTR_PUMP_OPMAX")) {
                strMaxInpow = rowParams.getParam("W32PORT_ATTR_PUMP_OPMAX").getValue();
                intMaxInpow = new BigInteger(strMaxInpow).intValue();
                if (Integer.MAX_VALUE == intMaxInpow || Integer.MIN_VALUE == intMaxInpow || Short.MAX_VALUE == intMaxInpow) {
                    rowParams.getParam("W32PORT_ATTR_PUMP_OPMAX").setValue("/");
                } else {
                    maxInpow = (float)intMaxInpow / 10.0f;
                    rowParams.getParam("W32PORT_ATTR_PUMP_OPMAX").setValue("" + maxInpow);
                }
            }
            if (this.isIntValue(rowParams, "W32PORT_ATTR_GET_INPWR")) {
                String strInpow = rowParams.getParam("W32PORT_ATTR_GET_INPWR").getValue();
                int intInpow = new BigInteger(strInpow).intValue();
                if (Integer.MAX_VALUE == intInpow || Integer.MIN_VALUE == intInpow || Short.MAX_VALUE == intInpow) {
                    rowParams.getParam("W32PORT_ATTR_GET_INPWR").setValue("/");
                } else {
                    minInpow = (float)intInpow / 10.0f;
                    rowParams.getParam("W32PORT_ATTR_GET_INPWR").setValue("" + minInpow);
                }
            }
            if (!this.isIntValue(rowParams, "W32PORT_ATTR_GET_OUTPWR")) continue;
            String strOutpow = rowParams.getParam("W32PORT_ATTR_GET_OUTPWR").getValue();
            int intOutpow = new BigInteger(strOutpow).intValue();
            if (Integer.MAX_VALUE == intOutpow || Integer.MIN_VALUE == intOutpow || Short.MAX_VALUE == intOutpow) {
                rowParams.getParam("W32PORT_ATTR_GET_OUTPWR").setValue("/");
                continue;
            }
            maxInpow = (float)intOutpow / 10.0f;
            rowParams.getParam("W32PORT_ATTR_GET_OUTPWR").setValue("" + maxInpow);
        }
    }

    private boolean isIntValue(RowParams rowParams, String attrId) {
        return null != rowParams.getParam(attrId) && !rowParams.getParam(attrId).getValue().equals("/");
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38410);
        errorCodeList.add(38662);
        errorCodeList.add(39170);
        return errorCodeList;
    }

    private long getPvalue(String value) {
        byte[] t = IOStreamConvertor.getByteArrayFromString((String)value);
        return IOStreamConvertor.readLong((byte[])t, (int)0);
    }

    private void getOperationListSDH(int neID, ArrayList operationList) {
        Operation operation = null;
        Output output = null;
        Part part = null;
        long peValue = 0L;
        int peid = 0;
        int slotid = 0;
        int port = 0;
        int path = 1;
        int inSlotId = 0;
        int inPort = 0;
        int inpath = 1;
        ArrayList filterErrorCode = this.getFilterErrorCodeList();
        if (null != operationList) {
            int len = operationList.size();
            for (int i = 0; i < len; ++i) {
                operation = (Operation)operationList.get(i);
                if (!NSCMD_PER_GET_CURDATA_NEW.equals(operation.getName())) continue;
                Input input = operation.getInput();
                if (input.getPart("objpara") != null) {
                    byte[] objByte = input.getPart("objpara").getValue().getBytes();
                    byte[] temp = new byte[4];
                    System.arraycopy(objByte, 0, temp, 0, 4);
                    inSlotId = TEAlmObjTypeMgr.convertSlotidFromBytes((byte[])temp);
                    temp = new byte[2];
                    System.arraycopy(objByte, 4, temp, 0, 2);
                    temp = new byte[2];
                    System.arraycopy(objByte, 6, temp, 0, 2);
                    inPort = IOStreamConvertor.readPositiveShort((byte[])temp, (int)0);
                    if (objByte.length >= 10 && this.isSDHBoard) {
                        temp = new byte[4];
                        System.arraycopy(objByte, 6, temp, 0, 4);
                        inPort = TEAlmObjTypeMgr.convertSlotidFromBytes((byte[])temp);
                    }
                    if (objByte.length >= 12) {
                        temp = new byte[4];
                        System.arraycopy(objByte, 8, temp, 0, 4);
                        inpath = IOStreamConvertor.readPositiveInt((byte[])temp, (int)0);
                    }
                }
                for (int j = 0; j < operation.getOutputCount(); ++j) {
                    output = operation.getOutput(j);
                    Part[] partArr = output.getPart();
                    int len2 = partArr.length;
                    for (int k = 0; k < len2; ++k) {
                        if (TEPfmUtility.validatePart((Part)partArr[k], (String)"peValue")) {
                            String value = partArr[k].getValue();
                            peValue = this.getPvalue(value);
                            continue;
                        }
                        if (TEPfmUtility.validatePart((Part)partArr[k], (String)"peid")) {
                            peid = Integer.parseInt(partArr[k].getValue());
                            continue;
                        }
                        if (!TEPfmUtility.validatePart((Part)partArr[k], (String)"objpara")) continue;
                        byte[] objByte = partArr[k].getValue().getBytes();
                        byte[] temp = new byte[4];
                        System.arraycopy(objByte, 0, temp, 0, 4);
                        slotid = TEAlmObjTypeMgr.convertSlotidFromBytes((byte[])temp);
                        temp = new byte[2];
                        System.arraycopy(objByte, 4, temp, 0, 2);
                        temp = new byte[2];
                        System.arraycopy(objByte, 6, temp, 0, 2);
                        port = IOStreamConvertor.readPositiveShort((byte[])temp, (int)0);
                        if (objByte.length >= 10 && this.isSDHBoard) {
                            temp = new byte[4];
                            System.arraycopy(objByte, 6, temp, 0, 4);
                            port = TEAlmObjTypeMgr.convertSlotidFromBytes((byte[])temp);
                        }
                        if (objByte.length < 12) continue;
                        temp = new byte[4];
                        System.arraycopy(objByte, 8, temp, 0, 4);
                        path = IOStreamConvertor.readPositiveInt((byte[])temp, (int)0);
                    }
                    if (peid != 203 && peid != 200 && peid != 107 && peid != 104 && peid != 212 && peid != 215 && peid != 123) {
                        operation.removeOutput(j);
                        --j;
                        continue;
                    }
                    if (port != 0 && port != inPort) {
                        operation.removeOutput(j);
                        --j;
                        continue;
                    }
                    part = new Part();
                    part.setName("slotid");
                    part.setType("int");
                    part.setValue(slotid + "");
                    output.addPart(part);
                    part = new Part();
                    part.setName("port");
                    part.setType("int");
                    part.setValue(port + "");
                    output.addPart(part);
                    part = new Part();
                    part.setName("path");
                    part.setType("int");
                    part.setValue(path + "");
                    output.addPart(part);
                    long powerValue = peValue;
                    if ((peid == 203 || peid == 107 || peid == 212) && input.getPart("W32PORT_ATTR_INPUTPOWER") != null) {
                        float inputPower = (float)powerValue / 10.0f;
                        if ((2308 == this.boardType || 2836 == this.boardType || 2946 == this.boardType || 2875 == this.boardType) && 212 == peid) {
                            operation.removeOutput(j);
                            --j;
                            continue;
                        }
                        if (output.getPart("W32PORT_ATTR_INPUTPOWER") == null) {
                            part = new Part();
                            part.setType("int");
                            part.setLength(2);
                            part.setName("W32PORT_ATTR_INPUTPOWER");
                            part.setValue(inputPower + "");
                            output.addPart(part);
                            continue;
                        }
                        output.getPart("W32PORT_ATTR_INPUTPOWER").setValue(inputPower + "");
                        continue;
                    }
                    if ((peid == 200 || peid == 104 || peid == 215 || peid == 123) && input.getPart("W32PORT_ATTR_OUTPUTPOWER") != null) {
                        float outputPower = (float)powerValue / 10.0f;
                        if (935 == this.boardType && 215 == peid) continue;
                        if (output.getPart("W32PORT_ATTR_OUTPUTPOWER") == null) {
                            part = new Part();
                            part.setType("int");
                            part.setLength(2);
                            part.setName("W32PORT_ATTR_OUTPUTPOWER");
                            part.setValue(outputPower + "");
                            output.addPart(part);
                            continue;
                        }
                        output.getPart("W32PORT_ATTR_OUTPUTPOWER").setValue(outputPower + "");
                        continue;
                    }
                    operation.removeOutput(j);
                    --j;
                }
                if (operation.getOutputCount() != 0) continue;
                Output outputtemp = (Output)output.clone();
                if (filterErrorCode.contains(Integer.valueOf(outputtemp.getFault(0).getCode()))) {
                    outputtemp.getFault(0).setCode("0");
                }
                operation.addOutput(outputtemp);
                part = new Part();
                part.setName("slotid");
                part.setType("int");
                part.setValue(inSlotId + "");
                outputtemp.addPart((Part)part.clone());
                input.addPart((Part)part.clone());
                part = new Part();
                part.setName("port");
                part.setType("int");
                part.setValue(inPort + "");
                outputtemp.addPart((Part)part.clone());
                input.addPart((Part)part.clone());
                part = new Part();
                part.setName("path");
                part.setType("int");
                part.setValue(inpath + "");
                outputtemp.addPart((Part)part.clone());
                input.addPart((Part)part.clone());
                this.setInputAndOutputValueWhenNull(input, outputtemp, "W32PORT_ATTR_INPUTPOWER");
                this.setInputAndOutputValueWhenNull(input, outputtemp, "W32PORT_ATTR_OUTPUTPOWER");
            }
        }
    }

    private ArrayList getOperationList(int neID, ArrayList operationList) {
        ArrayList<Object> rtnOperList;
        block13: {
            TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
            rtnOperList = new ArrayList<Object>();
            Operation operation = null;
            Output output = null;
            Part part = null;
            if (null == operationList) break block13;
            int len = operationList.size();
            for (int i = 0; i < len; ++i) {
                block14: {
                    operation = (Operation)operationList.get(i);
                    if (!operation.getName().equalsIgnoreCase("NSCMD_PER_GET_CURDATA_1")) break block14;
                    int slotID = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
                    int boardType = mgr.getBoardType(neID, slotID);
                    output = operation.getOutput(0);
                    Part[] partArr = output.getPart();
                    int len2 = partArr.length;
                    for (int k = 0; k < len2; ++k) {
                        if (!partArr[k].getName().equalsIgnoreCase("record")) continue;
                        if (partArr[k].getValue() == null) {
                            return operationList;
                        }
                        byte[] bValue = partArr[k].getValue().getBytes();
                        int nParaSize = bValue.length;
                        output.removePart(partArr[k]);
                        output.getPart("periodstime").setValue("");
                        operation.removeOutput(output);
                        int nCount = 18;
                        int nPos = 0;
                        while (nPos + nCount <= nParaSize) {
                            block15: {
                                boolean flag;
                                int path;
                                int port;
                                Output tmpOutput;
                                block17: {
                                    int powerValue;
                                    int eventType;
                                    block16: {
                                        tmpOutput = (Output)output.clone();
                                        byte[] bTmp = new byte[4];
                                        System.arraycopy(bValue, nPos + 0, bTmp, 0, 4);
                                        eventType = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                                        if (eventType != 203 && eventType != 200 && eventType != 212 && eventType != 215 && eventType != 123) break block15;
                                        bTmp = new byte[2];
                                        System.arraycopy(bValue, nPos + 4, bTmp, 0, 2);
                                        port = IOStreamConvertor.readPositiveShort((byte[])bTmp, (int)0);
                                        bTmp = new byte[4];
                                        System.arraycopy(bValue, nPos + 6, bTmp, 0, 4);
                                        path = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                                        flag = false;
                                        int count = operation.getOutputCount();
                                        for (int j = 0; j < count; ++j) {
                                            Output out = operation.getOutput(j);
                                            String slot = out.getPartValue("slotid");
                                            String portid = out.getPartValue("port");
                                            String pathid = out.getPartValue("path");
                                            if (slot == null || portid == null || pathid == null || Integer.parseInt(slot) != slotID || Integer.parseInt(portid) != port || Integer.parseInt(pathid) != path) continue;
                                            tmpOutput = out;
                                            flag = true;
                                            break;
                                        }
                                        bTmp = new byte[8];
                                        System.arraycopy(bValue, nPos + 10, bTmp, 0, 8);
                                        powerValue = IOStreamConvertor.readPositiveLong((byte[])bTmp, (int)0);
                                        if (eventType != 203 && eventType != 212) break block16;
                                        float inputPower = (float)powerValue / 10.0f;
                                        if (tmpOutput.getPart("W32PORT_ATTR_INPUTPOWER") == null) {
                                            part = new Part();
                                            part.setType("int");
                                            part.setLength(2);
                                            part.setName("W32PORT_ATTR_INPUTPOWER");
                                            part.setValue(inputPower + "");
                                            tmpOutput.addPart(part);
                                        } else {
                                            tmpOutput.getPart("W32PORT_ATTR_INPUTPOWER").setValue(inputPower + "");
                                        }
                                        break block17;
                                    }
                                    if (eventType != 200 && eventType != 215 && eventType != 123) break block17;
                                    float outputPower = (float)powerValue / 10.0f;
                                    if (935 == boardType && 215 == eventType) break block15;
                                    if (tmpOutput.getPart("W32PORT_ATTR_OUTPUTPOWER") == null) {
                                        part = new Part();
                                        part.setType("int");
                                        part.setLength(2);
                                        part.setName("W32PORT_ATTR_OUTPUTPOWER");
                                        part.setValue(outputPower + "");
                                        tmpOutput.addPart(part);
                                    } else {
                                        tmpOutput.getPart("W32PORT_ATTR_OUTPUTPOWER").setValue(outputPower + "");
                                    }
                                }
                                if (!flag) {
                                    part = new Part();
                                    part.setType("byte");
                                    part.setLength(1);
                                    part.setName("port");
                                    part.setValue(port + "");
                                    tmpOutput.addPart(part);
                                    part = new Part();
                                    part.setType("int");
                                    part.setLength(2);
                                    part.setName("path");
                                    part.setValue(path + "");
                                    tmpOutput.addPart(part);
                                    operation.addOutput((Output)tmpOutput.clone());
                                }
                            }
                            nPos += nCount;
                        }
                        break;
                    }
                    rtnOperList.add(operation.clone());
                    continue;
                }
                rtnOperList.add(operation.clone());
            }
        }
        return rtnOperList;
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return true;
    }

    private void setAttrIdQx(List list, int slotid, int boardType, Operation curDataOper, String attrId) {
        if (this.attrIdList.contains(attrId)) {
            Operation oper = (Operation)curDataOper.clone();
            Part part = new Part();
            part.setName(attrId);
            part.setValue(null);
            part.setType("int");
            part.setLength(2);
            oper.getInput().addPart(part);
            this.setQXData(list, oper, slotid, boardType, attrId);
        }
    }

    private void setQXData(List operationList, Operation oper, int slotid, int boardType, String attrId) {
        String peidvar = "0";
        String objtypevar = "119";
        String paralenvar = "6";
        if (this.isSDHBoard) {
            if (attrId.equals("W32PORT_ATTR_INPUTPOWER")) {
                peidvar = TESpecialAttrMgr.getInstance().getCPAttrValue(this.neid, slotid, "TE_FUNC_CFG_WDM_PM", "SDH_ATTR_SUPPORT_INPUT_OPTICAL_POWER");
            } else if (attrId.equals("W32PORT_ATTR_OUTPUTPOWER")) {
                peidvar = TESpecialAttrMgr.getInstance().getCPAttrValue(this.neid, slotid, "TE_FUNC_CFG_WDM_PM", "SDH_ATTR_SUPPORT_OUTPUT_OPTICAL_POWER");
            }
            objtypevar = "172";
            paralenvar = "5";
        }
        Input input = oper.getInput();
        Part part = input.getPart("peid");
        part.setValue(peidvar);
        part = input.getPart("period");
        part.setValue("1");
        part = input.getPart("reserve");
        part.setValue("255");
        part = input.getPart("objtype");
        part.setValue(objtypevar);
        part = input.getPart("paralen");
        part.setValue(paralenvar);
        boolean isSDHLineBoard = TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neid, slotid);
        if (isSDHLineBoard) {
            input.getPart("objtype").setValue("84");
            input.getPart("paralen").setValue("4");
        }
        String slotneid = TEAlmObjTypeMgr.convertNMToNEHexString((int)slotid);
        List portnolist = this.getSupportPortList(this.neid, slotid, attrId);
        if (portnolist == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = portnolist.size();
        for (int i = 0; i < len; ++i) {
            TEGenCfgPortAttribute tmp = (TEGenCfgPortAttribute)portnolist.get(i);
            int portid = tmp.getPort();
            int pathid = tmp.getPath();
            if (portid <= 0 || pathid <= 0) continue;
            if (pathid > 1) {
                this.opticalPowerObjectSupportPathFlag = true;
            }
            String sportid = Integer.toHexString(portid);
            String spathid = "0000" + Integer.toHexString(pathid);
            spathid = spathid.substring(spathid.length() - 4);
            if (this.isSDHBoard) {
                spathid = "";
                sportid = "0" + sportid;
            }
            if (sportid.length() == 1) {
                sportid = "0" + sportid;
            }
            if (list.contains(sportid = pathid == 0 ? sportid + "0001" : sportid + spathid)) continue;
            list.add(sportid);
            part = input.getPart("objpara");
            String objparaValue = slotneid + "FF" + sportid;
            part.setValue(objparaValue);
            operationList.add(oper.clone());
        }
    }

    protected void filterOperationList(List operationList, int slotid, int boardType) {
        try {
            this.boardType = boardType;
            Operation curDataOper = null;
            Iterator iter = operationList.iterator();
            ArrayList list = new ArrayList();
            while (iter.hasNext()) {
                Operation tempOper;
                curDataOper = tempOper = (Operation)iter.next();
                if (!NSCMD_PER_GET_CURDATA_NEW.equals(tempOper.getName())) continue;
                this.setAttrIdQx(list, slotid, boardType, curDataOper, "W32PORT_ATTR_INPUTPOWER");
                this.setAttrIdQx(list, slotid, boardType, curDataOper, "W32PORT_ATTR_OUTPUTPOWER");
                iter.remove();
            }
            operationList.addAll(list);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("Error:" + e.getMessage());
        }
    }

    private List getSupportPortList(int neid, int slotid, String attrId) {
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        if (null == neObj) {
            return null;
        }
        TEBoard boardObj = neObj.getBoard(slotid);
        if (null == boardObj) {
            return null;
        }
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardObj.getBoardType());
        if (null == genCfgModel) {
            return null;
        }
        TEGenCfgAttribute attrObj = genCfgModel.getAttrFromId(attrId);
        if (null == attrObj && null == (attrObj = genCfgModel.getAttrFromId(attrId))) {
            return null;
        }
        ArrayList<TEGenCfgPortAttribute> portList = attrObj.getPortList();
        if (portList == null) {
            return null;
        }
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        boolean isDynBD = mgr.isDynPortBoardType(neid, boardObj.getBoardType());
        if (isDynBD) {
            ArrayList<TEGenCfgPortAttribute> tmpPortList = new ArrayList<TEGenCfgPortAttribute>();
            ArrayList existPortList = TEQueryLogicPort.getLogicPortList((int)neid, (int)slotid, (int)boardObj.getBoardType());
            for (Object e : portList) {
                TEGenCfgPortAttribute port = (TEGenCfgPortAttribute)e;
                if (!existPortList.contains(port.getPort())) continue;
                tmpPortList.add(port);
            }
            portList = tmpPortList;
        }
        Collections.sort(portList);
        return portList;
    }

    private void setInputAndOutputValueWhenNull(Input input, Output outputtemp, String attrId) {
        if (input.getPart(attrId) != null) {
            if (outputtemp.getPart(attrId) == null) {
                Part part = new Part();
                part.setType("int");
                part.setLength(2);
                part.setName(attrId);
                part.setValue("/");
                outputtemp.addPart(part);
            } else {
                outputtemp.getPart(attrId).setValue("/");
            }
            input.getPart(attrId).setValue("/");
        }
    }
}

