/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.netimesyn;

import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.wdm.netimesyn.TENESynFileMgr;
import com.huawei.nglct.nemgr.wdm.netimesyn.TENESynTimeData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class TENESynTimeQueryBean
extends TENEExplorerBean {
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private TEResourceUtil res = null;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        TENESynTimeData synTimeData;
        ArrayList<Object> tempOperationList = new ArrayList<Object>();
        int len = operationList.size();
        for (int t = 0; t < len; ++t) {
            tempOperationList.add(((Operation)operationList.get(t)).clone());
        }
        Datainterface tempOutputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, tempOperationList);
        if (null == tempOutputData) {
            return;
        }
        BussinessParams bParams = tempOutputData.getBussinessParams();
        if (null == bParams || bParams.getRowParamsCount() == 0) {
            return;
        }
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(tempOutputData.getErrorMessage());
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.getBussinessParams().addRowParams(new RowParams());
        RowParams outPutRowparams = this.outputData.getBussinessParams().getRowParams(0);
        RowParams[] tempRParams = bParams.getRowParams();
        outPutRowparams.setRowErrors(tempRParams[tempRParams.length - 1].getRowErrors());
        outPutRowparams.addParam("sychronmode", "");
        outPutRowparams.addParam("necurrtime", "");
        long nmTime = new GregorianCalendar().getTimeInMillis();
        outPutRowparams.addParam("nmtime", String.valueOf(nmTime));
        if (bParams.getRowParams(0).getParam("neid") != null) {
            Param neparam = new Param();
            TENE ne = TENEListMgr.getInstance().getNE(this.neid);
            neparam.setName("neid");
            neparam.setValue(String.valueOf(ne.getRealNEID()));
            outPutRowparams.addParam(neparam);
            outPutRowparams.addParam(bParams.getRowParams(0).getParam("nename"));
        }
        if ((synTimeData = TENESynFileMgr.getNeSynTimeInfo(neid)) == null) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)3843));
        } else {
            outPutRowparams.getParam("sychronmode").setValue(synTimeData.getSynMode());
            outPutRowparams.addParam("synstarttime", synTimeData.getSynStartDate());
            outPutRowparams.addParam("aoutsyncycle", synTimeData.getAutoSynCycle());
        }
        try {
            String neYear = "";
            String neMonth = "";
            String neDay = "";
            String neHour = "";
            String neMinute = "";
            String neSecond = "";
            int size = operationList.size();
            for (int j = 0; j < size; ++j) {
                Operation operation = (Operation)operationList.get(j);
                if (operation.getName().equals("NSCMD_CFG_GET_DATE")) {
                    neYear = operation.getOutput(0).getPartValue("neyear");
                    neMonth = operation.getOutput(0).getPartValue("nemonth");
                    neDay = operation.getOutput(0).getPartValue("neday");
                }
                if (!operation.getName().equals("NSCMD_CFG_GET_TIME")) continue;
                neHour = operation.getOutput(0).getPartValue("nehour");
                neMinute = operation.getOutput(0).getPartValue("neminute");
                neSecond = operation.getOutput(0).getPartValue("nesecond");
            }
            GregorianCalendar neTimeCalendar = new GregorianCalendar();
            neTimeCalendar.set(Integer.valueOf(neYear) + 1990, Integer.valueOf(neMonth) - 1, Integer.valueOf(neDay), Integer.valueOf(neHour), Integer.valueOf(neMinute), Integer.valueOf(neSecond));
            int timeZone = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).getTimeZone();
            outPutRowparams.getParam("necurrtime").setValue(String.valueOf(neTimeCalendar.getTimeInMillis() + (long)(timeZone * 60 * 1000)));
        }
        catch (Exception e) {
            outPutRowparams.getParam("necurrtime").setValue("");
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final Datainterface finalinputData = inputData;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TENESynTimeQueryBean.this.addProtectionToString(finalinputData);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String addProtectionToString(Datainterface inputData) {
        StringBuffer strBufTmp = new StringBuffer();
        Param[] paramsTmp = inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])paramsTmp, (String)"neId").getValue());
        String neName = this.mgr.getNE(neId).getNEName();
        StringBuffer filePath = new StringBuffer();
        filePath.append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("netimesyn").append(File.separator).append("netimesynlog_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neId, (StringBuffer)filePath);
        strBufTmp.append(this.res.getString("NEname")).append(":").append(neName).append("  ");
        strBufTmp.append(this.res.getString("quaryNETime"));
        return strBufTmp.toString();
    }
}

