/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.fault;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.lpara.TEAlmReturnParamParse;
import com.huawei.nglct.nelist.lpara.TELParamMgr;
import com.huawei.nglct.nelist.lpara.TEObjectParam;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEAlarmInverse;
import com.huawei.nglct.nelist.model.alarm.TEAlarmMonObjID;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryPortInverseBean
extends TECommonWriteLogBean {
    private ArrayList filterErrorCodeList = new ArrayList();
    private static final int errorCode = 38153;
    private int cpType = -1;
    private int slotID = -1;
    TELParamMgr objTypeMgr = null;
    private static Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.operationList = new ArrayList();
        this.objTypeMgr = new TELParamMgr(neid);
        try {
            this.getCpType(inputData);
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ALM_GET_INVERSE_STATE_EX");
            ArrayList list = TEAlarmDataMgr.getInstance().getInverseList(this.cpType);
            TEAlarmInverse alarminverse = null;
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                alarminverse = (TEAlarmInverse)list.get(i);
                Operation operation = this.setQXData(oper, alarminverse.getPortID());
                this.operationList.add(operation);
            }
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                if (this.isNeedOperationlog()) {
                    this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
                }
                return this.outputData;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)this.TIME_OUT).retCode;
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc, this.filterErrorCodeList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            log.error("query alarm inverse fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return this.outputData;
        }
        return this.outputData;
    }

    private Operation setQXData(Operation oper, int portid) {
        Input input = oper.getInput();
        Part part = input.getPart("alarmID");
        part.setValue(Integer.valueOf(0).toString());
        part = input.getPart("reserve");
        part.setValue(Integer.valueOf(255).toString());
        TEAlarmMonObjID alarmMon = new TEAlarmMonObjID(this.neid, this.slotID, portid, 0, 1, 0, 0);
        String objType = TESpecialAttrMgr.getInstance().getCPAttrValue(this.neid, this.slotID, "TE_FUNC_PORT_INVERSE", "TE_ATTR_SUPPORT_REVERSEALARM_CUSTOM_OBJTYPE");
        if (objType == null || objType.isEmpty()) {
            objType = "96";
        }
        TEObjectParam objparam = this.objTypeMgr.getObjectParam(objType, alarmMon);
        part = input.getPart("objtype");
        part.setValue(objparam.getObjType());
        part = input.getPart("paralen");
        part.setValue(objparam.getParamLength());
        part = input.getPart("objpara");
        part.setValue(objparam.getObjParam());
        return (Operation)oper.clone();
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.regroupOutputOperation(operationList);
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        ArrayList list = TEAlarmDataMgr.getInstance().getInverseList(this.cpType);
        ArrayList<Object> inverseList = new ArrayList<Object>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            inverseList.add(((TEAlarmInverse)list.get(i)).clone());
        }
        Collections.sort(inverseList);
        if (null == this.outputData || null == this.outputData.getBussinessParams()) {
            this.outputData = this.getOutPut(inverseList);
            return;
        }
        if (this.outputData.getBussinessParams().getRowParamsCount() == 0) {
            this.outputData = this.getOutPut(inverseList);
            return;
        }
        this.handleNewMessage(inverseList);
        this.parseLenParaToError(this.outputData.getBussinessParams());
    }

    private Datainterface getOutPut(ArrayList list) {
        TEAlarmInverse tEAlarmInverse = null;
        Datainterface tempOutputData = new Datainterface();
        tempOutputData.setBussinessParams(new BussinessParams());
        RowParams rowParam = new RowParams();
        tempOutputData.getBussinessParams().addRowParams(rowParam);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            tEAlarmInverse = (TEAlarmInverse)list.get(i);
            rowParam = new RowParams();
            Param[] params = tEAlarmInverse.toRowParams();
            for (int j = 0; j < params.length; ++j) {
                rowParam.addParam(params[j]);
            }
            tempOutputData.getBussinessParams().addRowParams(rowParam);
        }
        tempOutputData.setErrorMessage(new ErrorMessage());
        tempOutputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        return tempOutputData;
    }

    private void getCpType(Datainterface inputData) {
        Param[] paramArr = inputData.getBussinessParams().getRowParams(0).getParam();
        int size = paramArr.length;
        for (int i = 0; i < size; ++i) {
            if (paramArr[i].getName().equalsIgnoreCase("boardType")) {
                try {
                    this.cpType = Integer.parseInt(paramArr[i].getValue());
                }
                catch (NumberFormatException e) {
                    TELogFactory.getNormalLogger().error("Get slotid fail:\n", (Throwable)e);
                }
                continue;
            }
            if (!paramArr[i].getName().equalsIgnoreCase("slotID")) continue;
            this.slotID = Integer.parseInt(paramArr[i].getValue());
        }
    }

    public ArrayList getFilterErrorCodeList() {
        this.filterErrorCodeList.add(38153);
        return this.filterErrorCodeList;
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getSinleDetailInfo(RowParams[] rParams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer strBufResult = new StringBuffer();
        String boardString = res.getString("board");
        int slotID = -1;
        strBufResult.append(boardString);
        slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
        strBufResult.append(TEBoardUtil.getShelfBoardName((int)this.neid, (int)slotID));
        return strBufResult.toString();
    }

    private void regroupOutputOperation(ArrayList operationList) {
        for (int i = 0; i < operationList.size(); ++i) {
            Operation oper = (Operation)operationList.get(i);
            Output[] output = oper.getOutput();
            for (int j = 0; j < output.length; ++j) {
                if (!output[j].getFault(0).getCode().equals("0")) continue;
                Part slotIdPart = new Part();
                Part portIdPart = new Part();
                Part pathIdPart = new Part();
                Part objParaPart = output[j].getPart("objpara");
                String hexobjParaValue = objParaPart.getValue();
                String hexSlotIdValue = hexobjParaValue.substring(0, 4);
                String hexPortIdValue = hexobjParaValue.substring(6, 8);
                String hexPathIdValue = hexobjParaValue.substring(8, 10);
                String slotIdValue = Integer.parseInt(hexSlotIdValue, 16) + "";
                String portIdValue = Integer.parseInt(hexPortIdValue, 16) + "";
                String pathIdValue = Integer.parseInt(hexPathIdValue, 16) + "";
                slotIdPart.setName("slotID");
                slotIdPart.setValue(slotIdValue);
                portIdPart.setName("opticalID");
                portIdPart.setValue(portIdValue);
                pathIdPart.setName("pathID");
                pathIdPart.setValue(pathIdValue);
                output[j].addPart(slotIdPart);
                output[j].addPart(portIdPart);
                output[j].addPart(pathIdPart);
            }
        }
    }

    private void handleNewMessage(ArrayList inverseList) {
        int i;
        ArrayList<InverseStructBean> inverseStructBeanArray = new ArrayList<InverseStructBean>();
        InverseStructBean strunct = null;
        for (int i2 = 0; i2 < inverseList.size(); ++i2) {
            TEAlarmInverse tmpTEAlarmInverse = (TEAlarmInverse)inverseList.get(i2);
            strunct = new InverseStructBean();
            strunct.portId = tmpTEAlarmInverse.getPortID();
            inverseStructBeanArray.add(strunct);
        }
        Param param = null;
        int opticalID = -1;
        int inverseStatus = -1;
        for (i = 0; i < inverseStructBeanArray.size(); ++i) {
            strunct = (InverseStructBean)inverseStructBeanArray.get(i);
            int currentPortId = strunct.portId;
            for (int j = 0; j < this.outputData.getBussinessParams().getRowParamsCount(); ++j) {
                RowParams tmpRowParams = this.outputData.getBussinessParams().getRowParams(j);
                param = tmpRowParams.getParam("opticalID");
                if (param == null) {
                    this.outputData.getBussinessParams().removeRowParams(j);
                    --j;
                    continue;
                }
                opticalID = Integer.parseInt(param.getValue());
                param = tmpRowParams.getParam("inverseStatus");
                if (param == null) {
                    this.outputData.getBussinessParams().removeRowParams(j);
                    --j;
                    continue;
                }
                inverseStatus = Integer.parseInt(param.getValue());
                if (currentPortId != opticalID) continue;
                strunct.alarmStatusList.add(inverseStatus);
            }
        }
        i = 0;
        int inverseIndex = 0;
        while (i < inverseStructBeanArray.size()) {
            TEAlarmInverse tmpTEAlarmInverse;
            strunct = (InverseStructBean)inverseStructBeanArray.get(i);
            ArrayList alarmStatusList = strunct.alarmStatusList;
            HashSet alarmStatusSet = new HashSet();
            for (int j = 0; j < alarmStatusList.size(); ++j) {
                alarmStatusSet.add(alarmStatusList.get(j));
            }
            if (alarmStatusSet.size() > 1) {
                tmpTEAlarmInverse = (TEAlarmInverse)inverseList.get(inverseIndex);
                tmpTEAlarmInverse.setDefaultvalue(-1);
            } else {
                tmpTEAlarmInverse = (TEAlarmInverse)inverseList.get(inverseIndex);
                Object[] objArray = alarmStatusSet.toArray();
                if (objArray != null && objArray.length > 0) {
                    Integer intReverseState = (Integer)objArray[0];
                    tmpTEAlarmInverse.setDefaultvalue(intReverseState.intValue());
                } else {
                    inverseList.remove(inverseIndex);
                    --inverseIndex;
                }
            }
            ++i;
            ++inverseIndex;
        }
        this.outputData = this.getOutPut(inverseList);
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        if (ne.getLogStatus() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)37926));
        }
    }

    public void parseLenParaToError(BussinessParams bussiness) {
        if (null == bussiness) {
            return;
        }
        RowParams rowparams = null;
        TEAlmObjTypeData almObjTypeObj = null;
        TEPfmMonObjID monObjTmp = null;
        int nLength = bussiness.getRowParamsCount();
        for (int i = 0; i < nLength; ++i) {
            rowparams = bussiness.getRowParams(i);
            RowErrors[] errors = rowparams.getRowErrors();
            Param param = null;
            for (int j = 0; j < errors.length; ++j) {
                param = errors[j].getParam("objtype");
                almObjTypeObj = this.objTypeMgr.getAlmObjTypeData(Integer.valueOf(param.getValue()).intValue());
                if (almObjTypeObj != null) {
                    param = errors[j].getParam("objpara");
                    byte[] objByte = param.getValue().getBytes();
                    monObjTmp = TEAlmReturnParamParse.getInstance().parseObjParam(objByte, almObjTypeObj);
                    param.setValue("");
                }
                if (monObjTmp == null) continue;
                int slotid = monObjTmp.getSlotID();
                param = new Param("slotID", slotid + "");
                errors[j].addParam(param);
                int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
                param = new Param("boardtype", boardtype + "");
                errors[j].addParam(param);
                param = new Param("boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype));
                errors[j].addParam(param);
                int portid = monObjTmp.getPortID();
                param = new Param("opticalID", portid + "");
                errors[j].addParam(param);
            }
        }
    }

    private static class InverseStructBean {
        public int portId = -1;
        public ArrayList alarmStatusList = new ArrayList();

        private InverseStructBean() {
        }
    }
}

