/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEPortBitErrorTh;
import com.huawei.nglct.nemgr.ngwdm.fault.TEBitErrThMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryBitErrorBean
extends TENEExplorerBean {
    private static final int TIME_OUT = 10;
    private int slotID = -1;
    private int boardType = -1;
    private TEBitErrThMgr tEBitErrThMgr = TEBitErrThMgr.getInstance();
    private static Logger log = TELogFactory.getNormalLogger();
    private TEResourceUtil res = null;
    private int level = -1;
    private ArrayList filterErrorCodeList = new ArrayList();
    private static final int ERROR_CODE_NOT_SUPPORTED = 38737;
    private static final int ERROR_CODE_NOT_SUPPORTED_BDTYPE = 38664;
    private static final String NE_NOT_LOGIN = "37926";
    HashMap bitErrorMap = new HashMap();
    boolean isBreanchBoard = false;
    private int errorCode = 0;
    private static final String OTN = "1";
    private static final String SDH = "2";
    private static final int L4G = 927;
    private static final int LDGD = 919;
    private static final int LDGS = 920;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            this.boardType = Integer.parseInt(rParams[0].getParam("boardType").getValue());
            this.slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
            this.operationList = this.queryBitError(neid);
            if (null == this.operationList) {
                if (this.isNeedOperationlog()) {
                    this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
                }
                log.info("The operationlist is null!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.errorCode));
                return this.outputData;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)10).retCode;
            if (result == 0) {
                this.handleMessage(result);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            log.error("query bit error fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return this.outputData;
        }
        if (!this.outputData.getErrorMessage().getErrorcode().equals("0")) {
            BussinessParams bussinessParams = this.outputData.getBussinessParams();
            if (bussinessParams == null) {
                return this.outputData;
            }
            if (bussinessParams.getRowParamsCount() == 0) {
                return this.outputData;
            }
            RowParams rowparams = bussinessParams.getRowParams(bussinessParams.getRowParamsCount() - 1);
            RowErrors rowErrors = rowparams.getRowErrors(0);
            if (rowErrors.getErrorMessage().getErrorcode().equals(NE_NOT_LOGIN)) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_LOGIN)));
                for (int i = rowparams.getRowErrorsCount() - 1; i >= 0; --i) {
                    rowparams.removeRowErrors(rowparams.getRowErrors(i));
                }
            }
        }
        return this.outputData;
    }

    public void handleMessage(int result) {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        if (ne.getLogStatus() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)37926));
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)result));
        BussinessParams bParams = new BussinessParams();
        this.outputData.setBussinessParams(bParams);
        ArrayList<TEPortBitErrorTh> BitErrorThList = new ArrayList<TEPortBitErrorTh>();
        int size = this.operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation oper = (Operation)this.operationList.get(i);
            if (!oper.getOutput()[0].getFault()[0].getCode().equalsIgnoreCase(String.valueOf(0))) continue;
            Part[] parts = oper.getOutput()[0].getPart();
            String PortID = OTN;
            String PathID = OTN;
            TEBitErrorTh bitError = new TEBitErrorTh();
            for (Part part : parts) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("portID")) {
                    PortID = value;
                    continue;
                }
                if (name.equalsIgnoreCase("pathID")) {
                    PathID = value;
                    continue;
                }
                if (name.indexOf("biterr_type_") < 0) continue;
                int index = name.lastIndexOf("_");
                bitError.setThtype(new Integer(name.substring(index + 1)).intValue());
                bitError.setBitErrorvalue(value);
                String key = PortID + "-" + PathID;
                if (!this.bitErrorMap.containsKey(key)) continue;
                TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)this.bitErrorMap.get(key);
                tEPortBitErrorTh.getBitErrorThList().add(bitError.clone());
            }
        }
        for (TEPortBitErrorTh tEPortBitErrorTh : this.bitErrorMap.values()) {
            BitErrorThList.add(tEPortBitErrorTh);
        }
        Collections.sort(BitErrorThList);
        int port = 0;
        String nename = ne.getNEName();
        String boardname = ne.getBoard(this.slotID).getBoardName();
        String portname = "";
        String monObject = "";
        int size2 = BitErrorThList.size();
        for (int i = 0; i < size2; ++i) {
            TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)BitErrorThList.get(i);
            RowParams rows = tEPortBitErrorTh.toRowParams(this.isBreanchBoard);
            rows.addParam("netype", ne.getDeviceType());
            String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID);
            if (!subrackname.equals("")) {
                String neandsubrackname = nename + "-" + subrackname;
                rows.addParam("nename", neandsubrackname);
                monObject = neandsubrackname + "-" + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID) + "-" + boardname + "-";
            } else {
                monObject = nename + "-" + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID) + "-" + boardname + "-";
            }
            port = tEPortBitErrorTh.getPortID();
            portname = TEConfigurationDataMgr.getInstance().getPortName(this.neid, this.slotID, this.boardType, port);
            rows.addParam("boardname", boardname);
            rows.addParam("slotid", String.valueOf(this.slotID));
            if (null != rows.getParam("monObject")) {
                rows.getParam("monObject").setValue(monObject + portname + "-" + tEPortBitErrorTh.getPathID());
            } else {
                rows.addParam("monObject", monObject + portname + "-" + tEPortBitErrorTh.getPathID());
            }
            bParams.addRowParams(rows);
        }
    }

    private ArrayList queryBitError(int neID) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = null;
        String seviceType = "";
        String portList = "";
        try {
            ArrayList tEPortBitErrorThList = TEAlarmDataMgr.getInstance().getBITThList(this.boardType);
            ArrayList<Operation> operListServiceType = new ArrayList<Operation>();
            Operation operServiceType = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_WDMMODE");
            Input inputServiceType = operServiceType.getInput();
            inputServiceType.setPartValue("slotid", this.slotID + "");
            ArrayList filterPortList = this.filterPortList(this.neid, tEPortBitErrorThList);
            int len = filterPortList.size();
            for (int i = 0; i < len; ++i) {
                int j;
                TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)filterPortList.get(i);
                int portID = tEPortBitErrorTh.getPortID();
                int pathID = tEPortBitErrorTh.getPathID();
                if (0 > portList.indexOf(portID + "") && (927 == this.boardType || 919 == this.boardType || 920 == this.boardType)) {
                    seviceType = "";
                    inputServiceType.setPartValue("port", portID + "");
                    portList = portList + portID + "-";
                    operListServiceType.add(operServiceType);
                    OperationResult resultServiceType = TENECommMgr.getInstance().sendCommand(this.neid, operListServiceType, 10);
                    if (resultServiceType.retCode != 0) {
                        this.errorCode = resultServiceType.retCode;
                        return null;
                    }
                    Operation tmpOper = (Operation)operListServiceType.get(0);
                    Output[] outputArr = tmpOper.getOutput();
                    int lenOut = outputArr.length;
                    for (j = 0; j < lenOut; ++j) {
                        Output output = outputArr[j];
                        for (Fault fault : output.getFault()) {
                            int code = Integer.parseInt(fault.getCode());
                            if (code == 0) continue;
                            this.errorCode = code;
                            return null;
                        }
                        Part[] partArr = output.getPart();
                        seviceType = Definitions.getParam((Part[])partArr, (String)"W32PORT_ATTR_ST_SERVICEMODE").getValue();
                    }
                }
                TEPortBitErrorTh bitErrorTh = new TEPortBitErrorTh();
                bitErrorTh.setPortID(portID);
                bitErrorTh.setPathID(pathID);
                ArrayList bitErrorThList = tEPortBitErrorTh.getBitErrorThList();
                if (this.tEBitErrThMgr.isNABitError(bitErrorThList)) continue;
                this.bitErrorMap.put(bitErrorTh.makeBitErrorKey(), bitErrorTh);
                bitErrorThList = this.tEBitErrThMgr.delNABitErrorList(bitErrorThList);
                int length = bitErrorThList.size();
                if (length % 2 != 0 && ("".equals(seviceType) || OTN.equals(seviceType))) {
                    oper = this.setFECQXData(this.slotID, portID, pathID);
                    operationList.add(oper);
                    --length;
                }
                for (j = 0; j < length; ++j) {
                    TEBitErrorTh tEBitErrorTh = (TEBitErrorTh)bitErrorThList.get(j);
                    int type = tEBitErrorTh.getThtype();
                    int bitType = this.tEBitErrThMgr.getBitType(type);
                    if (bitType == -1) {
                        ++j;
                        continue;
                    }
                    if ((1 == type || 2 == type) && ("".equals(seviceType) || SDH.equals(seviceType))) {
                        oper = this.setSDHQXData(neID, this.slotID, portID, pathID, bitType);
                        operationList.add(oper);
                    } else if (type > 2 && type < 18 && ("".equals(seviceType) || OTN.equals(seviceType))) {
                        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
                        this.level = Integer.parseInt(rParams[0].getParam("level").getValue());
                        oper = this.setOTNQXData(this.slotID, portID, pathID, bitType, this.level);
                        operationList.add(oper);
                    }
                    ++j;
                }
            }
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return operationList;
    }

    private Operation setSDHQXData(int neID, int slotID, int portID, int pathID, int bitType) {
        Operation oper = null;
        Input input = null;
        Part part = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_B1B2B3_SFSDTH");
            input = oper.getInput();
            part = input.getPart("pathID");
            part.setValue(String.valueOf(pathID));
            part = input.getPart("slotID");
            part.setValue(Integer.valueOf(slotID).toString());
            part = input.getPart("portID");
            part.setValue(Integer.valueOf(portID).toString());
            part = input.getPart("bitType");
            part.setValue(Integer.valueOf(bitType).toString());
            oper.getOutput(0).getPart("exceedValue").setName(this.tEBitErrThMgr.getSDHExceedType(bitType));
            oper.getOutput(0).getPart("badValue").setName(this.tEBitErrThMgr.getSDHBadType(bitType));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private Operation setFECQXData(int slotID, int portID, int pathID) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_BEFORE_FEC_TH");
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(Integer.valueOf(slotID).toString());
            part = input.getPart("portID");
            part.setValue(Integer.valueOf(portID).toString());
            part = input.getPart("pathID");
            part.setValue(String.valueOf(pathID));
            oper.getOutput(0).getPart("excValue").setName("biterr_type_35");
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private Operation setOTNQXData(int slotID, int portID, int pathID, int bitType, int level) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_OTNBIP8");
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(Integer.valueOf(slotID).toString());
            part = input.getPart("portID");
            part.setValue(Integer.valueOf(portID).toString());
            part = input.getPart("pathID");
            part.setValue(String.valueOf(pathID));
            part = input.getPart("level");
            part.setValue(String.valueOf(level));
            part = input.getPart("bitType");
            part.setValue(Integer.valueOf(bitType).toString());
            oper.getOutput(0).getPart("exceedValue").setName(this.tEBitErrThMgr.getOTNExceedType(bitType));
            oper.getOutput(0).getPart("badValue").setName(this.tEBitErrThMgr.getOTNBadType(bitType));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            StringBuffer filePath = new StringBuffer();
            filePath.append("necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            this.res = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                loginfo.setUserID(userID);
            }
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateName(subfunc.getSubFuncDes(neid));
            loginfo.setOperateObject("");
            loginfo.setOperateDesc(this.alarmToString());
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                loginfo.setOperateObject(String.valueOf(neid));
            } else {
                loginfo.setOperateObject(neObj.getNEName());
            }
            if (errorCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            } else if (errorCode == 2 || errorCode == 1) {
                loginfo.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    loginfo.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    loginfo.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    loginfo.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(loginfo);
                    break;
                }
            } else {
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Throwable e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", e);
            return;
        }
    }

    private String alarmToString() {
        TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer strBuf = new StringBuffer();
        String boardString = this.res.getString("board");
        strBuf.append(boardString);
        strBuf.append(TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID)).append("-").append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID)).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, this.boardType));
        return strBuf.toString();
    }

    public ArrayList getFilterErrorCodeList() {
        this.filterErrorCodeList.add(38737);
        this.filterErrorCodeList.add(38664);
        this.filterErrorCodeList.add(38777);
        this.filterErrorCodeList.add(39555);
        return this.filterErrorCodeList;
    }

    private ArrayList filterPortList(int neid, ArrayList tEPortBitErrorThList) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        ArrayList logicList = mgr.getLogicPortList(neid, this.slotID);
        if (!mgr.isDynPortBoardType(neid, this.boardType)) {
            return tEPortBitErrorThList;
        }
        ArrayList listClone = (ArrayList)tEPortBitErrorThList.clone();
        for (int i = listClone.size() - 1; i > 0; --i) {
            TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)listClone.get(i);
            int portID = tEPortBitErrorTh.getPortID();
            if (logicList.contains(portID)) continue;
            listClone.remove(tEPortBitErrorTh);
        }
        return listClone;
    }
}

