/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.lpara.TEAlmReturnParamParse;
import com.huawei.nglct.nelist.lpara.TELParamMgr;
import com.huawei.nglct.nelist.lpara.TEObjectParam;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEAlarmMonObjID;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;

public class TEApplyPortInverseBean
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    TELParamMgr objTypeMgr = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
        this.objTypeMgr = new TELParamMgr(neid);
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            for (int i = 0; i < inputData.getBussinessParams().getRowParamsCount(); ++i) {
                RowParams tmpRowParams = inputData.getBussinessParams().getRowParams()[i];
                String strSlotId = tmpRowParams.getParam("slotID").getValue();
                String strInverseStatus = tmpRowParams.getParam("inverseStatus").getValue();
                String strPortId = tmpRowParams.getParam("opticalID").getValue();
                Operation op = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ALM_SET_INVERSE_STATE_EX");
                Part part = null;
                part = op.getInput().getPart("alarmID");
                part.setValue("0");
                part = op.getInput().getPart("inverseStatus");
                part.setValue(strInverseStatus);
                part = op.getInput().getPart("reserve");
                part.setValue("255");
                int intSlotId = Integer.parseInt(strSlotId);
                int intPortId = Integer.parseInt(strPortId);
                TEAlarmMonObjID alarmMon = new TEAlarmMonObjID(neid, intSlotId, intPortId, 0, 1, 0, 0);
                String objType = TESpecialAttrMgr.getInstance().getCPAttrValue(neid, intSlotId, "TE_FUNC_PORT_INVERSE", "TE_ATTR_SUPPORT_REVERSEALARM_CUSTOM_OBJTYPE");
                if (objType == null || objType.isEmpty()) {
                    objType = "96";
                }
                TEObjectParam objparam = this.objTypeMgr.getObjectParam(objType, alarmMon);
                part = op.getInput().getPart("objtype");
                part.setValue(objparam.getObjType());
                part = op.getInput().getPart("paralen");
                part.setValue(objparam.getParamLength());
                part = op.getInput().getPart("objpara");
                part.setValue(objparam.getObjParam());
                operationList.add(op);
            }
            return operationList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (ne.getLogStatus() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)37926));
            return;
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        this.parseLenParaToError(this.outputData.getBussinessParams());
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEApplyPortInverseBean.this.alarmToString();
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String alarmToString() {
        TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer strBuf = new StringBuffer();
        String boardString = this.res.getString("board");
        int boardType = -1;
        int slotID = -1;
        strBuf.append(boardString);
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
        boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID);
        String subrack = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID);
        if (!subrack.equals("")) {
            strBuf.append(subrack + "-" + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotID)).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, boardType));
        } else {
            strBuf.append(slotID).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, boardType));
        }
        String alm_inverse_state = this.res.getString("alm_inverse_state");
        String inverseString = rParams[0].getParam("inverseStatus").getValue();
        String inverseValue = this.res.getString("alm_inverse_state_" + inverseString);
        strBuf.append(", ").append(alm_inverse_state).append(inverseValue);
        return strBuf.toString();
    }

    public void parseLenParaToError(BussinessParams bussiness) {
        if (null == bussiness) {
            return;
        }
        RowParams rowparams = null;
        TEAlmObjTypeData almObjTypeObj = null;
        TEPfmMonObjID monObj = null;
        int nLength = bussiness.getRowParamsCount();
        for (int i = 0; i < nLength; ++i) {
            rowparams = bussiness.getRowParams(i);
            RowErrors[] errors = rowparams.getRowErrors();
            Param param = null;
            for (int j = 0; j < errors.length; ++j) {
                param = errors[j].getParam("objtype");
                almObjTypeObj = this.objTypeMgr.getAlmObjTypeData(Integer.valueOf(param.getValue()).intValue());
                if (almObjTypeObj != null) {
                    param = errors[j].getParam("objpara");
                    byte[] objByte = param.getValue().getBytes();
                    monObj = TEAlmReturnParamParse.getInstance().parseObjParam(objByte, almObjTypeObj);
                }
                if (monObj == null) continue;
                int slotid = monObj.getSlotID();
                param = new Param("slotID", slotid + "");
                errors[j].addParam(param);
                int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
                param = new Param("boardtype", boardtype + "");
                errors[j].addParam(param);
                param = new Param("boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype));
                errors[j].addParam(param);
                int portid = monObj.getPortID();
                param = new Param("opticalID", portid + "");
                errors[j].addParam(param);
            }
        }
    }
}

