/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.fault;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEAlarmMonObjID;
import com.huawei.nglct.nemgr.necommon.fault_v2r7c02.TEAlarmObject;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEApplyBoardAlarmSuppress
extends TECommonWriteLogBean {
    private static final String NE_NOT_LOGIN = "37926";
    private Operation oper = null;
    TEAlmObjTypeMgr objTypeMgr = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.objTypeMgr = new TEAlmObjTypeMgr(neid);
            this.oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ALM_SET_MONSTATE_EX");
            this.operationList = this.applyAlarmSuppress();
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private ArrayList applyAlarmSuppress() {
        ArrayList operationList = new ArrayList();
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        int len = rParams.length;
        for (int i = 0; i < len; ++i) {
            operationList.addAll(this.setQxData(rParams[i]));
        }
        return operationList;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(Integer.valueOf("38146"));
        errorCodeList.add(Integer.valueOf("38748"));
        errorCodeList.add(Integer.valueOf("42297"));
        return errorCodeList;
    }

    private List setQxData(RowParams rParams) {
        ArrayList<Operation> operationLs = new ArrayList<Operation>();
        String alarmID = rParams.getParam("alarmID").getValue();
        String suppState = rParams.getParam("suppressState").getValue();
        String almObjStr = rParams.getParam("almObj").getValue();
        String[] almObjArray = almObjStr.split("-");
        for (int n = 0; n < almObjArray.length; ++n) {
            String obj = almObjArray[n].replace('[', ' ');
            obj = obj.replace(']', ' ');
            obj = obj.trim();
            String[] almObj = obj.split(":");
            TEAlarmObject alarmObj = new TEAlarmObject();
            alarmObj.setObjType(almObj[0]);
            alarmObj.setLength(Integer.parseInt(almObj[1]));
            String objParm = "";
            objParm = almObj.length >= 3 ? almObj[2] : "";
            alarmObj.setObjPara(objParm);
            Operation oper = this.setQXData(alarmID, suppState, alarmObj);
            operationLs.add(oper);
        }
        return operationLs;
    }

    private Operation setQXData(String alarmID, String suppressState, TEAlarmObject alarmObj) {
        Input input = this.oper.getInput();
        Part part = input.getPart("alarmID");
        part.setValue(alarmID);
        part = input.getPart("suppressState");
        part.setValue(suppressState);
        part = input.getPart("reserve");
        part.setValue(new Integer(255).toString());
        part = input.getPart("objtype");
        part.setValue(alarmObj.getObjType());
        if ("20".equals(alarmObj.getObjType())) {
            part = input.getPart("paralen");
            part.setValue("0");
            part = input.getPart("objpara");
            part.setValue("");
        } else {
            part = input.getPart("paralen");
            part.setValue(alarmObj.getLength() + "");
            part = input.getPart("objpara");
            part.setValue(alarmObj.getObjPara());
        }
        return (Operation)this.oper.clone();
    }

    private TEAlarmMonObjID getMonObj(Datainterface inputData) {
        TEAlarmMonObjID almmonobj = new TEAlarmMonObjID();
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        almmonobj.m_ulNEID = Integer.parseInt(rParams[0].getParam("neid").getValue());
        almmonobj.m_usSlotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
        almmonobj.m_usFBType = Integer.parseInt(rParams[0].getParam("fbType").getValue());
        almmonobj.m_usOldFBType = Integer.parseInt(rParams[0].getParam("oldFbType").getValue());
        almmonobj.m_usPortID = Integer.parseInt(rParams[0].getParam("opticalID").getValue());
        almmonobj.m_usPathID = Integer.parseInt(rParams[0].getParam("pathID").getValue());
        return almmonobj;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (ne.getLogStatus() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)37926));
            return;
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        if (!this.outputData.getErrorMessage().getErrorcode().equals("0")) {
            BussinessParams bussinessParams = this.outputData.getBussinessParams();
            if (bussinessParams == null) {
                return;
            }
            if (bussinessParams.getRowParamsCount() == 0) {
                return;
            }
            RowParams rowparams = bussinessParams.getRowParams(bussinessParams.getRowParamsCount() - 1);
            RowErrors rowErrors = rowparams.getRowErrors(0);
            if (rowErrors.getErrorMessage().getErrorcode().equals(NE_NOT_LOGIN)) {
                this.outputData = new Datainterface();
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_LOGIN)));
            } else {
                for (int i = rowparams.getRowErrorsCount() - 2; i >= 0; --i) {
                    rowparams.removeRowErrors(rowparams.getRowErrors(i));
                }
            }
        }
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getDetailInfo(RowParams[] rParams) {
        TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer strAlarmBuf = new StringBuffer();
        StringBuffer filePath = new StringBuffer();
        filePath.append("necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        String boardString = res.getString("board");
        int boardType = -1;
        int slotID = -1;
        strAlarmBuf.append(boardString);
        slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
        boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID);
        String subrack = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID);
        if (!subrack.equals("")) {
            strAlarmBuf.append(subrack + "-" + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotID)).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, boardType));
        } else {
            strAlarmBuf.append(slotID).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, boardType));
        }
        String suppressStateString = rParams[0].getParam("suppressState").getValue();
        String alm_sup_state = res.getString("alm_sup_state");
        String suppressState = res.getString("alm_sup_state_" + suppressStateString);
        strAlarmBuf.append(", ").append(alm_sup_state).append(suppressState);
        return strAlarmBuf.toString();
    }
}

