/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.fanattribute;

import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TESetFanSpeedMode
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "ngwdm" + File.separator + "res" + File.separator;
    private static final String FUNC_DES_RES = BASE_PATH + "funcdesres_" + LANGUAGE + ".ini";
    private TEResourceUtil res = null;
    private List logInfoList = new ArrayList();
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            this.res = TEGetFilePath.getResource((int)neid, (String)FUNC_DES_RES);
            if (outputData.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            TENE neObj = this.cfgDataMgr.getNE(neid);
            String operateObject = "";
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = subfunc.getSubFuncDes(neid);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            switch (errorCode) {
                case 1090646019: {
                    break;
                }
                case 0: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode);
                    break;
                }
                case 1: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode);
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                case 2: {
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                default: {
                    this.logOther(user, ipAddress, operateObject, operateName, errorCode);
                }
            }
            int size = this.logInfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)this.logInfoList.get(i)));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void logSuccess(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        RowParams rowParams = null;
        int rowCount = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            String desc = "";
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(this.subfunc.getCode());
            loginfo.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                loginfo.setUserID(userID);
            }
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateObject(operateObject);
            loginfo.setOperateName(operateName);
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            String speedMode = rowParams.getParam("speedMode").getValue();
            String mode = this.res.getString(this.subfunc.getDes() + "_" + speedMode);
            desc = desc + operateName + ":" + mode;
            loginfo.setOperateDesc(desc);
            loginfo.setResult(0);
            loginfo.setErrCode(0);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            this.logInfoList.add(loginfo);
        }
    }

    private void logFail(String user, String ipAddress, String operateObject, String operateName) {
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowErrors[] rowErrors = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
            int size = rowErrors.length;
            for (int j = 0; j < size; ++j) {
                String speedMode = rowErrors[j].getParam("speedMode").getValue();
                String desc = "";
                String mode = this.res.getString(this.subfunc.getDes() + "_" + speedMode);
                desc = desc + operateName + ":" + mode;
                for (int k = this.logInfoList.size() - 1; k >= 0; --k) {
                    TELogInfo loginfo = (TELogInfo)this.logInfoList.get(k);
                    if (!loginfo.getOperateDesc().equalsIgnoreCase(desc)) continue;
                    this.logInfoList.remove(k);
                }
                TELogInfo loginfo = new TELogInfo();
                loginfo.setCmdID(this.subfunc.getCode());
                loginfo.setLocation(ipAddress);
                if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    int userID = 0;
                    try {
                        userID = Integer.parseInt(user);
                    }
                    catch (Exception e) {
                        userID = 0;
                    }
                    loginfo.setUserID(userID);
                }
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateObject(operateObject);
                loginfo.setOperateName(operateName);
                loginfo.setOperateDesc(desc);
                loginfo.setResult(2);
                loginfo.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                loginfo.setErrInfo(rowErrors[i].getErrorMessage().getErrorinfo());
                this.logInfoList.add(loginfo);
            }
        }
    }

    private void logOther(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        TELogInfo loginfo = new TELogInfo();
        loginfo.setCmdID(this.subfunc.getCode());
        loginfo.setLocation(ipAddress);
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            int userID = 0;
            try {
                userID = Integer.parseInt(user);
            }
            catch (Exception e) {
                userID = 0;
            }
            loginfo.setUserID(userID);
        }
        loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
        loginfo.setOperateObject(operateObject);
        loginfo.setOperateName(operateName);
        loginfo.setOperateDesc(operateName);
        loginfo.setResult(2);
        loginfo.setErrCode(errorCode);
        loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        this.logInfoList.add(loginfo);
    }
}

