/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm.exc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TEWDMEXCConvertSNCPToNormalBean
implements TENEMgrInterface {
    private int neID = -1;
    private int pctGroupID = -1;
    private String[] excLevelArray = null;
    private String[] excDirectionArray = null;
    private String[] excsrcPathNameArray = null;
    private String[] excpsrcPathNameArray = null;
    private String[] excsnkPathNameArray = null;
    private String[] worksrcPathNameArray = null;
    private String[] worksnkPathNameArray = null;
    private String[] pctsrcPathNameArray = null;
    private int convertSize = 0;

    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neID;
        int rtnCode = 0;
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        String workORprotect = rParams[0].getParam("workORprotect") == null ? "workToNormal" : rParams[0].getParam("workORprotect").getValue();
        this.excLevelArray = new String[rParams.length];
        this.excDirectionArray = new String[rParams.length];
        this.excsrcPathNameArray = new String[rParams.length];
        this.excpsrcPathNameArray = new String[rParams.length];
        this.excsnkPathNameArray = new String[rParams.length];
        int len = rParams.length;
        for (int i = 0; i < len; ++i) {
            this.pctGroupID = Integer.parseInt(rParams[i].getParam("pctGroupID").getValue());
            this.excLevelArray[i] = rParams[i].getParam("excLevel").getValue();
            this.excDirectionArray[i] = rParams[i].getParam("direction").getValue();
            this.excsrcPathNameArray[i] = rParams[i].getParam("srcPathName").getValue();
            this.excsnkPathNameArray[i] = rParams[i].getParam("snkPathName").getValue();
            this.excpsrcPathNameArray[i] = rParams[i].getParam("psrcPathName").getValue();
            this.worksrcPathNameArray[i] = rParams[i].getParam("workSrcPath") != null ? rParams[i].getParam("workSrcPath").getValue() : "";
            this.worksnkPathNameArray[i] = rParams[i].getParam("workSnkPath") != null ? rParams[i].getParam("workSnkPath").getValue() : "";
            this.pctsrcPathNameArray[i] = rParams[i].getParam("pctSrcPath") != null ? rParams[i].getParam("pctSrcPath").getValue() : "";
            rtnCode = this.doConvert(neID, this.pctGroupID, workORprotect, subFunc);
            if (0 != rtnCode) break;
            ++this.convertSize;
        }
        Datainterface rtnDataface = new Datainterface();
        rtnDataface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)rtnCode));
        if (this.isNeedOperationlog()) {
            this.writeLog(neID, subFunc, inputData, user, ipAddress, rtnDataface);
        }
        return rtnDataface;
    }

    public int doConvert(int neID, int pctGroupID, String workORprotect, SubFunc subFunc) {
        ArrayList<Object> operList = new ArrayList<Object>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_OPS_SET_SNCPS_PROTONOR");
            Input input = oper.getInput();
            input.setPartValue("pctGroupID", String.valueOf(pctGroupID));
            if (workORprotect.equalsIgnoreCase("workToNormal")) {
                input.setPartValue("pctUnit", "2");
            } else {
                input.setPartValue("pctUnit", "1");
            }
            operList.add(oper.clone());
            OperationResult result = TECommuNEMgr.getInstance().sendCommand(neID, operList, 10, subFunc);
            if (result.retCode != 0) {
                return result.retCode;
            }
            Operation tmpOper = (Operation)operList.get(0);
            Output output = tmpOper.getOutput()[0];
            Fault fault = output.getFault()[0];
            int code2 = TENEListUtils.sendVerify((int)neID);
            if (code2 != 0) {
                return code2;
            }
            return Integer.parseInt(fault.getCode());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEWDMEXCConvertSNCPToNormalBean.doConvert() fail!", (Throwable)e);
            return 1090646019;
        }
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            int errorCode2 = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode2 == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo2 = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj2 = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj2 ? String.valueOf(neid) : neObj2.getNEName();
            if (errorCode2 == 0) {
                loginfo2 = new TELogInfo();
                loginfo2.setResult(0);
                loginfo2.setErrCode(0);
                loginfo2.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode2));
                loginfoList.add(loginfo2);
            } else if (errorCode2 == 2 || errorCode2 == 1) {
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    int size = rowErrors.length;
                    for (int j = 0; j < size; ++j) {
                        loginfo2 = new TELogInfo();
                        loginfo2.setResult(2);
                        loginfo2.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                        loginfo2.setErrInfo(rowErrors[j].getErrorMessage().getErrorinfo());
                        loginfoList.add(loginfo2);
                    }
                }
            } else {
                loginfo2 = new TELogInfo();
                loginfo2.setResult(2);
                loginfo2.setErrCode(errorCode2);
                loginfo2.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode2));
                loginfoList.add(loginfo2);
            }
            if (this.convertSize > 0) {
                for (int ik = 0; ik < this.convertSize; ++ik) {
                    int size = loginfoList.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        loginfo2 = (TELogInfo)loginfoList.get(i2);
                        loginfo2.setCmdID(subfunc.getCode());
                        loginfo2.setLocation(ipAddress);
                        loginfo2.setUserID(userID);
                        loginfo2.setUserName(TESysManagerBean.getInstance().getSysUser());
                        loginfo2.setOperateName(subfunc.getSubFuncDes(neid));
                        loginfo2.setOperateObject(operObj);
                        loginfo2.setOperateDesc(this.operationDescribtion(ik));
                        TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i2)));
                    }
                }
            } else {
                int size = loginfoList.size();
                for (i = 0; i < size; ++i) {
                    loginfo2 = (TELogInfo)loginfoList.get(i);
                    loginfo2.setCmdID(subfunc.getCode());
                    loginfo2.setLocation(ipAddress);
                    loginfo2.setUserID(userID);
                    loginfo2.setUserName(TESysManagerBean.getInstance().getSysUser());
                    loginfo2.setOperateName(subfunc.getSubFuncDes(neid));
                    loginfo2.setOperateObject(operObj);
                    loginfo2.setOperateDesc("");
                    TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String operationDescribtion(int index) {
        StringBuffer operDesc = new StringBuffer();
        StringBuffer filePath = new StringBuffer(100);
        filePath.append("wdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("exc").append(File.separator).append("wdmexcInfo_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neID, (StringBuffer)filePath);
        operDesc.append(res.getString("level")).append(':').append(this.excLevelArray[index]);
        operDesc.append(',');
        operDesc.append(res.getString("direction")).append(':').append(this.excDirectionArray[index]);
        operDesc.append(',');
        if (!this.worksrcPathNameArray[index].isEmpty()) {
            String wsrcPath = TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(Integer.parseInt(this.worksrcPathNameArray[index]));
            operDesc.append(res.getString("srcPath")).append(':').append(this.excsrcPathNameArray[index]);
            operDesc.append("-");
            operDesc.append(wsrcPath);
            operDesc.append(',');
        } else {
            operDesc.append(res.getString("srcPath")).append(':').append(this.excsrcPathNameArray[index]);
            operDesc.append(',');
        }
        if (!this.worksnkPathNameArray[index].isEmpty()) {
            String wsnkPath = TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(Integer.parseInt(this.worksnkPathNameArray[index]));
            operDesc.append(res.getString("psrcPath")).append(':').append(this.excpsrcPathNameArray[index]);
            operDesc.append("-");
            operDesc.append(wsnkPath);
            operDesc.append(',');
        } else {
            operDesc.append(res.getString("psrcPath")).append(':').append(this.excpsrcPathNameArray[index]);
            operDesc.append(',');
        }
        if (!this.pctsrcPathNameArray[index].isEmpty()) {
            String psrcPath = TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(Integer.parseInt(this.pctsrcPathNameArray[index]));
            operDesc.append(res.getString("snkPath")).append(':').append(this.excsnkPathNameArray[index]);
            operDesc.append("-");
            operDesc.append(psrcPath);
            operDesc.append(' ');
        } else {
            operDesc.append(res.getString("snkPath")).append(':').append(this.excsnkPathNameArray[index]);
            operDesc.append("-");
            operDesc.append(' ');
        }
        return operDesc.toString();
    }
}

