/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.wdm;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.gencfg.TEGenCfgCommon;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TEAlarm;
import com.huawei.nglct.nelist.TEAlarmData;
import com.huawei.nglct.nelist.TEAlarmKey;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEAlarmAnalyse;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeMgr;
import com.huawei.nglct.nelist.lpara.TEAlmReturnParamParse;
import com.huawei.nglct.nelist.model.AlmFBKeyType;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TEPfmUtility;
import com.huawei.nglct.nelist.model.TEPortIndex;
import com.huawei.nglct.nelist.model.alarm.TEParseAlarmParam;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.nemgr.necommon.fault.TEAlarmAdapterCache;
import com.huawei.nglct.nemgr.wdm.TENEImplInterface_WDM;
import com.huawei.nglct.nemgr.wdm.TENEInterImpl_WDM;
import com.huawei.nglct.nemgr.wdm.TENESingleImpl_WDM;
import com.huawei.nglct.nemgr.wdm.netimesyn.TENESynFileMgr;
import com.huawei.nglct.nemgr.wdm.netimesyn.TENESynTimeAutoTask;
import com.huawei.nglct.nemgr.wdm.netimesyn.TENESynTimeData;
import com.huawei.nglct.nemgr.wdm.netimesyn.TENESynTimeTaskInstance;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.login.QueryPortNameRunnable;
import com.huawei.nglct.util.login.TELoginNEManager;
import com.huawei.nglct.util.login.TEQueryLogicPortRunnable;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class TENE_WDM
extends TENE {
    private static final int FB_PANEL = 53;
    private static final int FB_OTHER = 30;
    private static final int BOARD_STANDBY = 1;
    private static final String STATUS_ACTIVE = "3";
    private static final int NO_PORT_FLAG = 255;

    public void setLastBoardModifyTime() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        neImplInterface.setLastBoardModifyTime(System.currentTimeMillis());
    }

    public boolean isCanUpdateBoardList() {
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            return true;
        }
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        return (double)Math.abs(System.currentTimeMillis() - neImplInterface.getLastBoardModifyTime()) > (double)neImplInterface.getBoardQueryPeriod() * 1.5;
    }

    public TENE_WDM() {
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            this.setNeImplInterface(new TENEInterImpl_WDM(this.neID));
            TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
            neImplInterface.setBoardQueryPeriod(300000);
            TEAlarmAdapterCache.getInstatce().initData(this.neID);
        } else {
            this.setNeImplInterface(new TENESingleImpl_WDM(this.neID));
        }
    }

    public synchronized Vector getClonedSubrackList() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        Vector subrackList = neImplInterface.getSubrackList();
        Vector<Object> clonedSubrackList = new Vector<Object>();
        for (int i = 0; i < subrackList.size(); ++i) {
            clonedSubrackList.add(((TESubrack)subrackList.get(i)).clone());
        }
        return clonedSubrackList;
    }

    public synchronized Vector getBackupSubrackList() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        return neImplInterface.getOldSubrackList();
    }

    public synchronized void setBackupSubrackList(Vector newSubrackList) {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        neImplInterface.setOldSubrackList(newSubrackList);
    }

    public synchronized Vector getSubrackList() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        return neImplInterface.getSubrackList();
    }

    public synchronized void setSubrackList(Vector newSubrackList) {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        neImplInterface.setSubrackList(newSubrackList);
    }

    public void afterLogoutNE() {
        TENEImplInterface_WDM neImpl = (TENEImplInterface_WDM)this.getNeImplInterface();
        Vector alarmList = neImpl.getAlarmList();
        if (alarmList != null && !alarmList.isEmpty()) {
            alarmList.clear();
        }
        TELoginNEManager.getInstance().removeNe((TENE)this);
        TENEAlarmAnalyse alarmAnalyse = neImpl.getAlarmAnalyse();
        alarmAnalyse.setExigenceAlmCount(0);
        alarmAnalyse.setPrimaryAlmCount(0);
        alarmAnalyse.setSecondaryAlmCount(0);
        alarmAnalyse.setPromptAlmCount(0);
        alarmAnalyse.setTopAlmLevel(-1);
        neImpl.setSchedule(false);
        TENESynTimeTaskInstance instance = TENESynTimeTaskInstance.getInstance();
        Timer task = instance.getTaskInstanceByNeId(this.neID);
        if (task != null) {
            task.cancel();
            instance.removeInstanceByNeId(this.neID);
        }
    }

    public void initNEData() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        neImplInterface.setObjTypeMgr(new TEAlmObjTypeMgr(this.neID));
        if (!neImplInterface.isSchedule()) {
            TELoginNEManager.getInstance().registerNe((TENE)this);
            TELogFactory.getNormalLogger().info("NEname: " + this.getNEName() + " start boardTimerTask ");
            neImplInterface.setSchedule(true);
        }
        this.queryBoard();
        TEAlarmAdapterCache.getInstatce().initData(this.neID);
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            this.queryAlarm();
        }
        try {
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                return;
            }
            final TENESynTimeData synTimeInfo = TENESynFileMgr.getNeSynTimeInfo(this.neID);
            if (synTimeInfo == null) {
                return;
            }
            if ("2".equals(synTimeInfo.getSynMode())) {
                Thread synTimeThread = new Thread(){

                    @Override
                    public void run() {
                        Timer timerTask = new Timer();
                        TENESynTimeAutoTask newTask = new TENESynTimeAutoTask(TENE_WDM.this.neID);
                        TENESynTimeTaskInstance.getInstance().addInstance(TENE_WDM.this.neID, timerTask);
                        long startTime = Long.parseLong(synTimeInfo.getSynStartDate());
                        long cycle = (Long.parseLong(synTimeInfo.getAutoSynCycle()) + 1L) * 24L * 3600L * 1000L;
                        long currTime = new GregorianCalendar().getTimeInMillis();
                        if (startTime < currTime) {
                            long times = (currTime - startTime) / cycle;
                            startTime += cycle * (times + 1L);
                        }
                        timerTask.scheduleAtFixedRate((TimerTask)newTask, new Date(startTime), cycle);
                    }
                };
                synTimeThread.start();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Start NE Time Synchronized Fail!", (Throwable)e);
        }
        TimeZoneDateBean timeDate = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neID);
        timeDate.setSucceed(false);
        timeDate.getNETimeZone();
    }

    private void queryLogicPort() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        Vector boardList = neImplInterface.getBoardList();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board1 = (TEBoard)boardList.get(i);
            int boardType = board1.getBoardType();
            if (!TEConfigurationDataMgr.getInstance().isDynPortBoardType(this.neID, boardType)) continue;
            int slotID = board1.getSlotID();
            TELoginNEManager.getInstance().getChanel().putRequest((Runnable)new TEQueryLogicPortRunnable(this.neID, slotID, boardType));
        }
    }

    private long convertIntVersion(String version) {
        String[] vers = version.split("\\.");
        if (vers.length < 4) {
            TENEImplInterface_WDM neImpl = (TENEImplInterface_WDM)this.getNeImplInterface();
            return neImpl.getSUPPORT_QUERY_SUBRACK_VER();
        }
        byte[] a = new byte[4];
        int len = vers.length;
        for (int i = 0; i < len; ++i) {
            a[i] = (byte)(Integer.parseInt(vers[i]) & 0xFF);
        }
        return IOStreamConvertor.readInt((byte[])a, (int)0);
    }

    public void queryBoard() {
        String value;
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        if (!this.isCanUpdateBoardList()) {
            return;
        }
        long neVersion = this.convertIntVersion(this.getHostVersion());
        if (neVersion >= neImplInterface.getSUPPORT_QUERY_SUBRACK_VER()) {
            TELogFactory.getNormalLogger().info(this.getNEName() + "is ready to get subrack, neVersion is " + neVersion);
            this.querySubrack();
        }
        boolean querySucc = false;
        Operation oper1 = null;
        Operation oper2 = null;
        Operation oper3 = null;
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            oper1 = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_BD");
            oper2 = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_PHY_BD");
            oper3 = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_NE_NAMEEX");
            operationList.add(oper1.clone());
            operationList.add(oper2.clone());
            operationList.add(oper3.clone());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENE_WDM.queryBoard() fail!", (Throwable)e);
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query board fail,the errorCode is " + result.retCode);
            return;
        }
        int slotID = -1;
        int boardType = -1;
        HashMap<String, TEBoard> queryboardMap = new HashMap<String, TEBoard>();
        ArrayList<TEBoard> tmpBoardList = new ArrayList<TEBoard>();
        for (Output output : ((Operation)operationList.get(0)).getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            querySucc = true;
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value2 = part.getValue();
                if (name.equals("slotID") && value2 != null) {
                    slotID = Integer.parseInt(value2);
                    continue;
                }
                if (name.equals("boardType") && value2 != null) {
                    boardType = Integer.parseInt(value2);
                    continue;
                }
                if (!name.equals("activatingFlag") || !STATUS_ACTIVE.equals(value2)) continue;
                TEBoard board = new TEBoard(this.neID, slotID, boardType);
                List unmodifiedCPList = TENEListUtils.getCPTypeList();
                if (!unmodifiedCPList.contains(boardType)) {
                    TELoginNEManager.getInstance().getChanel().putRequest((Runnable)new QueryPortNameRunnable(this.neID, slotID, boardType));
                }
                queryboardMap.put(String.valueOf(slotID), board);
                tmpBoardList.add(board);
            }
        }
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            List<Operation> operationListLoop = this.getQueryLoopbackOperList(tmpBoardList);
            if (!operationListLoop.isEmpty()) {
                OperationResult result1 = TENECommMgr.getInstance().sendCommand(this.neID, operationListLoop, 2);
                if (result1.retCode == 0) {
                    int len = operationListLoop.size();
                    for (int i = 0; i < len; ++i) {
                        Output[] outputArrLoop = operationListLoop.get(i).getOutput();
                        Input inputArrLoop = operationListLoop.get(i).getInput();
                        String inputSlotid = inputArrLoop.getPart(0).getValue();
                        boolean loopState = false;
                        int len1 = outputArrLoop.length;
                        for (int j = 0; j < len1 && !loopState; ++j) {
                            TEBoard tempBoard;
                            Output output = outputArrLoop[j];
                            if (!output.getFault()[0].getCode().equals("0") || !(value = output.getPart(output.getPartCount() - 1).getValue()).equals("1") && !value.equals("2") || (tempBoard = (TEBoard)queryboardMap.get(inputSlotid)) == null) continue;
                            tempBoard.setBoardLoop(1);
                            loopState = true;
                        }
                    }
                }
            }
            this.queryPortIndex();
        }
        if (querySucc) {
            Vector boardList = neImplInterface.getBoardList();
            if (queryboardMap.size() != boardList.size()) {
                this.setBoardUpdateFlag(true);
            } else {
                int i = 0;
                int len = boardList.size();
                for (i = 0; i < len; ++i) {
                    TEBoard board1 = (TEBoard)boardList.get(i);
                    if (queryboardMap.containsValue(board1)) continue;
                    this.setBoardUpdateFlag(true);
                    break;
                }
                if (i >= len) {
                    this.setBoardUpdateFlag(false);
                }
            }
            Vector<TEBoard> tmpBoardVec = new Vector<TEBoard>();
            Iterator iter = queryboardMap.values().iterator();
            while (iter.hasNext()) {
                tmpBoardVec.add((TEBoard)iter.next());
            }
            if (this.isCanUpdateBoardList()) {
                this.setBoardList(tmpBoardVec);
                Collections.sort(boardList);
            }
            this.queryLogicPort();
        }
        queryboardMap.clear();
        Vector<TEBoard> newPhyBoardList = new Vector<TEBoard>();
        for (Output output : ((Operation)operationList.get(1)).getOutput()) {
            String tempValue;
            if (!output.getFault()[0].getCode().equals("0") || null == (tempValue = output.getPart(1).getValue()) || tempValue.equals("0")) continue;
            for (Part part : output.getPart()) {
                String name = part.getName();
                value = part.getValue();
                if (name.equals("slotID") && value != null) {
                    slotID = Integer.parseInt(value);
                    continue;
                }
                if (!name.equals("boardType") || value == null) continue;
                boardType = Integer.parseInt(value);
            }
            TEBoard board = new TEBoard(this.neID, slotID, boardType);
            newPhyBoardList.add(board);
        }
        this.setPhyBoardList(newPhyBoardList);
        Operation tempOperation = (Operation)operationList.get(2);
        TEDataConverter.handleSpecialStr((Operation)tempOperation);
        Output[] outputArr3 = tempOperation.getOutput();
        Output output = outputArr3[0];
        if (output.getFault()[0].getCode().equals("0")) {
            for (Part part : output.getPart()) {
                String value3 = part.getValue().trim();
                if (!"".equals(value3)) {
                    value3 = TEStringUtils.removeInvalidXMLChar((String)value3);
                }
                if (!neImplInterface.getNeName().equals("neName") || value3 == null || neImplInterface.getNeName().equals(value3)) continue;
                neImplInterface.setNeName(value3.trim());
                this.setBoardUpdateFlag(true);
            }
        }
    }

    private List<Operation> getQueryLoopbackOperList(ArrayList tmpBoardList) {
        int i;
        ArrayList<Operation> operationListLoop = new ArrayList<Operation>();
        Operation operLoop = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_LOOP_WDM");
        Operation operPathLoop = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_LOOPMODE_WDM");
        List supportBoardList = TEGenCfgCommon.getAttrSupportCPs((int)this.neID, (String)"W32PORT_ATTR_LOOPBACK", (List)tmpBoardList);
        int len = supportBoardList.size();
        for (i = 0; i < len; ++i) {
            operLoop.getInput().getPart(0).setValue(((TEBoard)supportBoardList.get(i)).getSlotID() + "");
            operationListLoop.add((Operation)operLoop.clone());
        }
        supportBoardList.clear();
        if (null != operPathLoop) {
            supportBoardList = TEGenCfgDataMgr.getAttrSupportCPs((int)this.neID, (String)"W32PORT_ATTR_PATHLOOPBACK", (ArrayList)tmpBoardList);
            len = supportBoardList.size();
            for (i = 0; i < len; ++i) {
                operPathLoop.getInput().getPart(0).setValue(((TEBoard)supportBoardList.get(i)).getSlotID() + "");
                ArrayList portList = TEGenCfgDataMgr.getGenCfgMode((int)((TEBoard)supportBoardList.get(i)).getBoardType()).getAttrFromId("W32PORT_ATTR_PATHLOOPBACK").getPortList();
                if (null == portList || portList.isEmpty()) {
                    operPathLoop.getInput().getPart(2).setValue("1");
                    operationListLoop.add((Operation)operPathLoop.clone());
                    continue;
                }
                int portLen = portList.size();
                for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                    operPathLoop.getInput().getPart(2).setValue(((TEGenCfgPortAttribute)portList.get(portIndex)).getPort() + "");
                    operPathLoop.getInput().getPart(3).setValue("1");
                    operationListLoop.add((Operation)operPathLoop.clone());
                }
            }
            supportBoardList.clear();
        }
        operationListLoop.addAll(this.getQueryVC4LoopbackList(tmpBoardList));
        operationListLoop.addAll(this.getQueryOpticalLoopbackList(tmpBoardList));
        return operationListLoop;
    }

    private List<Operation> getQueryVC4LoopbackList(ArrayList tmpBoardList) {
        Operation operVC4PathLoop = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_PATH_LOOP");
        ArrayList<Operation> operationListLoop = new ArrayList<Operation>();
        ArrayList supportBoardList = TEGenCfgDataMgr.getAttrSupportCPs((int)this.neID, (String)"SDHVC4_ATTR_LOOPBACK", (ArrayList)tmpBoardList);
        if (operVC4PathLoop != null && !supportBoardList.isEmpty()) {
            int len = supportBoardList.size();
            for (int i = 0; i < len; ++i) {
                operVC4PathLoop.getInput().getPart(0).setValue(((TEBoard)supportBoardList.get(i)).getSlotID() + "");
                ArrayList portList = TEGenCfgDataMgr.getGenCfgMode((int)((TEBoard)supportBoardList.get(i)).getBoardType()).getAttrFromId("SDHVC4_ATTR_LOOPBACK").getPortList();
                if (null == portList || portList.isEmpty()) {
                    operVC4PathLoop.getInput().getPart(2).setValue("1");
                    operationListLoop.add((Operation)operVC4PathLoop.clone());
                    continue;
                }
                int portLen = portList.size();
                for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                    operVC4PathLoop.getInput().getPart(2).setValue(((TEGenCfgPortAttribute)portList.get(portIndex)).getPort() + "");
                    operationListLoop.add((Operation)operVC4PathLoop.clone());
                }
            }
        }
        supportBoardList.clear();
        return operationListLoop;
    }

    private List<Operation> getQueryOpticalLoopbackList(ArrayList tmpBoardList) {
        ArrayList<Operation> operationListLoop = new ArrayList<Operation>();
        ArrayList supportBoardList = TEGenCfgDataMgr.getAttrSupportCPs((int)this.neID, (String)"SDHVC4_ATTR_OPTICALLOOPBACK", (ArrayList)tmpBoardList);
        Operation queryOpticLoop = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_OPTICALLOOP");
        TEBoard board = null;
        Operation opticLoop = null;
        if (queryOpticLoop != null) {
            int len = supportBoardList.size();
            for (int i = 0; i < len; ++i) {
                opticLoop = (Operation)queryOpticLoop.clone();
                board = (TEBoard)supportBoardList.get(i);
                ArrayList portList = TEGenCfgDataMgr.getAttrSupportCPPorts((int)this.neID, (String)"SDHVC4_ATTR_OPTICALLOOPBACK", (int)board.getBoardType());
                int portLen = portList.size();
                for (int j = 0; j < portLen; ++j) {
                    opticLoop.getInput().getPart(0).setValue(String.valueOf(board.getSlotID()));
                    opticLoop.getInput().getPart(1).setValue(String.valueOf(portList.get(j)));
                    operationListLoop.add((Operation)opticLoop.clone());
                }
            }
        }
        return operationListLoop;
    }

    public void querySubrack() {
        TENE teNE = TENEListUtils.getNEObj((int)this.neID);
        if (teNE.getNEType() == Integer.parseInt("67") && teNE.getShelfType() == Integer.parseInt("153")) {
            Vector<TESubrack> newSubrackList = new Vector<TESubrack>();
            TESubrack tempSubrack = new TESubrack("0", "153", "");
            tempSubrack.setPhySubrackType("153");
            tempSubrack.setSubrackState("1");
            newSubrackList.add(tempSubrack);
            this.setSubrackList(newSubrackList);
            return;
        }
        ArrayList<Operation> operList = new ArrayList<Operation>();
        try {
            Operation queryOper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_SHELF");
            Operation queryStateOper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_PHYSHELF");
            operList.add(queryOper);
            operList.add(queryStateOper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENE_WDM.querySubrack() fail!", (Throwable)e);
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operList, 10);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().error("Query subrack fail, the errorCode is" + result.retCode);
            return;
        }
        HashMap<String, TESubrack> tempMap = new HashMap<String, TESubrack>();
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            Output[] outputArr = ((Operation)operList.get(i)).getOutput();
            for (int j = 0; j < outputArr.length; ++j) {
                String subrackID;
                Output output = outputArr[j];
                if (!"0".equals(output.getFault()[0].getCode())) continue;
                if (((Operation)operList.get(i)).getName().equals("NSCMD_CFG_GET_SHELF")) {
                    subrackID = output.getPartValue("subrackID");
                    String shelfMemo = this.queryShelfMemo(subrackID);
                    String subrackType = output.getPartValue("subrackType");
                    TESubrack tempSubrack = new TESubrack(subrackID, subrackType, shelfMemo);
                    tempMap.put(subrackID, tempSubrack);
                    continue;
                }
                if (!((Operation)operList.get(i)).getName().equals("NSCMD_CFG_GET_PHYSHELF")) continue;
                subrackID = output.getPartValue("subrackID");
                String phySubrackType = output.getPartValue("subrackType");
                TESubrack tempSubrack = (TESubrack)tempMap.get(subrackID);
                if (tempSubrack == null) continue;
                tempSubrack.setPhySubrackType(phySubrackType);
                if (!tempSubrack.getLogicSubrackType().equals(phySubrackType)) continue;
                tempSubrack.setSubrackState("1");
            }
        }
        Vector tempVec = new Vector();
        Iterator iter = tempMap.values().iterator();
        while (iter.hasNext()) {
            tempVec.add(iter.next());
        }
        Collections.sort(tempVec);
        this.setSubrackList(tempVec);
    }

    public String queryShelfMemo(String shelfID) {
        String shelfMemo = "";
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_SHELF_MEMO");
            if (oper == null) {
                return "";
            }
            oper.getInput().getPart("subrackID").setValue(shelfID);
            operationList.add(oper);
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
            if (result.retCode != 0) {
                return "";
            }
            Operation operation = (Operation)operationList.get(0);
            if (operation.getOutputCount() > 0 && operation.getOutput(0).getFault(0).getCode().equals("0") && !"".equals(shelfMemo = operation.getOutput(0).getPartValue("memo").trim())) {
                shelfMemo = TEStringUtils.removeInvalidXMLChar((String)shelfMemo);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENE_WDM.queryShelfMemo() fail!", (Throwable)e);
        }
        return shelfMemo;
    }

    private void setOperationInput(Operation oper) {
        Input input = oper.getInput();
        for (Part part : input.getPart()) {
            if (part.getName().equals("slotID")) {
                part.setValue(Integer.valueOf(0).toString());
                continue;
            }
            if (part.getName().equals("eventTag")) {
                part.setValue(Integer.valueOf(0).toString());
                continue;
            }
            if (!part.getName().equals("objType")) continue;
            part.setValue(Integer.valueOf(0).toString());
        }
        oper.setInput((Input)input.clone());
    }

    public void queryAlarm() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        Vector alarmList = neImplInterface.getAlarmList();
        if (alarmList != null && !alarmList.isEmpty()) {
            alarmList.clear();
        }
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"GetCurAlarm");
            if (null != oper) {
                this.setOperationInput(oper);
                operationList.add(oper.clone());
            }
            if (null != (oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ALM_GET_CUR_NEW"))) {
                this.setOperationInput(oper);
                operationList.add(oper.clone());
            }
            if (null != (oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ALM_GET_CURDATA_EXT_WEX"))) {
                this.setOperationInput(oper);
                operationList.add(oper.clone());
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENE_WDM.queryAlarm() fail!", (Throwable)e);
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        if (result.retCode != 0) {
            return;
        }
        int evtSerialNum = -1;
        int eqType = 1;
        int alarmID = -1;
        String alarmName = "";
        int alarmType = -1;
        int alarmLevel = -1;
        int shelf = this.neID;
        int slotID = -1;
        int bdType = -1;
        String bdName = "";
        int port = 0;
        String portName = "";
        int path = 0;
        int fucBlock = 30;
        String fbName = "";
        Calendar startTime = null;
        String almDetail = "";
        String almEventParamStr = "";
        String almReasion = "";
        int eventStatus = -1;
        TEAlarmData almData = null;
        TEAlarmKey alarmKey = null;
        TEPfmMonObjID monObjTmp = null;
        TEAlmObjTypeData almObjTypeObj = null;
        int paraLen = 0;
        int appendLen = 0;
        String objTypeTmp = "";
        boolean isLongParam = false;
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation operation = (Operation)operationList.get(i);
            Output[] outputArr = operation.getOutput();
            int len = outputArr.length;
            for (int j = 0; j < len; ++j) {
                TEBoard board;
                fucBlock = 30;
                monObjTmp = null;
                slotID = -1;
                port = 0;
                path = 0;
                Output output = outputArr[j];
                if (!output.getFault()[0].getCode().equals("0")) continue;
                Part[] partArr = output.getPart();
                int[] almEventParam = new int[5];
                int len2 = partArr.length;
                for (int k = 0; k < len2; ++k) {
                    Part part = partArr[k];
                    String name = part.getName();
                    String value = part.getValue();
                    if (name.equals("evtSerialNum") && value != null) {
                        evtSerialNum = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("slotID") && value != null) {
                        slotID = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("portID") && value != null) {
                        port = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventTag") && value != null) {
                        alarmID = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventLevel") && value != null) {
                        alarmLevel = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventStatus") && value != null) {
                        eventStatus = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("startTime") && value != null) {
                        startTime = TEDateUtils.byteStrToCalendar((String)value);
                        continue;
                    }
                    if (name.equals("eventParam1") && value != null) {
                        almEventParam[0] = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventParam2") && value != null) {
                        almEventParam[1] = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventParam3") && value != null) {
                        almEventParam[2] = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventParam4") && value != null) {
                        almEventParam[3] = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventParam5") && value != null) {
                        almEventParam[4] = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("obligate") && value != null && !value.equals("FF")) {
                        byte[] bValue = value.getBytes();
                        byte[] tmp = new byte[2];
                        if (bValue.length < 2 * almEventParam.length) continue;
                        int n = almEventParam.length;
                        for (int m = 0; m < n; ++m) {
                            System.arraycopy(bValue, 2 * m, tmp, 0, 2);
                            almEventParam[m] = IOStreamConvertor.readPositiveShort((byte[])tmp, (int)0);
                        }
                        continue;
                    }
                    if (name.equals("paraLen") && value != null) {
                        paraLen = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("appendLen") && value != null) {
                        appendLen = Integer.parseInt(value);
                        continue;
                    }
                    if (TEPfmUtility.validatePart((Part)partArr[k], (String)"objtype")) {
                        objTypeTmp = partArr[k].getValue();
                        almObjTypeObj = neImplInterface.getObjTypeMgr().getAlmObjTypeData(Integer.parseInt(objTypeTmp));
                        continue;
                    }
                    if (!name.equals("textPara") || value == null) continue;
                    if (operation.getName().equals("NSCMD_ALM_GET_CURDATA_EXT_WEX")) {
                        isLongParam = true;
                        almEventParam = new int[appendLen];
                        if (appendLen > 0) {
                            String paraValue = value.substring(paraLen * 2, value.length());
                            byte[] objByte = paraValue.getBytes();
                            for (int n = 0; n < appendLen; ++n) {
                                byte[] temp = new byte[2];
                                System.arraycopy(objByte, 2 * n, temp, 0, 2);
                                almEventParam[n] = IOStreamConvertor.readPositiveShort((byte[])temp, (int)0);
                            }
                        }
                        if (objTypeTmp.equals("20")) {
                            monObjTmp = new TEPfmMonObjID();
                            slotID = monObjTmp.getSlotID();
                            continue;
                        }
                        byte[] objByte = partArr[k].getValue().getBytes();
                        if (almObjTypeObj == null) continue;
                        monObjTmp = TEAlmReturnParamParse.getInstance().parseObjParam(objByte, almObjTypeObj);
                        slotID = monObjTmp.getSlotID();
                        continue;
                    }
                    almEventParamStr = TEParseAlarmParam.getAlarmParamValue((int)alarmID, (String)value);
                }
                if (objTypeTmp.equals("20")) {
                    slotID = this.getSCCSlot();
                    fucBlock = 30;
                }
                if ((board = this.getBoard(slotID)) != null) {
                    bdType = board.getBoardType();
                } else {
                    if (!objTypeTmp.equals("20")) continue;
                    bdType = -1;
                }
                if (operation.getName().equals("GetCurAlarm")) {
                    port = almEventParam[0];
                    path = almEventParam[1] * 256 + almEventParam[2];
                } else if (operation.getName().equals("NSCMD_ALM_GET_CURDATA_EXT_WEX")) {
                    if (monObjTmp != null) {
                        port = monObjTmp.getPortID();
                        path = monObjTmp.getPathID();
                    } else {
                        TELogFactory.getNormalLogger().error("Query WDM Alarm!monObj = null;alarmID=" + alarmID);
                        continue;
                    }
                }
                AlmFBKeyType key = new AlmFBKeyType(alarmID, bdType, port, path);
                fucBlock = TEAlarmAdapterCache.getInstatce().getAlarmFbType(this.neID, slotID, key, almObjTypeObj);
                if (String.valueOf("20").equals(objTypeTmp)) {
                    port = -1;
                    path = -1;
                    portName = "";
                    fucBlock = 30;
                } else if (fucBlock == 53 || fucBlock == 30 || fucBlock == -1) {
                    port = 0;
                    path = 0;
                    portName = "";
                } else if (port == 255) {
                    port = 0;
                    path = 0;
                    portName = "";
                    fucBlock = 30;
                }
                alarmKey = new TEAlarmKey(eqType, alarmID);
                almData = (TEAlarmData)neImplInterface.getAlmDataMap().get(alarmKey);
                if (null == almData) {
                    alarmName = "Unknown ID:" + alarmID;
                    alarmType = 3;
                    almDetail = " ";
                    almReasion = " ";
                } else {
                    alarmName = almData.getAeName();
                    alarmType = almData.getAeType();
                    almDetail = almData.getAeDetailName();
                    almReasion = almData.getAeReasion();
                }
                fbName = TEFuncBlockDescription.getInstance().getFBTypeName(fucBlock);
                TEAlarm alarm = new TEAlarm(evtSerialNum, eqType, alarmID, alarmName, alarmType, alarmLevel, shelf, slotID, bdType, bdName, port, portName, path, fucBlock, fbName, eventStatus, startTime, almDetail, almReasion, almEventParam);
                alarm.setIsLongParam(isLongParam);
                if (alarm.getEvtSerialNum() == -1) continue;
                TEAlarm tmpAlm = null;
                int size2 = alarmList.size();
                for (int n = 0; n < size2; ++n) {
                    tmpAlm = (TEAlarm)alarmList.get(n);
                    if (tmpAlm.getEvtSerialNum() != alarm.getEvtSerialNum()) continue;
                    return;
                }
                TEAlarm.parseAlarmParam((TEAlarm)alarm, (int)this.neID);
                if (operation.getName().equals("NSCMD_ALM_GET_CUR_NEW")) {
                    alarm.setAlmEventParamStr(almEventParamStr);
                }
                alarmList.add(alarm);
            }
        }
    }

    public void queryPortIndex() {
        TEConfigurationDataMgr.getInstance().removePortIndex(this.neID);
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ION_LIM_GET_TE_BOARDPORT");
            if (null == oper) {
                return;
            }
            operationList.add(oper);
            oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ION_NBASE_GET_NODE_ID");
            operationList.add(oper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENE_WDM.queryPortIndex() fail!", (Throwable)e);
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        if (result.retCode != 0) {
            return;
        }
        Operation operation = (Operation)operationList.get(0);
        for (Output output : operation.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            long index = Long.parseLong(output.getPartValue("index"));
            int slotid = Integer.parseInt(output.getPartValue("slotid"));
            int portid = Integer.parseInt(output.getPartValue("port"));
            int signalType = Integer.parseInt(output.getPartValue("signaltype"));
            int linkLevel = Integer.parseInt(output.getPartValue("linklevel"));
            TEPortIndex portIndex = new TEPortIndex(index, slotid, portid, signalType, linkLevel);
            TEConfigurationDataMgr.getInstance().addPortIndex(this.neID, index, portIndex);
        }
        operation = (Operation)operationList.get(1);
        Output output = operation.getOutput(0);
        if (output.getFault(0).getCode().equals("0")) {
            this.getNeImplInterface().setNodeID(output.getPartValue("nodeID"));
        }
    }

    public TENEAlarmAnalyse alarmAnalyse(int slotID) {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        Vector alarmList = neImplInterface.getAlarmList();
        TENEAlarmAnalyse almAnalyse = null;
        if (slotID == -1) {
            almAnalyse = this.almAnalyse(alarmList);
        } else {
            Vector<TEAlarm> slotAlmList = new Vector<TEAlarm>();
            int size = alarmList.size();
            for (int i = 0; i < size; ++i) {
                TEAlarm alarm = (TEAlarm)alarmList.get(i);
                if (alarm.getSlotID() != slotID) continue;
                slotAlmList.add(alarm);
            }
            almAnalyse = this.almAnalyse(slotAlmList);
        }
        return almAnalyse;
    }

    private TENEAlarmAnalyse alarmAnalyseOnSubrack(int subrack) {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        Vector alarmList = neImplInterface.getAlarmList();
        TENEAlarmAnalyse almAnalyse = null;
        Vector<TEAlarm> subrackAlmList = new Vector<TEAlarm>();
        int size = alarmList.size();
        for (int i = 0; i < size; ++i) {
            TEAlarm alarm = (TEAlarm)alarmList.get(i);
            int subrackId = TEBoardUtil.getSubrackIDFromSlot((int)this.neID, (int)alarm.getSlotID());
            if (subrackId != subrack) continue;
            subrackAlmList.add(alarm);
        }
        almAnalyse = this.almAnalyse(subrackAlmList);
        return almAnalyse;
    }

    public TENEAlarmAnalyse almAnalyse(Vector alarmList) {
        TENEAlarmAnalyse almAnalyse = new TENEAlarmAnalyse();
        int exigenceAlmCount = 0;
        int primaryAlmCount = 0;
        int secondaryAlmCount = 0;
        int promptAlmCount = 0;
        int topAlmLevel = -1;
        int size = alarmList.size();
        block6: for (int i = 0; i < size; ++i) {
            TEAlarm tempAlm = (TEAlarm)alarmList.get(i);
            switch (tempAlm.getAlarmLevel()) {
                case 1: {
                    ++exigenceAlmCount;
                    continue block6;
                }
                case 2: {
                    ++primaryAlmCount;
                    continue block6;
                }
                case 3: {
                    ++secondaryAlmCount;
                    continue block6;
                }
                case 4: {
                    ++promptAlmCount;
                    continue block6;
                }
                default: {
                    TELogFactory.getNormalLogger().info("TENE_WDM.almAnalyse() alarm level:" + tempAlm.getAlarmLevel() + " not in case!");
                }
            }
        }
        topAlmLevel = exigenceAlmCount != 0 ? 1 : (primaryAlmCount != 0 ? 2 : (secondaryAlmCount != 0 ? 3 : (promptAlmCount != 0 ? 4 : 0)));
        almAnalyse.setExigenceAlmCount(exigenceAlmCount);
        almAnalyse.setPrimaryAlmCount(primaryAlmCount);
        almAnalyse.setSecondaryAlmCount(secondaryAlmCount);
        almAnalyse.setPromptAlmCount(promptAlmCount);
        almAnalyse.setTopAlmLevel(topAlmLevel);
        return almAnalyse;
    }

    public Vector getHistoryAlarmList() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        return neImplInterface.getHistoryAlarmList();
    }

    public void queryHistoryAlarm() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        Vector historyAlarmList = neImplInterface.getHistoryAlarmList();
        if (historyAlarmList != null && !historyAlarmList.isEmpty()) {
            historyAlarmList.clear();
        }
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ALM_GET_HIS");
            if (null != oper) {
                this.setOperationInput(oper);
                operationList.add(oper.clone());
            }
            if (null != (oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ALM_GET_HISDATA_EXT"))) {
                this.setOperationInput(oper);
                operationList.add(oper.clone());
            }
            if (null != (oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ALM_GET_HISDATA_EXT_WEX"))) {
                this.setOperationInput(oper);
                operationList.add(oper.clone());
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENE_WDM.queryHistoryAlarm() fail!", (Throwable)e);
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        if (result.retCode != 0) {
            return;
        }
        int evtSerialNum = -1;
        int eqType = 1;
        int alarmID = -1;
        String alarmName = "";
        int alarmType = -1;
        int alarmLevel = -1;
        int shelf = this.neID;
        int slotID = -1;
        int bdType = -1;
        String bdName = "";
        int port = 0;
        String portName = "";
        int path = 0;
        int fucBlock = 30;
        String fbName = "";
        Calendar startTime = null;
        Calendar endTime = null;
        String almDetail = "";
        String almEventParamStr = "";
        String almReasion = "";
        int eventStatus = -1;
        TEAlarmData almData = null;
        TEAlarmKey alarmKey = null;
        int paraLen = 0;
        int appendLen = 0;
        String objType = "";
        TEPfmMonObjID monObj = null;
        TEAlmObjTypeData almObjTypeObj = null;
        boolean isLongParam = false;
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation operation = (Operation)operationList.get(i);
            for (Output output : operation.getOutput()) {
                TEBoard board;
                if (!output.getFault()[0].getCode().equals("0")) continue;
                fucBlock = 30;
                monObj = null;
                slotID = -1;
                port = 0;
                path = 0;
                eqType = 1;
                shelf = this.neID;
                bdType = -1;
                bdName = "";
                portName = "";
                Part[] partArr = output.getPart();
                int[] almEventParam = new int[5];
                int len2 = partArr.length;
                for (int k = 0; k < len2; ++k) {
                    Part part = partArr[k];
                    String name = part.getName();
                    String value = part.getValue();
                    if (name.equals("evtSerialNum") && value != null) {
                        evtSerialNum = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("slotID") && value != null) {
                        slotID = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("portID") && value != null) {
                        port = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventTag") && value != null) {
                        alarmID = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventLevel") && value != null) {
                        alarmLevel = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventStatus") && value != null) {
                        eventStatus = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("startTime") && value != null) {
                        startTime = TEDateUtils.byteStrToCalendar((String)value);
                        continue;
                    }
                    if (name.equals("endTime") && value != null) {
                        endTime = TEDateUtils.byteStrToCalendar((String)value);
                        continue;
                    }
                    if (name.equals("eventParam1") && value != null) {
                        almEventParam[0] = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventParam2") && value != null) {
                        almEventParam[1] = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventParam3") && value != null) {
                        almEventParam[2] = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventParam4") && value != null) {
                        almEventParam[3] = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("eventParam5") && value != null) {
                        almEventParam[4] = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("obligate") && value != null && !value.equals("FF")) {
                        byte[] bValue = value.getBytes();
                        byte[] tmp = new byte[2];
                        int n = almEventParam.length;
                        for (int m = 0; m < n && 2 * m < bValue.length; ++m) {
                            System.arraycopy(bValue, 2 * m, tmp, 0, 2);
                            almEventParam[m] = IOStreamConvertor.readPositiveShort((byte[])tmp, (int)0);
                        }
                        continue;
                    }
                    if (name.equals("paraLen") && value != null) {
                        paraLen = Integer.parseInt(value);
                        continue;
                    }
                    if (name.equals("appendLen") && value != null) {
                        appendLen = Integer.parseInt(value);
                        continue;
                    }
                    if (TEPfmUtility.validatePart((Part)partArr[k], (String)"objtype")) {
                        String macroObjType = partArr[k].getValue();
                        almObjTypeObj = neImplInterface.getObjTypeMgr().getAlmObjTypeData(Integer.parseInt(macroObjType));
                        continue;
                    }
                    if (!name.equals("textPara") || value == null) continue;
                    if (operation.getName().equals("NSCMD_ALM_GET_HISDATA_EXT_WEX")) {
                        isLongParam = true;
                        almEventParam = new int[appendLen];
                        if (appendLen > 0) {
                            String paraValue = value.substring(paraLen * 2, value.length());
                            byte[] objByte = paraValue.getBytes();
                            for (int n = 0; n < appendLen; ++n) {
                                byte[] temp = new byte[2];
                                System.arraycopy(objByte, 2 * n, temp, 0, 2);
                                almEventParam[n] = IOStreamConvertor.readPositiveShort((byte[])temp, (int)0);
                            }
                        }
                        if (objType.equals("20")) {
                            monObj = new TEPfmMonObjID();
                            slotID = monObj.getSlotID();
                            continue;
                        }
                        byte[] objByte = partArr[k].getValue().getBytes();
                        if (almObjTypeObj == null) continue;
                        monObj = TEAlmReturnParamParse.getInstance().parseObjParam(objByte, almObjTypeObj);
                        slotID = monObj.getSlotID();
                        continue;
                    }
                    almEventParamStr = TEParseAlarmParam.getAlarmParamValue((int)alarmID, (String)value);
                }
                if (monObj == null) {
                    TELogFactory.getNormalLogger().error("Query WDM History Alarm!monObj = null;alarmID=" + alarmID);
                    continue;
                }
                slotID = monObj.m_usSlotID;
                port = monObj.m_usPortID;
                path = monObj.m_usPathID;
                if (operation.getName().equals("NSCMD_ALM_GET_HISDATA_EXT_WEX") && objType.equals("20")) {
                    slotID = this.getSCCSlot();
                    fucBlock = 30;
                }
                if ((board = this.getBoard(slotID)) == null) continue;
                bdType = board.getBoardType();
                if (operation.getName().equals("NSCMD_ALM_GET_HIS")) {
                    port = almEventParam[0];
                    path = almEventParam[1] * 256 + almEventParam[2];
                } else if (operation.getName().equals("NSCMD_ALM_GET_HISDATA_EXT_WEX")) {
                    port = monObj.getPortID();
                    path = monObj.getPathID();
                }
                AlmFBKeyType key = new AlmFBKeyType(alarmID, bdType, port, path);
                fucBlock = TEAlarmAdapterCache.getInstatce().getAlarmFbType(this.neID, slotID, key, almObjTypeObj);
                if (String.valueOf("20").equals(objType)) {
                    port = -1;
                    path = -1;
                    portName = "";
                    fucBlock = 30;
                } else if (fucBlock == 53 || fucBlock == 30 || fucBlock == -1) {
                    port = 0;
                    path = 0;
                    portName = "";
                } else if (port == 255) {
                    port = 0;
                    path = 0;
                    portName = "";
                    fucBlock = 30;
                }
                alarmKey = new TEAlarmKey(eqType, alarmID);
                almData = (TEAlarmData)neImplInterface.getAlmDataMap().get(alarmKey);
                if (null == almData) {
                    alarmName = "Unknown ID:" + alarmID;
                    alarmType = 3;
                    almDetail = " ";
                    almReasion = " ";
                } else {
                    alarmName = almData.getAeName();
                    alarmType = almData.getAeType();
                    almDetail = almData.getAeDetailName();
                    almReasion = almData.getAeReasion();
                }
                fbName = TEFuncBlockDescription.getInstance().getFBTypeName(fucBlock);
                TEAlarm alarm = new TEAlarm(evtSerialNum, eqType, alarmID, alarmName, alarmType, alarmLevel, shelf, slotID, bdType, bdName, port, portName, path, fucBlock, fbName, eventStatus, startTime, endTime, almDetail, almReasion, almEventParam);
                alarm.setIsLongParam(isLongParam);
                if (alarm.getEvtSerialNum() == -1) continue;
                TEAlarm tmpAlm = null;
                int size2 = historyAlarmList.size();
                for (int n = 0; n < size2; ++n) {
                    tmpAlm = (TEAlarm)historyAlarmList.get(n);
                    if (tmpAlm.getEvtSerialNum() != alarm.getEvtSerialNum()) continue;
                    return;
                }
                TEAlarm.parseAlarmParam((TEAlarm)alarm, (int)this.neID);
                if (operation.getName().equals("NSCMD_ALM_GET_HISDATA_EXT")) {
                    alarm.setAlmEventParamStr(almEventParamStr);
                }
                historyAlarmList.add(alarm);
            }
        }
    }

    public Vector getAlarmList() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        return neImplInterface.getAlarmList();
    }

    public synchronized Vector getBoardList() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        return neImplInterface.getBoardList();
    }

    public synchronized Vector getPhyBoardList() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        return neImplInterface.getPhyBoardList();
    }

    public synchronized Vector getClonedBoardList() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        Vector boardList = neImplInterface.getBoardList();
        Vector<Object> clonedBoardList = new Vector<Object>();
        for (int i = 0; i < boardList.size(); ++i) {
            clonedBoardList.add(((TEBoard)boardList.get(i)).clone());
        }
        return clonedBoardList;
    }

    public synchronized void setBoardList(Vector newBoardList) {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        neImplInterface.setBoardList(newBoardList);
    }

    public synchronized Vector getClonedPhyBoardList() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        Vector phyBoardList = neImplInterface.getPhyBoardList();
        Vector<Object> clonedBoardList = new Vector<Object>();
        for (int i = 0; i < phyBoardList.size(); ++i) {
            clonedBoardList.add(((TEBoard)phyBoardList.get(i)).clone());
        }
        return clonedBoardList;
    }

    public synchronized void setPhyBoardList(Vector newBoardList) {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        neImplInterface.setPhyBoardList(newBoardList);
    }

    public void setCurTopLevelAlm(int almLevel) {
        if (this.getNeImplInterface().getAlarmAnalyse() != null) {
            this.getNeImplInterface().getAlarmAnalyse().setTopAlmLevel(almLevel);
        }
    }

    public int getCurTopLevelAlm(int slotID) {
        if (this.getNeImplInterface().getLogStatus() == 1) {
            this.getNeImplInterface().setAlarmAnalyse(this.alarmAnalyse(slotID));
            return this.getNeImplInterface().getAlarmAnalyse().getTopAlmLevel();
        }
        return -1;
    }

    public TENEAlarmAnalyse getCurTopLevelAlmOnSubrack(int subrackID) {
        return this.alarmAnalyseOnSubrack(subrackID);
    }

    public int[] deleteAlm(int[] evtSerialNums) {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        Vector alarmList = neImplInterface.getAlarmList();
        TELogFactory.getInterfaceLogger().info("delete alarm! neid=" + this.neID + "evtSerialNum=" + TEStringUtils.intsToString((int[])evtSerialNums));
        int[] retCode = new int[evtSerialNums.length + 1];
        retCode[0] = 0;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            for (int i = evtSerialNums.length - 1; i >= 0; --i) {
                Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ALM_DEL_CUR_EVENT");
                Input input = oper.getInput();
                for (Part part : input.getPart()) {
                    if (!part.getName().equals("evtSerialNum")) continue;
                    part.setValue(Integer.valueOf(evtSerialNums[i]).toString());
                    retCode[i + 1] = 0;
                    break;
                }
                operationList.add(oper);
            }
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
            if (result.retCode != 0 && result.retCode != 38152) {
                retCode[0] = 2;
                return retCode;
            }
            int size = operationList.size();
            for (int i = 0; i < size; ++i) {
                Operation operation = (Operation)operationList.get(i);
                Output[] outputArr = operation.getOutput();
                Input input = operation.getInput();
                int evtSerialNum = Integer.parseInt(input.getPart("evtSerialNum").getValue());
                for (Output output : outputArr) {
                    block6: for (Fault fault : output.getFault()) {
                        retCode[i + 1] = Integer.parseInt(fault.getCode());
                        if (retCode[i + 1] != 0 && retCode[i + 1] != 38152 || alarmList == null) continue;
                        if (retCode[i + 1] == 38152) {
                            retCode[i + 1] = 0;
                        }
                        for (int m = alarmList.size() - 1; m >= 0; --m) {
                            if (((TEAlarm)alarmList.get(m)).getEvtSerialNum() != evtSerialNum) continue;
                            alarmList.remove(m);
                            continue block6;
                        }
                    }
                }
            }
            return retCode;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("delete alarm " + TEStringUtils.intsToString((int[])evtSerialNums) + "failed");
            retCode[0] = 2;
            return retCode;
        }
    }

    public void removeAlarm(int slotID, int portID) {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        Vector alarmList = neImplInterface.getAlarmList();
        for (int j = alarmList.size() - 1; j >= 0; --j) {
            TEAlarm alarm = (TEAlarm)alarmList.get(j);
            if (alarm.getSlotID() != slotID) continue;
            if (0 != portID) {
                if (portID != alarm.getPort()) continue;
                alarmList.remove(j);
                continue;
            }
            alarmList.remove(j);
        }
    }

    public Vector getCpThrshDataList() {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        return neImplInterface.getCpThrshDataList();
    }

    public void setCpThrshDataList(Vector cpThrshDataList) {
        TENEImplInterface_WDM neImplInterface = (TENEImplInterface_WDM)this.getNeImplInterface();
        neImplInterface.setCpThrshDataList(cpThrshDataList);
    }

    public class BoardTimerTask
    extends TimerTask {
        @Override
        public void run() {
            try {
                TENE_WDM.this.queryBoard();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().info("queryboard error.", (Throwable)e);
            }
        }
    }
}

