/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.trans.nglct.util;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAPList;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstance;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstanceList;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.l3vpn.sync.FullSyncAFeature;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class TEIpv4Util {
    private static final String NSCMD_PTN_PORT_L3_SET_IPPARA_EX = "NSCMD_PTN_PORT_L3_SET_IPPARA_EX";
    private static final int DEFAULT_REMOTE_SLOTID_OR_PORT = 65535;
    private static final long INVALID_IP_OR_MASK = 0xFFFFFFFFL;
    private static final String IP_SPECIFY_TYPE = "1";
    private static final Logger LOGGER = TELogFactory.getNormalLogger();
    private static final String MAC_PORT_REG = "(^(Ethernet)|^(GigabitEthernet))[0-9]+\\/[0-9]+\\/[0-9]+$";
    private static final String VLAN_PORT_REG = "(^(Ethernet)|^(GigabitEthernet))[0-9]+\\/[0-9]+\\/[0-9]+\\.[0-9]+$";
    private static final int MAC_PORT = 0;
    private static final int VLAN_PORT = 1;
    private static final int INCORRECT_PORT = -1;
    public static final int DEL_ACTION = 0;
    public static final int ADD_ACTION = 1;
    private static final int TIME_OUT = 60;
    private static final int ONLEY_ONE = 1;
    private static final int DEPLOY_STATUS = 1;
    private static final String INTERFACE_CMD_REG = "(<ifm xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"><interfaces>)(<interface>.*(<am4CfgAddr operation=\"(create)|(delete)\">.*</am4CfgAddr>).*</interface>)+(</interfaces></ifm>)";

    public static Map<Ipv4Address, Integer> configIfmIpv4Address(int neID, Map<Ipv4Address, Integer> ipv4AddrsMap) {
        HashMap<Ipv4Address, Integer> ipAdd2Errcode = new HashMap<Ipv4Address, Integer>();
        HashMap<Ipv4Address, Integer> ipAdd2OperIndex = new HashMap<Ipv4Address, Integer>();
        ArrayList<Operation> opers = new ArrayList<Operation>();
        opers.addAll(TEIpv4Util.constructOperations(ipv4AddrsMap, ipAdd2Errcode, ipAdd2OperIndex));
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neID, opers, 60, null);
        if (result.retCode != 0) {
            Iterator<Ipv4Address> iter = ipv4AddrsMap.keySet().iterator();
            ipAdd2Errcode.clear();
            while (iter.hasNext()) {
                ipAdd2Errcode.put(iter.next(), result.retCode);
            }
            return ipAdd2Errcode;
        }
        TEIpv4Util.fillOperResult(opers, ipAdd2Errcode, ipAdd2OperIndex);
        new FullSyncAFeature().upload(neID, "ifm", false);
        ipAdd2OperIndex = null;
        opers = null;
        ipv4AddrsMap = null;
        return ipAdd2Errcode;
    }

    private static List<Operation> constructOperations(Map<Ipv4Address, Integer> ipv4AddrsMap, Map<Ipv4Address, Integer> ipAdd2Errcode, Map<Ipv4Address, Integer> ipAdd2OperIndex) {
        ArrayList<Operation> opers = new ArrayList<Operation>();
        int i = 0;
        for (Ipv4Address ipv4Addr : ipv4AddrsMap.keySet()) {
            Operation oper = TECreateObjectFactory.getOperation((int)ipv4Addr.getDevID(), (String)NSCMD_PTN_PORT_L3_SET_IPPARA_EX);
            if (oper == null) {
                LOGGER.error("this ipaddress config failed for no operation! " + ipv4Addr);
                ipAdd2Errcode.put(ipv4Addr, 1090593060);
                continue;
            }
            int portType = TEIpv4Util.getPortType(ipv4Addr.getIfName());
            if (portType == -1) {
                LOGGER.error("this ipaddress config failed for port type is incorrect! " + ipv4Addr);
                ipAdd2Errcode.put(ipv4Addr, 1090593060);
                continue;
            }
            String ifName = ipv4Addr.getIfName();
            int[] portAttr = null;
            if (portType == 0) {
                portAttr = TEIpv4Util.parseMacPortAttr(ifName);
            } else if (portType == 1) {
                portAttr = TEIpv4Util.parseVlanPortAttr(ifName);
            }
            if (portAttr[0] == 0 || portAttr[0] == 0) {
                LOGGER.error("this ipaddress config failed for no slotid or port! " + ipv4Addr);
                ipAdd2Errcode.put(ipv4Addr, 1090593060);
                continue;
            }
            oper.getInput().getPart("slotid").setValue(String.valueOf(portAttr[0]));
            oper.getInput().getPart("port").setValue(String.valueOf(portAttr[1]));
            oper.getInput().getPart("ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS").setValue(IP_SPECIFY_TYPE);
            String ip = null;
            String mask = null;
            if (ipv4AddrsMap.get(ipv4Addr) == 0) {
                ip = String.valueOf(0xFFFFFFFFL);
                mask = String.valueOf(0xFFFFFFFFL);
            } else if (ipv4AddrsMap.get(ipv4Addr) == 1) {
                ip = String.valueOf(IPAddressUtil.convertIPStrToLong((String)ipv4Addr.getIpAddr()));
                mask = String.valueOf(IPAddressUtil.convertIPStrToLong((String)ipv4Addr.getSubnetMask()));
            }
            oper.getInput().getPart("ATTR_ETHOVERPTN_MAC_IPADDRESS").setValue(ip);
            oper.getInput().getPart("ATTR_ETHOVERPTN_MAC_IPMARSK").setValue(mask);
            oper.getInput().getPart("ATTR_ETHOVERPTN_MAC_BORROWEDBOARDIPADDR").setValue(String.valueOf(65535));
            oper.getInput().getPart("ATTR_ETHOVERPTN_MAC_BORROWEDPORTIPADDR").setValue(String.valueOf(65535));
            opers.add(oper);
            ipAdd2OperIndex.put(ipv4Addr, i);
            ++i;
        }
        return opers;
    }

    private static void fillOperResult(List<Operation> opers, Map<Ipv4Address, Integer> ipAdd2Errcode, Map<Ipv4Address, Integer> ipAdd2OperIndex) {
        for (Ipv4Address ipv4Addr : ipAdd2OperIndex.keySet()) {
            Operation oper = opers.get(ipAdd2OperIndex.get(ipv4Addr));
            ipAdd2Errcode.put(ipv4Addr, Integer.valueOf(oper.getOutput(0).getFault(0).getCode()));
        }
    }

    public static boolean isAllSuccess(Map<Ipv4Address, Integer> ipAdd2Errcode) {
        boolean res = true;
        for (Ipv4Address ipv4Addr : ipAdd2Errcode.keySet()) {
            if (ipAdd2Errcode.get(ipv4Addr) == 0) continue;
            res = false;
            break;
        }
        return res;
    }

    public static int getPortType(String ifName) {
        int type = 0;
        type = Pattern.compile(MAC_PORT_REG).matcher(ifName).find() ? 0 : (Pattern.compile(VLAN_PORT_REG).matcher(ifName).find() ? 1 : -1);
        return type;
    }

    public static int[] parseMacPortAttr(String ifName) {
        int[] portAttr = new int[]{0, 0};
        String[] arrs = ifName.split("/");
        Matcher matcher = Pattern.compile("[0-9]+").matcher(arrs[0]);
        if (matcher.find()) {
            portAttr[0] = Integer.valueOf(matcher.group(0));
        }
        portAttr[1] = Integer.valueOf(arrs[2]);
        return portAttr;
    }

    public static int[] parseVlanPortAttr(String ifName) {
        int[] portAttr = new int[]{0, 0};
        Matcher matcher = Pattern.compile(".[0-9]+$").matcher(ifName);
        portAttr[0] = 65535;
        matcher.find();
        portAttr[1] = Integer.valueOf(matcher.group(0).substring(1));
        return portAttr;
    }

    public static Map<Integer, Map<Ipv4Address, String[]>> getIpv4RelationMap(QAsnRoutingInstanceList rspVpns, Context context, EOperationType operType) {
        HashMap<Integer, Map<Ipv4Address, String[]>> relationMap = new HashMap<Integer, Map<Ipv4Address, String[]>>();
        HashSet<L3vpnInstance> vpns = new HashSet<L3vpnInstance>();
        if (operType == EOperationType.DEPLOY) {
            vpns.addAll(context.getChangeRecord(L3vpnInstance.class).getCreates());
        } else if (operType == EOperationType.MODIFY) {
            vpns.addAll(context.getChangeRecord(L3vpnInstance.class).getModifies());
        }
        TEIpv4Util.filterVpn(rspVpns, vpns);
        if (vpns.isEmpty()) {
            TELogFactory.getNormalLogger().error("no vpn instance need to be config ip!");
            return relationMap;
        }
        for (L3vpnInstance vpn : vpns) {
            List ifms = vpn.getKeyRefMos(Interface.class);
            if (ifms.isEmpty()) {
                TELogFactory.getNormalLogger().error("no interface operation!" + vpn);
                continue;
            }
            for (Interface ifm : ifms) {
                Map<Ipv4Address, String[]> tempMap;
                Object[] objs;
                if (!TEIpv4Util.isBundToVpn(ifm, vpn)) {
                    TELogFactory.getNormalLogger().error("this ifm is not belong to this vpn! " + ifm);
                    continue;
                }
                ArrayList<Ipv4Address> ipv4addrs = ifm.getIpv4Addresss();
                if (ipv4addrs == null || ipv4addrs.isEmpty()) {
                    TELogFactory.getNormalLogger().error("no ip address operation of interface!" + ifm);
                    if (operType != EOperationType.MODIFY) continue;
                    ipv4addrs = new ArrayList<Ipv4Address>();
                    Ipv4Address delAddress = new Ipv4Address();
                    delAddress.setDevID(ifm.getDevID());
                    delAddress.setIfName(ifm.getIfName());
                    ipv4addrs.add(delAddress);
                }
                if ((objs = TEIpv4Util.getDestIpv4Address((Collection<Ipv4Address>)ipv4addrs, context, operType)) == null) {
                    TELogFactory.getNormalLogger().error("no ip address operation of interface!" + ifm);
                    continue;
                }
                int neID = vpn.getDevID();
                if (!relationMap.containsKey(neID)) {
                    tempMap = new HashMap();
                    relationMap.put(neID, tempMap);
                } else {
                    tempMap = (Map)relationMap.get(neID);
                }
                tempMap.put((Ipv4Address)objs[0], new String[]{TEIpv4Util.getVpnFDN(vpn), TEIpv4Util.getInterfaceFDN(ifm), objs[1].toString()});
            }
        }
        return relationMap;
    }

    public static void filterVpn(QAsnRoutingInstanceList rspVpns, Set<L3vpnInstance> vpns) {
        for (QAsnRoutingInstance rspVpn : rspVpns) {
            if (rspVpn.poOperResult.retCode == 0 && rspVpn.deployStatus == 1) continue;
            Iterator<L3vpnInstance> iter2 = vpns.iterator();
            while (iter2.hasNext()) {
                if (!TEAsn1Util.globalString((byte[])rspVpn.l3vpnKey.strFDN).equals(TEIpv4Util.getVpnFDN(iter2.next()))) continue;
                LOGGER.error("this vpn deploy failed or is undeploy status! so don't send ip config. vpn key is " + TEAsn1Util.globalString((byte[])rspVpn.l3vpnKey.strFDN));
                iter2.remove();
            }
        }
    }

    public static String getVpnFDN(L3vpnInstance vpn) {
        return vpn.getFdn() == null || "".equals(vpn.getFdn()) ? new L3vpnInstanceFdnParser().getFdn(vpn) : vpn.getFdn();
    }

    public static String getInterfaceFDN(Interface ifm) {
        return ifm.getFdn() == null || "".equals(ifm.getFdn()) ? new InterfaceFdnParser().getFdn(ifm) : ifm.getFdn();
    }

    private static Object[] getDestIpv4Address(Collection<Ipv4Address> srcIpv4Addrs, Context context, EOperationType operType) {
        if (srcIpv4Addrs.size() == 1 && operType == EOperationType.DEPLOY) {
            Ipv4Address ipv4AddObj = srcIpv4Addrs.iterator().next();
            return new Object[]{ipv4AddObj, String.valueOf(1)};
        }
        IMOChangeRecord rcd = context.getChangeRecord(Ipv4Address.class);
        if (srcIpv4Addrs.size() == 1 && operType == EOperationType.MODIFY) {
            Ipv4Address ipv4AddObj = srcIpv4Addrs.iterator().next();
            if (rcd.isDeleted((Object)ipv4AddObj) || null == ipv4AddObj.getIpAddr()) {
                return new Object[]{ipv4AddObj, String.valueOf(0)};
            }
            return new Object[]{ipv4AddObj, String.valueOf(1)};
        }
        if (srcIpv4Addrs.size() > 1 && operType == EOperationType.MODIFY) {
            if (rcd.getDeletes().size() <= 0 || rcd.getCreates().size() <= 0) {
                return null;
            }
            for (Ipv4Address ipv4Addr : srcIpv4Addrs) {
                if (!rcd.isCreated((Object)ipv4Addr)) continue;
                return new Object[]{ipv4Addr, String.valueOf(1)};
            }
        }
        return null;
    }

    public static boolean refactVpnListOfRsp(QAsnRoutingInstanceList vpns, Map<Ipv4Address, Integer> operResutsMap, Map<Ipv4Address, String[]> relationMap) {
        Iterator<Ipv4Address> ipv4s = operResutsMap.keySet().iterator();
        boolean isAllSuccess = true;
        while (ipv4s.hasNext()) {
            String ifmFdn;
            Ipv4Address ipv4 = ipv4s.next();
            if (operResutsMap.get(ipv4) == 0) continue;
            String vpnFdn = relationMap.get(ipv4)[0];
            Object[] objs = TEIpv4Util.searchVpnAndSap(vpnFdn, ifmFdn = relationMap.get(ipv4)[1], vpns);
            if (objs == null) {
                LOGGER.error("don't find sap in rsp for " + ipv4.toString() + ", fdn = " + vpnFdn + " " + ifmFdn);
                continue;
            }
            isAllSuccess = false;
            QAsnRoutingInstance vpn = (QAsnRoutingInstance)objs[0];
            QAsnSAP sap = (QAsnSAP)objs[1];
            vpn.poOperResult.isSuccess = true;
            vpn.poOperResult.retCode = 1107499879;
            sap.poOperResult.isSuccess = false;
            sap.poOperResult.retCode = operResutsMap.get(ipv4);
        }
        return isAllSuccess;
    }

    public static Object[] searchVpnAndSap(String vpnFdn, String ifmFdn, QAsnRoutingInstanceList vpns) {
        int iLen = vpns.size();
        for (int i = 0; i < iLen; ++i) {
            QAsnRoutingInstance vpn = (QAsnRoutingInstance)vpns.get(i);
            if (!vpnFdn.equals(TEAsn1Util.globalString((byte[])vpn.l3vpnKey.strFDN))) continue;
            QAsnSAPList saps = vpn.sapList;
            int jLen = vpns.size();
            for (int j = 0; j < jLen; ++j) {
                QAsnSAP sap = (QAsnSAP)saps.get(j);
                if (!ifmFdn.equals(TEAsn1Util.globalString((byte[])sap.ctpKey.strFDN))) continue;
                return new Object[]{vpn, sap};
            }
        }
        return null;
    }

    public static Map<Ipv4Address, Integer> constructSendObjMap(Map<Ipv4Address, String[]> srcMap) {
        HashMap<Ipv4Address, Integer> res = new HashMap<Ipv4Address, Integer>();
        for (Ipv4Address key : srcMap.keySet()) {
            res.put(key, Integer.valueOf(srcMap.get(key)[2]));
        }
        return res;
    }

    public static void main(String[] args) {
        Pattern pa = Pattern.compile(INTERFACE_CMD_REG);
        String str = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rpc message-id=\"1\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><edit-config><target><candidate/></target><default-operation>merge</default-operation><error-option>rollback-on-error</error-option><config><l3vpn xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"><l3vpncomm><l3vpnInstances><l3vpnInstance operation=\"delete\"><vrfName>dhj001</vrfName></l3vpnInstance></l3vpnInstances></l3vpncomm></l3vpn></config></edit-config></rpc>";
        Matcher matcher = pa.matcher(str);
        while (matcher.find()) {
            System.out.println(matcher.group(0));
        }
        String str1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rpc message-id=\"1\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><edit-config><target><candidate/></target><default-operation>merge</default-operation><error-option>rollback-on-error</error-option><config><l3vpn xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"><l3vpncomm><l3vpnInstances><l3vpnInstance operation=\"create\"><vrfName>dhj001</vrfName><vrfDescription>dhj001</vrfDescription><vpnInstAFs><vpnInstAF><afType>ipv4uni</afType><vrfRD>30:1</vrfRD><vrfLabelMode>perRoute</vrfLabelMode><vpnTargets><vpnTarget><vrfRTValue>30:1</vrfRTValue><vrfRTType>export_extcommunity</vrfRTType></vpnTarget><vpnTarget><vrfRTValue>30:1</vrfRTValue><vrfRTType>import_extcommunity</vrfRTType></vpnTarget></vpnTargets></vpnInstAF></vpnInstAFs><l3vpnIfs><l3vpnIf><ifName>GigabitEthernet6/0/1</ifName></l3vpnIf></l3vpnIfs></l3vpnInstance></l3vpnInstances></l3vpncomm></l3vpn><ifm xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"><interfaces><interface><ifName>GigabitEthernet6/0/1</ifName><ifmAm4><am4CfgAddrs><am4CfgAddr operation=\"delete\"><ifIpAddr>126.9.10.2</ifIpAddr><subnetMask>255.255.255.0</subnetMask><addrType>main</addrType></am4CfgAddr></am4CfgAddrs></ifmAm4></interface></interfaces></ifm></config></edit-config></rpc>";
        matcher = pa.matcher(str1);
        while (matcher.find()) {
            System.out.println(matcher.group(0));
        }
        String str2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rpc message-id=\"1\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><edit-config><target><candidate/></target><default-operation>merge</default-operation><error-option>rollback-on-error</error-option><config><ifm xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"><interfaces><interface><ifName>GigabitEthernet6/0/1</ifName><ifmAm4><am4CfgAddrs><am4CfgAddr operation=\"create\"><ifIpAddr>126.9.10.2</ifIpAddr><subnetMask>255.255.255.0</subnetMask><addrType>main</addrType></am4CfgAddr></am4CfgAddrs></ifmAm4></interface><interface><ifName>GigabitEthernet3/0/1</ifName><ifmAm4><am4CfgAddrs><am4CfgAddr operation=\"create\"><ifIpAddr>126.9.10.3</ifIpAddr><subnetMask>255.255.255.0</subnetMask><addrType>main</addrType></am4CfgAddr></am4CfgAddrs></ifmAm4></interface></interfaces></ifm><l3vpn xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"><l3vpncomm><l3vpnInstances><l3vpnInstance><vrfName>dhj001</vrfName></l3vpnInstance></l3vpnInstances></l3vpncomm></l3vpn></config></edit-config></rpc>";
        matcher = pa.matcher(str2);
        while (matcher.find()) {
            System.out.println(matcher.group(0));
        }
        String str3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rpc message-id=\"1\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><edit-config><target><candidate/></target><default-operation>merge</default-operation><error-option>rollback-on-error</error-option><config><ifm xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"><interfaces><interface><ifName>GigabitEthernet6/0/1</ifName><ifmAm4><am4CfgAddrs><am4CfgAddr operation=\"delete\"><ifIpAddr>126.9.1.2</ifIpAddr></am4CfgAddr><am4CfgAddr operation=\"create\"><ifIpAddr>126.9.1.3</ifIpAddr><subnetMask>255.255.255.0</subnetMask><addrType>main</addrType></am4CfgAddr></am4CfgAddrs></ifmAm4></interface><interface><ifName>GigabitEthernet3/0/1</ifName><ifmAm4><am4CfgAddrs><am4CfgAddr operation=\"delete\"><ifIpAddr>126.9.10.2</ifIpAddr></am4CfgAddr><am4CfgAddr operation=\"create\"><ifIpAddr>126.9.10.3</ifIpAddr><subnetMask>255.255.255.0</subnetMask><addrType>main</addrType></am4CfgAddr></am4CfgAddrs></ifmAm4></interface></interfaces></ifm><l3vpn xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"><l3vpncomm><l3vpnInstances><l3vpnInstance><vrfName>dhj001</vrfName></l3vpnInstance></l3vpnInstances></l3vpncomm></l3vpn></config></edit-config></rpc>";
        matcher = pa.matcher(str3);
        while (matcher.find()) {
            System.out.println(matcher.group(0));
        }
        ArrayList<String> strlist = new ArrayList<String>();
        strlist.add("2/1/2");
        strlist.add("2\\1\\2");
        strlist.add("Ethernet2\\1\\2");
        strlist.add("Ethernet2/1/2");
        strlist.add("GigabitEthernet2/1/2");
        strlist.add("GigabitEthernet2\\1\\2");
        strlist.add("GigabitEthernet2/1/2.10236");
        strlist.add("Ethernet2/1/2.10236");
        for (String tempStr : strlist) {
            if (TEIpv4Util.getPortType(tempStr) == 0) {
                System.out.println("the port is MAC port, " + TEIpv4Util.parseMacPortAttr(tempStr)[0] + " " + TEIpv4Util.parseMacPortAttr(tempStr)[1]);
                continue;
            }
            if (TEIpv4Util.getPortType(tempStr) == 1) {
                System.out.println("the port is VLAN port, " + TEIpv4Util.parseVlanPortAttr(tempStr)[0] + " " + TEIpv4Util.parseVlanPortAttr(tempStr)[1]);
                continue;
            }
            System.out.println("the port is incorrect!");
        }
    }

    private static boolean isBundToVpn(Interface ifm, L3vpnInstance vpn) {
        boolean res = false;
        for (L3vpnIf l3vpnIf : vpn.getL3vpnIfs()) {
            if (l3vpnIf.getDevID().intValue() != ifm.getDevID().intValue() || !l3vpnIf.getIfName().equals(ifm.getIfName())) continue;
            res = true;
            break;
        }
        return res;
    }
}

