/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.trans.nglct.impl_adapter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TEIProcessOnReceiveNeMsg;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.TENeConvertor;
import com.huawei.trans.nglct.devicecache.TEDeviceCache;
import com.huawei.trans.nglct.impl.TransSessionFactory;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.syncdata.SyncNodeInfoMgr;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevTypeInfo;
import com.huawei.vmf.adapter.fservice.sync.model.DataSyncSNNode;
import org.slf4j.Logger;

public class TEVmfProcessOnReceiveNEMsg
implements TEIProcessOnReceiveNeMsg {
    private static Logger logger = TELogFactory.getNormalLogger();

    public void processOnAdd(int neID) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (ne == null) {
            logger.error("don't find ne!");
            return;
        }
        String devTypeName = TENeConvertor.getInstance().getNeTypeNameByNeType(ne.getNEType());
        String rVersion = TENeConvertor.getInstance().getRVersion(ne.getHostVersion());
        if (devTypeName == null || "".equals(devTypeName) || rVersion == null) {
            TELogFactory.getNormalLogger().error("this ne mo can not be suite for adding to vmf ne cache!" + ne.toString());
            return;
        }
        DevSysInfo devSysInfo = new DevSysInfo();
        devSysInfo.setDevIP(ne.getGateNeIp());
        devSysInfo.setDevID(Integer.valueOf(neID));
        devSysInfo.setDevProductName(devTypeName);
        devSysInfo.setDevProductVersion(rVersion);
        devSysInfo.setDevSysOID(String.valueOf(ne.getRealNEID()));
        devSysInfo.setDevTypeID(Integer.valueOf(1972));
        devSysInfo.setDevRole(Integer.valueOf(0));
        devSysInfo.setDevName(ne.getNEName());
        DevSysInfo oldDevSysInfo = TEDeviceCache.getInstance().getDevice(neID);
        if (oldDevSysInfo != null) {
            logger.info("find old devsys info in cache, now update old!" + oldDevSysInfo.toString() + ", " + devSysInfo.toString());
            this.updateDevSysInfo(oldDevSysInfo, devSysInfo);
        } else {
            logger.info("add dev info to vmf cache." + devSysInfo.toString());
            TEDeviceCache.getInstance().addDevice(devSysInfo);
        }
        DevTypeInfo devTypeInfo = new DevTypeInfo();
        devTypeInfo.setDevTypeID(Integer.valueOf(1972));
        devTypeInfo.setDevVersionID(Integer.valueOf(6));
        devTypeInfo.setDevTypeName(devTypeName);
        devTypeInfo.setDevVersionName(rVersion);
        devTypeInfo.setDevSysOID(String.valueOf(ne.getRealNEID()));
        devTypeInfo.setSupPortLic(Integer.valueOf(0));
        DevTypeInfo oldDevTypeInfo = TEDeviceCache.getInstance().getDevTypeBySysOID(devTypeInfo.getDevSysOID());
        if (oldDevTypeInfo != null) {
            logger.info("find old devtype info in cache, now update old!" + oldDevTypeInfo.toString() + ", " + devTypeInfo.toString());
            this.updateDevTypeInfo(oldDevTypeInfo, devTypeInfo);
        } else {
            logger.info("add devtype info to vmf cache." + devTypeInfo.toString());
            TEDeviceCache.getInstance().addDeviceType(devTypeInfo);
        }
        if (SyncNodeInfoMgr.getInstance().getDataSyncSNNode(neID) == null) {
            DataSyncSNNode dataSyncSNNode = new DataSyncSNNode(neID);
            SyncNodeInfoMgr.getInstance().addSyncNodeInfo(dataSyncSNNode);
            logger.info("add sync node. " + neID);
        }
    }

    public void processOnRemove(int neID) {
        DevSysInfo devInfo = null;
        Context ctx = new Context();
        logger.info("remove dev info from vmf cache." + neID);
        devInfo = TEDeviceCache.getInstance().removeDevice(neID);
        if (devInfo != null) {
            ctx.addChangeRecord(DevSysInfo.class).addDelete((Object)devInfo);
        } else {
            logger.info("no devsysinfo cache for this ne." + neID);
        }
        logger.info("remove dev type info from vmf cache." + neID);
        TEDeviceCache.getInstance().removeDeviceTypeByID(TENEListMgr.getInstance().getNE(neID).getRealNEID());
        SyncNodeInfoMgr.getInstance().removeSyncNodeInfo(neID);
        TransSessionFactory.clearSession((int)neID);
        logger.info("remove sync node. " + neID);
        MOChangePublisher.getInstance().notifyChanges(ctx);
    }

    private void updateDevSysInfo(DevSysInfo oldDevSysInfo, DevSysInfo newDevSysInfo) {
        if (!oldDevSysInfo.getDevIP().equals(newDevSysInfo.getDevIP())) {
            oldDevSysInfo.setDevIP(newDevSysInfo.getDevIP());
        }
        if (oldDevSysInfo.getDevID().intValue() != newDevSysInfo.getDevID().intValue()) {
            oldDevSysInfo.setDevID(newDevSysInfo.getDevID());
        }
        if (!oldDevSysInfo.getDevProductName().equals(newDevSysInfo.getDevProductName())) {
            oldDevSysInfo.setDevProductName(newDevSysInfo.getDevProductName());
        }
        if (!oldDevSysInfo.getDevProductVersion().equals(newDevSysInfo.getDevProductVersion())) {
            oldDevSysInfo.setDevProductVersion(newDevSysInfo.getDevProductVersion());
        }
        if (!oldDevSysInfo.getDevSysOID().equals(newDevSysInfo.getDevSysOID())) {
            oldDevSysInfo.setDevSysOID(newDevSysInfo.getDevSysOID());
        }
        if (oldDevSysInfo.getDevTypeID().intValue() != newDevSysInfo.getDevTypeID().intValue()) {
            oldDevSysInfo.setDevTypeID(newDevSysInfo.getDevTypeID());
        }
        if (oldDevSysInfo.getDevRole().intValue() != newDevSysInfo.getDevRole().intValue()) {
            oldDevSysInfo.setDevRole(newDevSysInfo.getDevRole());
        }
        if (!oldDevSysInfo.getDevName().equals(newDevSysInfo.getDevName())) {
            oldDevSysInfo.setDevName(newDevSysInfo.getDevName());
        }
    }

    private void updateDevTypeInfo(DevTypeInfo oldDevTypeInfo, DevTypeInfo newDevTypeInfo) {
        if (!oldDevTypeInfo.getDevTypeName().equals(newDevTypeInfo.getDevTypeName())) {
            oldDevTypeInfo.setDevTypeName(newDevTypeInfo.getDevTypeName());
        }
        if (oldDevTypeInfo.getDevVersionID().intValue() != newDevTypeInfo.getDevVersionID().intValue()) {
            oldDevTypeInfo.setDevVersionID(newDevTypeInfo.getDevVersionID());
        }
        if (!oldDevTypeInfo.getDevVersionName().equals(newDevTypeInfo.getDevVersionName())) {
            oldDevTypeInfo.setDevVersionName(newDevTypeInfo.getDevVersionName());
        }
        if (oldDevTypeInfo.getSupPortLic().intValue() != newDevTypeInfo.getSupPortLic().intValue()) {
            oldDevTypeInfo.setSupPortLic(newDevTypeInfo.getSupPortLic());
        }
        if (!oldDevTypeInfo.getDevSysOID().equals(newDevTypeInfo.getDevSysOID())) {
            oldDevTypeInfo.setDevSysOID(newDevTypeInfo.getDevSysOID());
        }
        if (oldDevTypeInfo.getDevTypeID().intValue() != newDevTypeInfo.getDevTypeID().intValue()) {
            oldDevTypeInfo.setDevTypeID(newDevTypeInfo.getDevTypeID());
        }
    }
}

