/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.trans.nglct.impl_adapter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.l3vpn.sync.RtnSyncImplement;
import com.huawei.vmf.adapter.framework.syncdata.DataSyncProcessNode;
import com.huawei.vmf.adapter.framework.syncdata.impl.SyncConfigInfoMgr;
import com.huawei.vmf.adapter.framework.syncdata.impl.SyncJobReceiver;
import com.huawei.vmf.extendpoint.framework.IFullSyncHandler;
import org.springframework.util.StringUtils;

public class TETransFullSyncHandler
implements IFullSyncHandler {
    public void syncAll(int neID, long curDifference, long minDifference, long curNMSerialNum, String processFailFeatureLst, long curDevSerialNum, String serialNumInitTime) {
        if (curNMSerialNum == -1L) {
            TELogFactory.getNormalLogger().info("device hasn't full syncrhonize yet:{}", (Object)neID);
            if (StringUtils.hasText((String)processFailFeatureLst)) {
                TELogFactory.getNormalLogger().info("last sync parse data error. not to try first full sync again. devID=" + neID);
                return;
            }
            try {
                new RtnSyncImplement().upload(neID);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("construct handler failed! full sync cancle.");
            }
        } else if (curNMSerialNum == -2L) {
            TELogFactory.getNormalLogger().info("device serial reverse syncrhonize:{}", (Object)neID);
            try {
                new RtnSyncImplement().upload(neID);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("construct handler failed! full sync cancle.");
            }
        } else if (curDifference > (long)SyncConfigInfoMgr.getInstance().getMaxFullSyncSNThreshold()) {
            TELogFactory.getNormalLogger().info("serial has lot changed, full synchronize device:{}", (Object)neID);
            if (StringUtils.hasText((String)processFailFeatureLst)) {
                TELogFactory.getNormalLogger().info("last sync parse data error. not to try sync again. devID=" + neID);
                return;
            }
            try {
                new RtnSyncImplement().upload(neID);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("construct handler failed! full sync cancle.");
            }
        } else if (curDifference > minDifference) {
            if (StringUtils.hasText((String)processFailFeatureLst)) {
                TELogFactory.getNormalLogger().info("last sync parse data error. not to try sync again. devID=" + neID);
                return;
            }
            DataSyncProcessNode incr = DataSyncProcessNode.createIncrSyncJob((int)neID, null, (long)curDevSerialNum, (String)serialNumInitTime);
            TELogFactory.getNormalLogger().info("serial has little changed, increment synchronize device:{}", (Object)neID);
            SyncJobReceiver.getInstance().applySyncJob(incr);
        } else {
            TELogFactory.getNormalLogger().info("NM has no changed:NM{}");
            return;
        }
    }
}

