/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.l3vpn.task;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.DefaultDao;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class TETransL3StatusPublicProc {
    private static final Logger LOGGER = TELogFactory.getNormalLogger();
    private static final int VLAN_PORT_GAP = 10240;

    public String getVrfFdnByIfm(Interface ifm) {
        String vrfFdn = null;
        L3vpnIf l3If = new L3vpnIf();
        l3If.setDevID(ifm.getDevID());
        l3If.setVrID(ifm.getVrID());
        l3If.setIfName(ifm.getIfName());
        ArrayList<L3vpnIf> l3Ifs = new ArrayList<L3vpnIf>();
        l3Ifs.add(l3If);
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection l3ifs_data = dao.queryByKey(L3vpnIf.class, l3Ifs, false);
            if (CollectionUtils.isEmpty((Collection)l3ifs_data)) {
                LOGGER.error("query l3if by ifm is null!");
                return vrfFdn;
            }
            L3vpnIf l3if_data = (L3vpnIf)l3ifs_data.iterator().next();
            L3vpnInstance l3vpn = new L3vpnInstance();
            l3vpn.setDevID(l3if_data.getDevID());
            l3vpn.setVrID(l3if_data.getVrID());
            l3vpn.setVrfName(l3if_data.getVrfName());
            L3vpnInstanceFdnParser parser = new L3vpnInstanceFdnParser();
            vrfFdn = parser.getFdn(l3vpn);
        }
        catch (VMFException e) {
            LOGGER.error("query l3if by ifm failed!", (Throwable)e);
        }
        return vrfFdn;
    }

    public String convertToPortFdnByObject(int neID, int slotID, int port) {
        if (slotID == 65535) {
            return this.convertToVlanSubPortNameByDomain(neID, 0, port);
        }
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)neID);
        factory.append("S", (long)slotID);
        factory.append("CP", -1L);
        StrLinker linker = new StrLinker();
        linker.append("16");
        linker.append("");
        linker.append((long)port);
        linker.append("");
        factory.append("PP", linker.getStr());
        return factory.getStr();
    }

    public String convertToVlanSubPortNameByDomain(int neID, int vrID, long vport) {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)neID);
        if (vrID != 0) {
            factory.append("VR", (long)vrID);
        }
        StrLinker linker = new StrLinker();
        linker.append("16").append(65550L).append(vport - 10240L).append("");
        factory.append("LP", linker.getStr());
        return factory.getStr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatusByMoType(Class<?> moType, Context context) {
        boolean bisSuccess = false;
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(context);
            dao.merge(moType, false);
            context.commit();
            bisSuccess = true;
            MOChangePublisher.getInstance().notifyAlarmChanges(context);
        }
        catch (VMFException ex) {
            LOGGER.error("update status faild", (Throwable)ex);
        }
        finally {
            if (!bisSuccess) {
                context.rollback();
            }
            context.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildMoKeyByParentMo(VmfMO child, VmfMO parent) {
        DefaultDao dao = (DefaultDao)DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            dao.getRelationMeta(parent.getClass()).setChildKeyByParentKey((Object)parent, (Object)child);
        }
        finally {
            dao.rollback();
        }
    }

    public class RreshL3vpnStatusThread
    extends Thread {
        String l3vpnFdn;

        public RreshL3vpnStatusThread(String vrfFDN) {
            this.l3vpnFdn = vrfFDN;
        }

        @Override
        public void run() {
            try {
                L3vpnInstanceFdnParser parser = new L3vpnInstanceFdnParser();
                L3vpnInstance vrf = parser.getIndexMo(this.l3vpnFdn);
                this.querySapByVrfs(vrf);
                HashMap<VmfMO, ErrorInfo> moOperResults = new HashMap<VmfMO, ErrorInfo>();
                this.getVrfStatusFromDev(vrf, moOperResults);
                Context context = new Context();
                for (Map.Entry moOperResultsEntry : moOperResults.entrySet()) {
                    if (((ErrorInfo)moOperResultsEntry.getValue()).getErrorCode() != 0) {
                        LOGGER.error("query status from dev failed! errorcode:" + ((ErrorInfo)moOperResultsEntry.getValue()).getErrorCode() + ", errormsg:" + ((ErrorInfo)moOperResultsEntry.getValue()).getErrorMessage());
                    }
                    VmfMO mo = (VmfMO)moOperResultsEntry.getKey();
                    context.addMoOperResult(mo, (ErrorInfo)moOperResultsEntry.getValue());
                }
                this.updateStatusAndRpt(vrf, context);
            }
            catch (VMFException e) {
                LOGGER.error("refresh status from dev failed!", (Throwable)e);
            }
        }

        private void querySapByVrfs(L3vpnInstance vrf) throws VMFException {
            ArrayList<L3vpnInstance> vrfs = new ArrayList<L3vpnInstance>();
            vrfs.add(vrf);
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            dao.queryByParentKey(L3vpnIf.class, L3vpnInstance.class, vrfs);
            if (CollectionUtils.isEmpty((Collection)vrf.getL3vpnIfs())) {
                return;
            }
            for (L3vpnIf vrfIf : vrf.getL3vpnIfs()) {
                Interface ifMo = new Interface();
                ifMo.setDevID(vrfIf.getDevID());
                ifMo.setVrID(vrfIf.getVrID());
                ifMo.setIfName(vrfIf.getIfName());
                vrf.addKeyRefMo((VmfMO)ifMo);
            }
        }

        private void getVrfStatusFromDev(L3vpnInstance vrf, Map<VmfMO, ErrorInfo> moOperResults) throws VMFException {
            DefaultMOService pollService = new DefaultMOService();
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(vrf.getDevID().intValue());
            if (queryContext == null) {
                queryContext = new QuerySchemaTranslatorContext(vrf.getDevID().intValue());
                pollService.addQueryJob(queryContext);
            }
            VpnInstAF vrfAF = new VpnInstAF();
            TETransL3StatusPublicProc.this.setChildMoKeyByParentMo((VmfMO)vrfAF, (VmfMO)vrf);
            vrfAF.setAfType(VpnInstAF.AF_TYPE_ENUM.IPV4UNI);
            vrf.addVpnInstAFs(Arrays.asList(vrfAF));
            queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrf, Arrays.asList("vpnInstAFs"));
            queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrfAF, Arrays.asList("vrfStatus"));
            for (Interface ifMo : vrf.getKeyRefMos(Interface.class)) {
                queryContext.addQueryAttributes(FeatureName.IFM, (VmfMO)ifMo, Arrays.asList("ifAdminStatus", "ifOperStatus"));
            }
            pollService.poll();
            moOperResults.putAll(pollService.getAllErrorInfos());
        }

        private void updateStatusAndRpt(L3vpnInstance vrf, Context context) throws VMFException {
            IMOChangeRecord record;
            ArrayList<VpnInstAF> vrfAFs = new ArrayList<VpnInstAF>();
            ArrayList<Interface> ifMos = new ArrayList<Interface>();
            if (0 != context.getMoErrorCode((VmfMO)vrf)) {
                return;
            }
            if (!CollectionUtils.isEmpty((Collection)vrf.getVpnInstAFs())) {
                for (VpnInstAF af : vrf.getVpnInstAFs()) {
                    if (0 != context.getMoErrorCode((VmfMO)af) || af.getVrfStatus() == null) {
                        LOGGER.error("this af is not correct! " + af.getDevID());
                        continue;
                    }
                    vrfAFs.add(af);
                }
            }
            for (Interface ifMo : vrf.getKeyRefMos(Interface.class)) {
                if (0 != context.getMoErrorCode((VmfMO)ifMo) || ifMo.getIfAdminStatus() == null || ifMo.getIfOperStatus() == null) {
                    LOGGER.error("this interface is not correct! " + ifMo.getIfName());
                    continue;
                }
                ifMos.add(ifMo);
            }
            if (!vrfAFs.isEmpty()) {
                record = context.addChangeRecord(VpnInstAF.class);
                for (VpnInstAF vrfAf : vrfAFs) {
                    record.addModify((Object)vrfAf, Arrays.asList("vrfStatus"));
                }
                TETransL3StatusPublicProc.this.updateStatusByMoType(VpnInstAF.class, context);
            }
            if (!ifMos.isEmpty()) {
                record = context.addChangeRecord(Interface.class);
                for (Interface ifm : ifMos) {
                    record.addModify((Object)ifm, Arrays.asList("ifAdminStatus", "ifOperStatus"));
                }
                TETransL3StatusPublicProc.this.updateStatusByMoType(Interface.class, context);
            }
        }
    }
}

