/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.l3vpn.task;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.l3vpn.task.TETransL3StatusPublicProc;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.f_interface.emf.common.AsnForwardFaultRptList;
import com.huawei.nglct.nemgr.f_interface.emf.common.AsnForwardFaultRptStrc;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class TEL3vpnStatusRfreshAlmHandler {
    private static final Logger LOGGER = TELogFactory.getNormalLogger();
    private static final int ALARM_END = 2;
    private static final int VRF_DOWN_FLAUTID = 13563;
    private static final int PORT_DOWN_FLAUTID = 13564;
    private static final String PART_VRF_FDN_REG = "^NE=\\d+";

    public void handleAlarm(AsnForwardFaultRptList req) {
        block3: for (AsnForwardFaultRptStrc unitData : req) {
            int faultId = unitData.sFaultID.intValue();
            switch (faultId) {
                case 13563: {
                    this.procesVrfStatusChg(unitData);
                    continue block3;
                }
            }
            LOGGER.info("is not correct alarm!" + faultId);
        }
    }

    private void procesVrfStatusChg(AsnForwardFaultRptStrc rptData) {
        LOGGER.info("start process vrf status change!");
        LinkedList<VpnInstAF> vrfAFs = new LinkedList<VpnInstAF>();
        L3vpnInstanceFdnParser parser = new L3vpnInstanceFdnParser();
        String l3vpnFdn = StringUtil.globalString((byte[])rptData.strFdn);
        if (Pattern.matches(PART_VRF_FDN_REG, l3vpnFdn)) {
            l3vpnFdn = l3vpnFdn + ",VRF=|" + StringUtil.globalString((byte[])rptData.strPara);
        }
        L3vpnInstance vrf = parser.getIndexMo(l3vpnFdn);
        if (!TESpecialAttrMgr.getInstance().isNESupport(vrf.getDevID().intValue(), "TE_FUNC_CFG_NE_ATTRIBUTE", "NE_ATTR_SUPPORT_PROCESS_ONRECEIVENEMSG")) {
            LOGGER.info("this ne type do not support!" + vrf.getDevID());
            return;
        }
        LOGGER.info("the vrf fdn is " + l3vpnFdn);
        int faultFlag = rptData.cFaultFlag.intValue();
        LOGGER.info("the vrf alarm status is " + faultFlag);
        VpnInstAF vrfAF = new VpnInstAF();
        TETransL3StatusPublicProc stausPbulcProc = new TETransL3StatusPublicProc();
        stausPbulcProc.setChildMoKeyByParentMo((VmfMO)vrfAF, (VmfMO)vrf);
        vrfAF.setAfType(VpnInstAF.AF_TYPE_ENUM.IPV4UNI);
        vrf.addVpnInstAFs(Arrays.asList(vrfAF));
        vrfAF.setVrfStatus(faultFlag == 2 ? VpnInstAF.VRF_STATUS_ENUM.UP : VpnInstAF.VRF_STATUS_ENUM.DOWN);
        vrfAFs.add(vrfAF);
        if (vrfAFs.isEmpty()) {
            return;
        }
        Context context = new Context();
        IMOChangeRecord record = context.addChangeRecord(VpnInstAF.class);
        for (VpnInstAF tempVrfAF : vrfAFs) {
            record.addModify((Object)tempVrfAF, Arrays.asList("vrfStatus"));
        }
        stausPbulcProc.updateStatusByMoType(VpnInstAF.class, context);
        TETransL3StatusPublicProc tETransL3StatusPublicProc = stausPbulcProc;
        tETransL3StatusPublicProc.getClass();
        new TETransL3StatusPublicProc.RreshL3vpnStatusThread(tETransL3StatusPublicProc, l3vpnFdn).start();
        LOGGER.info("end process vrf status change!");
    }

    public static void main(String[] args) {
        String a = "NE=3132,VRF=|ERIC";
        System.out.println(a + ", " + Pattern.matches(PART_VRF_FDN_REG, a));
        a = "NE=3132";
        System.out.println(a + ", " + Pattern.matches(PART_VRF_FDN_REG, a));
        a = "NE=3132,  VRF=|ERIC";
        System.out.println(a + ", " + Pattern.matches(PART_VRF_FDN_REG, a));
        a = "NE=3132,  VRF=23|ERIC";
        System.out.println(a + ", " + Pattern.matches(PART_VRF_FDN_REG, a));
        a = "NE=313a,  VRF=23|ERIC";
        System.out.println(a + ", " + Pattern.matches(PART_VRF_FDN_REG, a));
        a = "NE=3132,  VRF=|a";
        System.out.println(a + ", " + Pattern.matches(PART_VRF_FDN_REG, a));
        a = "NE=3132,";
        System.out.println(a + ", " + Pattern.matches(PART_VRF_FDN_REG, a));
    }
}

