/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.l3vpn.task;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.l3vpn.task.TETransL3StatusPublicProc;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;

public class TEL3vpnInfStatusChgEventHandler
implements NoticeHandler {
    private static final Logger LOGGER = TELogFactory.getNormalLogger();
    private static final int Port_UP = 1;

    public void handleNotice(int cmdKey, int neID, Operation operation) {
        TELogFactory.getNormalLogger().info("start process port logic state even. " + new Date().toString());
        Output output = operation.getOutput(0);
        int slotID = Integer.valueOf(output.getPartValue("slotID"));
        int portID = Integer.valueOf(output.getPartValue("portID"));
        int portStatus = Integer.valueOf(output.getPartValue("portStatus"));
        TETransL3StatusPublicProc stausPbulcProc = new TETransL3StatusPublicProc();
        String portFDN = stausPbulcProc.convertToPortFdnByObject(neID, slotID, portID);
        this.processPortStatusChg(portFDN, portStatus);
        TELogFactory.getNormalLogger().info("end process incr sync event. " + new Date().toString());
    }

    private void processPortStatusChg(String portFDN, int portStatus) {
        LOGGER.info("start process port status change!");
        Context context = new Context(true);
        LOGGER.info("the port fdn is " + portFDN);
        Interface ifm = InterfaceUtil.getIndexByFdn((String)portFDN);
        ifm.setFdn(portFDN);
        if (!TESpecialAttrMgr.getInstance().isNESupport(ifm.getDevID().intValue(), "TE_FUNC_CFG_NE_ATTRIBUTE", "NE_ATTR_SUPPORT_PROCESS_ONRECEIVENEMSG")) {
            LOGGER.info("this ne type do not support!" + ifm.getDevID());
            return;
        }
        LOGGER.info("the port alarm status is " + portStatus);
        ifm.setIfAdminStatus(portStatus == 1 ? Interface.IF_ADMIN_STATUS_ENUM.UP : Interface.IF_ADMIN_STATUS_ENUM.DOWN);
        ifm.setIfOperStatus(portStatus == 1 ? Interface.IF_OPER_STATUS_ENUM.UP : Interface.IF_OPER_STATUS_ENUM.DOWN);
        IMOChangeRecord record = context.addChangeRecord(Interface.class);
        record.addModify((Object)ifm, Arrays.asList("ifAdminStatus", "ifOperStatus"));
        TETransL3StatusPublicProc stausPbulcProc = new TETransL3StatusPublicProc();
        stausPbulcProc.updateStatusByMoType(Interface.class, context);
        TETransL3StatusPublicProc tETransL3StatusPublicProc = stausPbulcProc;
        tETransL3StatusPublicProc.getClass();
        new TETransL3StatusPublicProc.RreshL3vpnStatusThread(tETransL3StatusPublicProc, stausPbulcProc.getVrfFdnByIfm(ifm)).start();
        LOGGER.info("end process port status change!");
    }
}

