/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.l3vpn.sync.impl;

import com.huawei.nglct.l3vpn.sync.TETransFeatureSyncHandle;
import com.huawei.nglct.l3vpn.sync.TETransFullSyncTranslationContext;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.util.ReflectHelper;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnTarget;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class TETransL3vpnSyncHandler
extends TETransFeatureSyncHandle {
    private static final Class<?>[] VRF_CHILDREN = new Class[]{L3vpnInstance.class, L3vpnIf.class, VpnInstAF.class, VpnTarget.class};
    private final LinkedHashSet<Class<? extends VmfMO>> moTypes = new LinkedHashSet();

    public TETransL3vpnSyncHandler() {
        this.moTypes.add(L3vpnInstance.class);
    }

    private static String getVrfName(VmfMO vrfChildMO) {
        return (String)ReflectHelper.getInstance().getPropertyValue((Object)vrfChildMO, "vrfName");
    }

    @Override
    public FeatureName getFeatureName() {
        return FeatureName.L3VPN;
    }

    @Override
    public LinkedHashSet<Class<? extends VmfMO>> getTopMoClasses() {
        return this.moTypes;
    }

    @Override
    protected void fullSyncPreProcess(TETransFullSyncTranslationContext translationContext) throws VMFException {
        super.fullSyncPreProcess(translationContext);
        this.filterPublicVrf(translationContext.getContext());
    }

    private void filterPublicVrf(Context context) {
        for (Class<?> childType : VRF_CHILDREN) {
            this.filterPublicVrfChildMO(context, childType);
        }
    }

    private void filterPublicVrfChildMO(Context context, Class<?> vrfChildType) {
        if (context == null) {
            return;
        }
        IMOChangeRecord changeRecord = context.getChangeRecord(vrfChildType);
        if (changeRecord == null || changeRecord.getCreates() == null) {
            return;
        }
        ArrayList<VmfMO> toCancel = new ArrayList<VmfMO>();
        for (VmfMO vrfChild : changeRecord.getCreates()) {
            if (!"_public_".equals(TETransL3vpnSyncHandler.getVrfName(vrfChild))) continue;
            toCancel.add(vrfChild);
        }
        for (VmfMO vrfChild : toCancel) {
            changeRecord.cancelCreate((Object)vrfChild);
        }
    }
}

