/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.l3vpn.sync.impl;

import com.huawei.nglct.l3vpn.sync.TETransFeatureSyncHandle;
import com.huawei.nglct.l3vpn.sync.TETransFullSyncTranslationContext;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.IpAddressUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class TETransInterfaceSyncHandler
extends TETransFeatureSyncHandle {
    private LinkedHashSet<Class<? extends VmfMO>> moTypes = new LinkedHashSet();

    public TETransInterfaceSyncHandler() {
        this.moTypes.add(Interface.class);
    }

    @Override
    public FeatureName getFeatureName() {
        return FeatureName.IFM;
    }

    @Override
    protected void fullSyncPreProcess(TETransFullSyncTranslationContext translationContext) throws VMFException {
        this.decodeFdn(translationContext.getContext());
        this.decodeNetAddr(translationContext.getContext());
        super.fullSyncPreProcess(translationContext);
        this.delPreDataWithOutMainIf(translationContext);
    }

    @Override
    public LinkedHashSet<Class<? extends VmfMO>> getTopMoClasses() {
        return this.moTypes;
    }

    private void decodeFdn(Context context) {
        InterfaceFdnParser interfaceFdnParser = new InterfaceFdnParser();
        IMOChangeRecord changeRecord = context.getChangeRecord(Interface.class);
        Set creates = changeRecord.getCreates();
        for (Interface inf : creates) {
            String fdn = interfaceFdnParser.getFdn(inf);
            inf.setFdn(fdn);
            inf.setiQIfType(Integer.valueOf(U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)inf.getIfName())));
        }
    }

    private void decodeNetAddr(Context context) {
        IMOChangeRecord ipv4ChangeRecord = context.getChangeRecord(Ipv4Address.class);
        Set ipv4Addresss = ipv4ChangeRecord.getAllChanges();
        for (Ipv4Address ipv4Address : ipv4Addresss) {
            String IpAddr = ipv4Address.getIpAddr();
            String subnetMask = ipv4Address.getSubnetMask();
            if (null == IpAddr || null == subnetMask) continue;
            ipv4Address.setNetAddr(IpAddressUtil.getNetAddress((String)IpAddr, (String)subnetMask));
        }
    }

    private void delPreDataWithOutMainIf(TETransFullSyncTranslationContext translationContext) throws VMFException {
        Context context = translationContext.getContext();
        IMOChangeRecord changeRecord = context.getChangeRecord(Interface.class);
        Set modifys = changeRecord.getModifies();
        Set deletes = changeRecord.getDeletes();
        HashMap<String, Integer> mapName = new HashMap<String, Integer>();
        for (Interface info : deletes) {
            if (info.getIfName().contains(".")) continue;
            mapName.put(info.getIfName(), info.getDevID());
        }
        for (Interface inf : modifys) {
            int iPos;
            String ifname;
            String ifParenetName;
            PropertyChangeItem item;
            if (!inf.getIfName().contains(".") || null == (item = changeRecord.getPropertyChangeItem((Object)inf, "deployStatus")) || 0 != inf.getDeployStatus() || !mapName.containsKey(ifParenetName = (ifname = inf.getIfName()).substring(iPos = ifname.indexOf(".")))) continue;
            changeRecord.cancelModify((Object)inf);
            changeRecord.addDelete((Object)inf);
        }
    }
}

