/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.l3vpn.sync;

import com.huawei.nglct.l3vpn.sync.TEITransFeatureSyncHandle;
import com.huawei.nglct.l3vpn.sync.TETransFullSyncTranslationContext;
import com.huawei.vmf.adapter.common.exception.ServiceNotAvailableException;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.dao.IRelationMeta;
import com.huawei.vmf.adapter.framework.mediation.FeatureAdapterInfo;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.syncdata.DataSyncProcessNode;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.schema.AbstractSyncTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.DefaultSchemaTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.IFeatureSchemaTranslator;
import com.huawei.vmf.adapter.framework.translation.schema.IFeatureSchemaTranslatorServiceMgr;
import com.huawei.vmf.adapter.framework.translation.schema.ISchemaTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.NodeFactory;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.common.mediation.AdapterInfo;
import com.huawei.weblct.vmf_adapter.transition.Activator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class TETransFeatureSyncHandle
implements TEITransFeatureSyncHandle {
    private Set<Class> allPersistentType;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IFeatureSchemaTranslatorServiceMgr schemaTranslatorServiceMgr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int fullSyncHandler(DataSyncProcessNode syncNode, Map<Integer, Collection<String>> syncContent, Context syncContext) {
        if (CollectionUtils.isEmpty(syncContent)) {
            return 0;
        }
        int ret = 1107497880;
        int neID = syncNode.getNeID();
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
        try {
            Map<Class<?>, Map<Object, Object>> data = this.fullSyncLoadData(dao, neID);
            syncNode.addPhaseTime("load", System.currentTimeMillis());
            TETransFullSyncTranslationContext translationContext = new TETransFullSyncTranslationContext(neID, data, dao, ctx);
            this.decode(syncContent, (DefaultSchemaTranslationContext)translationContext);
            syncNode.addPhaseTime("decode", System.currentTimeMillis());
            this.fullSyncPreProcess(translationContext);
            syncNode.addPhaseTime("preProcess", System.currentTimeMillis());
            this.cleanOtherFeatureChanges(dao, translationContext.getContext());
            this.saveData(translationContext);
            ctx.commit();
            syncNode.addPhaseTime("save", System.currentTimeMillis());
            if (syncContext != null) {
                syncContext.mergeChangeRecord(ctx);
            }
            ret = 0;
        }
        catch (VMFException e) {
            ret = e.getErrorCode();
            this.getLogger().error("full sync " + this.getFeatureName() + " fail:", (Throwable)e);
            ctx.rollback();
        }
        catch (Exception e) {
            ret = 1107497880;
            this.getLogger().error("full sync " + this.getFeatureName() + " fail:", (Throwable)e);
            ctx.rollback();
        }
        finally {
            ctx.endTransaction();
            this.fullSyncPost(ret, ctx);
            syncNode.addPhaseTime("fullSyncPost", System.currentTimeMillis());
        }
        return ret;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected final void decode(Map<Integer, Collection<String>> contents, DefaultSchemaTranslationContext translationContext) throws VMFException {
        IFeatureSchemaTranslator translator = this.findSchemaTranslator(translationContext.getDevID());
        for (Map.Entry<Integer, Collection<String>> entry : contents.entrySet()) {
            translationContext.setVrID(entry.getKey().intValue());
            List rootNodes = NodeFactory.parse(entry.getValue());
            translator.decode((Collection)rootNodes, (ISchemaTranslationContext)translationContext);
        }
    }

    protected Collection<?> fullSyncLoadData(IDao dao, Class<?> moClass, Collection<Integer> neIDs) throws VMFException {
        return dao.queryByNeID(moClass, neIDs, false);
    }

    protected Map<Class<?>, Map<Object, Object>> fullSyncLoadData(IDao dao, int neID) throws VMFException {
        Set<Class> persistentTypes = this.getAllPersistentType(dao);
        if (persistentTypes == null || persistentTypes.isEmpty()) {
            throw new IllegalArgumentException("getMoTypes not allow empty collection.");
        }
        HashMap rs = new HashMap();
        List<Integer> neIDs = Arrays.asList(neID);
        for (Class type : persistentTypes) {
            Collection<?> col = this.fullSyncLoadData(dao, type, neIDs);
            HashMap data = (HashMap)rs.get(type);
            if (data == null) {
                data = new HashMap();
                rs.put(type, data);
            }
            for (Object object : col) {
                data.put(object, object);
            }
        }
        return rs;
    }

    protected void fullSyncPost(int ret, Context ctx) {
    }

    protected void fullSyncPreProcess(TETransFullSyncTranslationContext translationContext) throws VMFException {
        HashMap deleteMoMap = new HashMap();
        Context ctx = translationContext.getContext();
        LinkedHashSet<Class<? extends VmfMO>> moTypes = this.getTopMoClasses();
        for (Class clazz : moTypes) {
            Collection<Object> aging = translationContext.getAgingData(clazz);
            if (CollectionUtils.isEmpty(aging)) continue;
            HashMap<VmfMO, VmfMO> tmpDeleteMos = new HashMap<VmfMO, VmfMO>();
            deleteMoMap.put(clazz, tmpDeleteMos);
            for (Object object : aging) {
                IMOChangeRecord changeRecord = ctx.addChangeRecord(object.getClass());
                if (object instanceof DeployableMO) {
                    this.addDeletedDeployMo((DeployableMO)object, changeRecord);
                } else {
                    changeRecord.addDelete(object);
                }
                tmpDeleteMos.put((VmfMO)object, (VmfMO)object);
            }
        }
        IDao dao = translationContext.getDao();
        LinkedList<Class<? extends VmfMO>> linkedList = new LinkedList<Class<? extends VmfMO>>(moTypes);
        while (!linkedList.isEmpty()) {
            Class parentType = (Class)linkedList.poll();
            IRelationMeta parentRelation = dao.getRelationMeta(parentType);
            Map tmpDeleteParentMos = (Map)deleteMoMap.get(parentType);
            Collection childTypes = parentRelation.getChildrenType();
            Object parentIndex = parentRelation.newInstance(parentType);
            for (Class childClass : childTypes) {
                HashMap<VmfMO, VmfMO> tmpDeleteChilds = (HashMap<VmfMO, VmfMO>)deleteMoMap.get(childClass);
                if (null == tmpDeleteChilds) {
                    tmpDeleteChilds = new HashMap<VmfMO, VmfMO>();
                    deleteMoMap.put(childClass, tmpDeleteChilds);
                }
                Collection<Object> aging = translationContext.getAgingData(childClass);
                for (Object childMo : aging) {
                    Class<?> moClass = childMo.getClass();
                    IMOChangeRecord childRecord = ctx.addChangeRecord(moClass);
                    parentRelation.setParentKeyByChildKey(parentIndex, childMo);
                    VmfMO realParentMo = null;
                    if (null != tmpDeleteParentMos) {
                        realParentMo = (VmfMO)tmpDeleteParentMos.get(parentIndex);
                    }
                    if (null != realParentMo) {
                        parentRelation.addChild((Object)realParentMo, childClass, childMo);
                    } else if (childMo instanceof DeployableMO) {
                        this.addDeletedDeployMo((DeployableMO)childMo, childRecord);
                    } else {
                        childRecord.addDelete(childMo);
                    }
                    tmpDeleteChilds.put((VmfMO)childMo, (VmfMO)childMo);
                }
            }
            linkedList.addAll(childTypes);
        }
    }

    protected final synchronized Set<Class> getAllPersistentType(IDao dao) {
        if (null == this.allPersistentType) {
            this.allPersistentType = new LinkedHashSet<Class>();
            LinkedHashSet<Class<? extends VmfMO>> moTypes = this.getTopMoClasses();
            this.allPersistentType.addAll(moTypes);
            LinkedList<Class<? extends VmfMO>> types = new LinkedList<Class<? extends VmfMO>>(moTypes);
            while (!types.isEmpty()) {
                Class moType = (Class)types.poll();
                IRelationMeta relation = dao.getRelationMeta(moType);
                Collection childTypes = relation.getChildrenType();
                this.allPersistentType.addAll(childTypes);
                types.addAll(childTypes);
            }
        }
        return this.allPersistentType;
    }

    protected final void saveData(AbstractSyncTranslationContext translationContext) throws VMFException {
        IDao dao = translationContext.getDao();
        LinkedHashSet<Class<? extends VmfMO>> moTypes = this.getTopMoClasses();
        for (Class clazz : moTypes) {
            dao.merge(clazz, true);
        }
    }

    private void addDeletedDeployMo(DeployableMO deployableMO, IMOChangeRecord changeRecord) {
        if (Integer.valueOf(0).equals(deployableMO.getDeployStatus())) {
            return;
        }
        changeRecord.addDelete((Object)deployableMO);
    }

    private void cleanOtherFeatureChanges(IDao dao, Context context) {
        Map allMOChangeRecords = context.getAllChanges();
        if (CollectionUtils.isEmpty((Map)allMOChangeRecords)) {
            return;
        }
        Set<Class> persistentTypes = this.getAllPersistentType(dao);
        Iterator iterator = allMOChangeRecords.entrySet().iterator();
        while (iterator.hasNext()) {
            if (persistentTypes.contains(iterator.next().getKey())) continue;
            iterator.remove();
        }
    }

    private IFeatureSchemaTranslator findSchemaTranslator(int neID) throws VMFException {
        try {
            return (IFeatureSchemaTranslator)this.getSchemaTranslatorServiceMgr().getAdapterService((AdapterInfo)new FeatureAdapterInfo(neID, this.getFeatureName()));
        }
        catch (com.huawei.vmf.common.exception.VMFException e) {
            throw new VMFException(e);
        }
    }

    private IFeatureSchemaTranslatorServiceMgr getSchemaTranslatorServiceMgr() throws VMFException {
        if (null == this.schemaTranslatorServiceMgr) {
            try {
                this.schemaTranslatorServiceMgr = Activator.getFeatureScheTranslatorMgr();
            }
            catch (ServiceNotAvailableException e) {
                throw new VMFException(1107498880, "get schemaTranslatorServiceMgr error.", (Throwable)e);
            }
        }
        return this.schemaTranslatorServiceMgr;
    }
}

