/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.l3vpn.sync;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.l3vpn.sync.RtnSyncImplement;
import com.huawei.vmf.adapter.framework.syncdata.DataSyncProcessNode;
import com.huawei.vmf.adapter.framework.syncdata.impl.SyncConfigInfoMgr;
import com.huawei.vmf.adapter.framework.syncdata.impl.SyncJobReceiver;
import com.huawei.vmf.adapter.fservice.sync.model.DataSyncSNNode;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class TEL3vpnIncrSyncHandler {
    private static Logger LOGGER = TELogFactory.getembededWnemgrLogger();

    public static void handleDifference(DataSyncSNNode node, long minDifference) {
        int neID = node.getNeID();
        long curDifference = node.getCurDevSerialNum() - node.getCurNMSerialNum();
        if (node.getCurNMSerialNum() == -1L) {
            LOGGER.info("device hasn't full syncrhonize yet:{}", (Object)neID);
            if (StringUtils.hasText((String)node.getProcessFailFeatureLst())) {
                LOGGER.info("last sync parse data error. not to try first full sync again. devID=" + neID);
                return;
            }
            new RtnSyncImplement().upload(neID);
        } else if (node.getCurNMSerialNum() == -2L) {
            LOGGER.info("device serial reverse syncrhonize:{}", (Object)neID);
            SyncJobReceiver.getInstance().applySyncJob(DataSyncProcessNode.createSerialReversionSyncJob((int)neID));
        } else if (curDifference > (long)SyncConfigInfoMgr.getInstance().getMaxFullSyncSNThreshold()) {
            LOGGER.info("serial has lot changed, full synchronize device:{}", (Object)neID);
            if (StringUtils.hasText((String)node.getProcessFailFeatureLst())) {
                LOGGER.info("last sync parse data error. not to try sync again. devID=" + neID);
                return;
            }
            new RtnSyncImplement().upload(neID);
        } else if (curDifference > minDifference) {
            if (StringUtils.hasText((String)node.getProcessFailFeatureLst())) {
                LOGGER.info("last sync parse data error. not to try sync again. devID=" + neID);
                return;
            }
            DataSyncProcessNode incr = DataSyncProcessNode.createIncrSyncJob((int)neID, null, (long)node.getCurDevSerialNum(), (String)node.getSerialNumInitTime());
            LOGGER.info("serial has little changed, increment synchronize device:{}", (Object)neID);
            SyncJobReceiver.getInstance().applySyncJob(incr);
        } else {
            LOGGER.info("NM has no changed:NM{}", (Object)node);
            return;
        }
    }
}

