/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.l3vpn.sync;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortDetailInfo;
import com.huawei.network.qasn.m_q_interface_op.QAsnCreatePortInfoRpt;
import com.huawei.network.qasn.m_q_interface_op.QAsnDeletePortInfoRpt;
import com.huawei.network.qasn.m_q_interface_op.QAsnPortDetailInfoChgRpt;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.event.Event;
import com.huawei.nglct.core.reliableevent.TEReliableEventHandler;
import com.huawei.nglct.l3vpn.sync.FullSyncAFeature;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruDecoder;
import net.commustru.fstru.FStruException;
import org.slf4j.Logger;

public class TEL3vpnIfmSyncHandler
extends TEReliableEventHandler {
    private static Logger LOGGER = TELogFactory.getNormalLogger();
    private static final int PORT_CHANGE_EVENT = 65670;
    private static final int PORT_CREATE_EVENT = 65667;
    private static final int PORT_DELETE_EVENT = 65668;

    public void handleEvent(Event event) {
        LOGGER.info("start process port change event!" + new Date());
        try {
            ArrayList<Integer> neIDs = new ArrayList<Integer>();
            neIDs.addAll(this.decodeNeIDs(event));
            Iterator i$ = neIDs.iterator();
            while (i$.hasNext()) {
                int neID = (Integer)i$.next();
                if (TESpecialAttrMgr.getInstance().isNESupport(neID, "TE_FUNC_CFG_NE_ATTRIBUTE", "NE_ATTR_SUPPORT_PROCESS_ONRECEIVENEMSG")) {
                    new FullSyncAFeature().upload(neID, "ifm", false);
                    continue;
                }
                LOGGER.info("this ne is not support sync ifm! neid:" + neID);
            }
        }
        catch (Exception e) {
            LOGGER.info("parse QAsnPortDetailInfoChgRpt Object failed!", (Throwable)e);
        }
        LOGGER.info("end process port change event!" + new Date());
    }

    private List<Integer> decodeNeIDs(Event event) throws FStruException {
        ArrayList<Integer> neIDs = new ArrayList<Integer>();
        switch (event.getEventID()) {
            case 65670: {
                QAsnPortDetailInfoChgRpt rpt = new QAsnPortDetailInfoChgRpt();
                rpt.deserialize((Decoder)new FStruDecoder((byte[])event.getEventContext()));
                LOGGER.info(TEAsn1Util.toAsn1String((Object)rpt));
                neIDs.addAll(this.decodeNeIDs(rpt));
                break;
            }
            case 65667: {
                QAsnCreatePortInfoRpt rpt = new QAsnCreatePortInfoRpt();
                rpt.deserialize((Decoder)new FStruDecoder((byte[])event.getEventContext()));
                LOGGER.info(TEAsn1Util.toAsn1String((Object)rpt));
                neIDs.addAll(this.decodeNeIDs(rpt));
                break;
            }
            case 65668: {
                QAsnDeletePortInfoRpt rpt = new QAsnDeletePortInfoRpt();
                rpt.deserialize((Decoder)new FStruDecoder((byte[])event.getEventContext()));
                LOGGER.info(TEAsn1Util.toAsn1String((Object)rpt));
                neIDs.addAll(this.decodeNeIDs(rpt));
                break;
            }
        }
        return neIDs;
    }

    private List<Integer> decodeNeIDs(QAsnPortDetailInfoChgRpt rpt) {
        ArrayList<Integer> neIDs = new ArrayList<Integer>();
        for (QAsnPortDetailInfo portInfo : rpt.portInfoList) {
            neIDs.add(portInfo.portIndex.neID);
        }
        return neIDs;
    }

    private List<Integer> decodeNeIDs(QAsnCreatePortInfoRpt rpt) {
        ArrayList<Integer> neIDs = new ArrayList<Integer>();
        for (QAsnUniResID portInfo : rpt.portInfoList) {
            neIDs.add(portInfo.neID);
        }
        return neIDs;
    }

    private List<Integer> decodeNeIDs(QAsnDeletePortInfoRpt rpt) {
        ArrayList<Integer> neIDs = new ArrayList<Integer>();
        for (QAsnUniResID portInfo : rpt.portIndexList) {
            neIDs.add(portInfo.neID);
        }
        return neIDs;
    }
}

