/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.l3vpn.sync;

import com.huawei.nglct.l3vpn.sync.TEITransFeatureSyncHandle;
import com.huawei.nglct.l3vpn.sync.TETransFullSyncNode;
import com.huawei.nglct.l3vpn.sync.impl.TETransBgpSyncHandler;
import com.huawei.nglct.l3vpn.sync.impl.TETransDefaultFeatureSyncHandler;
import com.huawei.nglct.l3vpn.sync.impl.TETransInterfaceSyncHandler;
import com.huawei.nglct.l3vpn.sync.impl.TETransIsisSyncHandler;
import com.huawei.nglct.l3vpn.sync.impl.TETransL3vpnSyncHandler;
import com.huawei.nglct.l3vpn.sync.impl.TETransStaticRouteSyncHandler;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.uflight.ProcessInfoHelper;
import com.huawei.vmf.adapter.framework.model.MOAdditionalInfoMgr;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.syncdata.DataSyncProcessNode;
import com.huawei.vmf.adapter.framework.syncdata.SyncNodeInfoMgr;
import com.huawei.vmf.adapter.framework.syncdata.impl.SerialNumMgr;
import com.huawei.vmf.adapter.framework.syncdata.impl.SyncFeatureInfoMgr;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevTypeInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.fservice.sync.model.DataSyncSNNode;
import com.huawei.vmf.common.tool.PlatformCipherTool;
import com.huawei.vmf.common.tool.StringUtil;
import com.huawei.vmf.netconf.datadefination.OperationArg;
import com.huawei.vmf.netconf.datadefination.ReqCmd;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.FilterType;
import com.huawei.vmf.netconf.service.INetconfClient;
import com.huawei.vmf.netconf.service.IRpc;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.service.NetconfClientFactory;
import com.huawei.weblct.vmf_adapter.transition.Activator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RtnSyncImplement {
    private static Logger logger = LoggerFactory.getLogger(RtnSyncImplement.class);
    public static final String MEDIATION_BUNDLE_PATH = ProcessInfoHelper.BUNDLE_PATH + File.separator + "com.huawei.vmf.adapter.mediation";
    public static final String MEDIATION_SYNC_DIR = MEDIATION_BUNDLE_PATH + File.separator + "conf" + File.separator + "SyncFeatureInfo";
    private static final Pattern VERSION_RE = Pattern.compile("^V[\\d]{3}R[\\d]{3}C[\\d]{2}[\\w]*", 2);
    private static final int RELEASE_VERSION_LENGTH = 11;
    private static final Map<String, TEITransFeatureSyncHandle> featureSyncHandleMap = new HashMap<String, TEITransFeatureSyncHandle>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void upload(int devID) {
        Map<String, Map<Integer, Collection<String>>> featureDatas;
        IRpcReply rpcReply = this.notifySyncFull(devID);
        if (!rpcReply.isOK()) {
            logger.error("notify full sync failed, so don't execute upload all! result:" + rpcReply.getContent());
        }
        if ((featureDatas = this.getSynFeatureDatas(devID)).isEmpty()) {
            logger.error("RtnSyncImplement upload(int devID) the feature Datas from the device is null");
            return;
        }
        ArrayList<String> syncFeatures = new ArrayList<String>();
        syncFeatures.add("bgp");
        syncFeatures.add("isiscomm");
        syncFeatures.add("staticrt");
        syncFeatures.add("tnlm");
        syncFeatures.add("l3vpn");
        syncFeatures.add("rtp");
        syncFeatures.add("rm");
        syncFeatures.add("ifm");
        syncFeatures.add("bfd");
        TETransFullSyncNode dataSyncProcessNode = new TETransFullSyncNode(devID, syncFeatures);
        logger.info("SyncDataProcessorActionAdapter process begin neID=" + devID);
        if (syncFeatures.isEmpty()) {
            logger.error("no synchronize features info, devID={}", (Object)devID);
            return;
        }
        DataSyncSNNode dataSyncSNNode = SyncNodeInfoMgr.getInstance().getDataSyncSNNode(devID);
        if (dataSyncSNNode == null) {
            dataSyncSNNode = new DataSyncSNNode(devID);
            SyncNodeInfoMgr.getInstance().addSyncNodeInfo(dataSyncSNNode);
            logger.info("add an new sync node form upload", (Object)devID);
        }
        long start = System.currentTimeMillis();
        int ret = 0;
        String detail = null;
        IDeviceService service = null;
        Context changeCollector = new Context();
        try {
            service = Activator.getDeviceService();
            service.lockDevice(devID);
            Iterator it = syncFeatures.iterator();
            int progressUnit = 38 / syncFeatures.size();
            while (it.hasNext()) {
                String featureName = (String)it.next();
                logger.debug("sync feature is " + featureName);
                Map<Integer, Collection<String>> featureSyncContents = featureDatas.get(featureName);
                if (CollectionUtils.isEmpty(featureSyncContents)) {
                    logger.info("feature data is empty. featureName=" + featureName + ", devId=" + devID);
                    continue;
                }
                TEITransFeatureSyncHandle featureSyncHandler = this.getFeatrueSyncHandle(featureName);
                ret = featureSyncHandler.fullSyncHandler(dataSyncProcessNode, featureSyncContents, changeCollector);
                if (0 != ret) {
                    logger.error("Feature SyncDataProcessor fail, devId=" + devID + ", FeaturName=" + featureName + ", featureSyncHandler=" + featureSyncHandler.getClass().getName());
                    ret = 1107497880;
                    continue;
                }
                if (0 != ret) break;
                dataSyncProcessNode.setProgress(dataSyncProcessNode.getProgress() + (double)progressUnit);
                it.remove();
            }
        }
        catch (VMFException e) {
            logger.error("Error occurs , device=" + devID, (Throwable)e);
            ret = e.getErrorCode();
            detail = e.getErrorMessage();
            if (!changeCollector.getAllChanges().isEmpty() && !dataSyncSNNode.isFirstSync()) {
                changeCollector.getAllChanges().remove(Interface.class);
                logger.error("Begin notify changes of full-sync " + changeCollector);
                MOChangePublisher.getInstance().notifyChanges(changeCollector);
                logger.error("End notify changes of full-sync " + changeCollector);
            }
            if (service != null) {
                service.unlockDevice(devID);
            }
            this.postProcess(dataSyncSNNode, dataSyncProcessNode, syncFeatures, ret, detail);
            logger.info("SyncDataProcessorActionAdapter process end:[neID={}, result={}, elapse={}(ms)]", new Object[]{devID, ret, System.currentTimeMillis() - start});
        }
        catch (Exception e2) {
            logger.error("Error occurs when internal exception, device=" + devID, (Throwable)e2);
            ret = 1107498880;
            {
                catch (Throwable throwable) {
                    if (!changeCollector.getAllChanges().isEmpty() && !dataSyncSNNode.isFirstSync()) {
                        changeCollector.getAllChanges().remove(Interface.class);
                        logger.error("Begin notify changes of full-sync " + changeCollector);
                        MOChangePublisher.getInstance().notifyChanges(changeCollector);
                        logger.error("End notify changes of full-sync " + changeCollector);
                    }
                    if (service != null) {
                        service.unlockDevice(devID);
                    }
                    this.postProcess(dataSyncSNNode, dataSyncProcessNode, syncFeatures, ret, detail);
                    logger.info("SyncDataProcessorActionAdapter process end:[neID={}, result={}, elapse={}(ms)]", new Object[]{devID, ret, System.currentTimeMillis() - start});
                    throw throwable;
                }
            }
            if (!changeCollector.getAllChanges().isEmpty() && !dataSyncSNNode.isFirstSync()) {
                changeCollector.getAllChanges().remove(Interface.class);
                logger.error("Begin notify changes of full-sync " + changeCollector);
                MOChangePublisher.getInstance().notifyChanges(changeCollector);
                logger.error("End notify changes of full-sync " + changeCollector);
            }
            if (service != null) {
                service.unlockDevice(devID);
            }
            this.postProcess(dataSyncSNNode, dataSyncProcessNode, syncFeatures, ret, detail);
            logger.info("SyncDataProcessorActionAdapter process end:[neID={}, result={}, elapse={}(ms)]", new Object[]{devID, ret, System.currentTimeMillis() - start});
        }
        if (!changeCollector.getAllChanges().isEmpty() && !dataSyncSNNode.isFirstSync()) {
            changeCollector.getAllChanges().remove(Interface.class);
            logger.error("Begin notify changes of full-sync " + changeCollector);
            MOChangePublisher.getInstance().notifyChanges(changeCollector);
            logger.error("End notify changes of full-sync " + changeCollector);
        }
        if (service != null) {
            service.unlockDevice(devID);
        }
        this.postProcess(dataSyncSNNode, dataSyncProcessNode, syncFeatures, ret, detail);
        logger.info("SyncDataProcessorActionAdapter process end:[neID={}, result={}, elapse={}(ms)]", new Object[]{devID, ret, System.currentTimeMillis() - start});
    }

    private DevTypeInfo getDevTypeInfo(int devID) {
        IDeviceService deviceSrv = Activator.getDeviceService();
        DevTypeInfo devInfo = null;
        try {
            devInfo = deviceSrv.getDevTypeAndVersion(devID);
        }
        catch (VMFException e) {
            logger.error("getDevTypeInfo() VMFException ", (Throwable)e);
        }
        return devInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContents(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            logger.error("the file " + filePath + "is not exist.");
            return null;
        }
        BufferedReader reader = null;
        StringBuffer contents = new StringBuffer();
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            if (reader != null) {
                String line = reader.readLine();
                while (line != null) {
                    contents.append("\n").append(line);
                    line = reader.readLine();
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("getContents() FileNotFoundException: file is " + filePath, (Throwable)e);
        }
        catch (IOException e) {
            logger.error("getContents() IOException: file is " + filePath, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("getContents() fail: file is " + filePath, (Throwable)e);
                }
            }
        }
        if (!contents.toString().equals("")) {
            return contents.toString().trim();
        }
        return null;
    }

    private String regularDevType(String devType) {
        String tmpDevType = devType.replace("(V8)", "");
        if ((tmpDevType = tmpDevType.replaceAll("\\W", "_")).matches("^[\\d]+[\\w]*")) {
            tmpDevType = "_" + tmpDevType;
        }
        return StringUtil.toDefaultLocaleLowerCase((String)tmpDevType);
    }

    private String regularProductVersion(String productVersion) {
        if (null == productVersion || !VERSION_RE.matcher(productVersion).matches()) {
            return "";
        }
        return productVersion.substring(0, 11).toLowerCase();
    }

    private void postProcess(DataSyncSNNode dataSyncSNNode, DataSyncProcessNode dataSyncProcessNode, List<String> failFeatures, int ret, String detail) {
        DataSyncSNNode neSerial = null;
        if (ret == 0 && dataSyncProcessNode.needUpdateSerialNum()) {
            try {
                neSerial = SerialNumMgr.querySerialNumFromNE((int)dataSyncSNNode.getNeID());
                dataSyncSNNode.setCurNMSerialNum(neSerial.getCurDevSerialNum());
            }
            catch (VMFException e) {
                logger.error("query new serial num failed!", (Throwable)e);
            }
        }
        String fails = SyncFeatureInfoMgr.serializeFeatures(failFeatures);
        dataSyncSNNode.setProcessFailFeatureLst(fails);
        if (dataSyncProcessNode.needUpdateSerialNum() && neSerial != null) {
            SerialNumMgr.updateCurDevSerialNum((DataSyncSNNode)dataSyncSNNode, (long)neSerial.getCurDevSerialNum(), (String)neSerial.getSerialNumInitTime());
            SyncNodeInfoMgr.getInstance().updateSyncNodeInfo(dataSyncSNNode);
        }
        if (ret != 0) {
            dataSyncProcessNode.setProcessResult(ret, detail, 100.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getFeatureDataFromDevice(String pathFile, String featureFile, String devIP, int devID) {
        ArrayList<String> resConts = new ArrayList<String>();
        String content = this.getContents(pathFile + File.separator + featureFile);
        INetconfClient client = NetconfClientFactory.getNetconfClient((int)devID, (String)"SyncData", (String)devIP, (boolean)true, null);
        try {
            IRpcReply reply = client.get(FilterType.SUBTREE, content, content, true);
            resConts.add(reply.getContent());
            for (IRpcReply nextPackage : reply.getPackages()) {
                if (null == nextPackage) continue;
                resConts.add(nextPackage.getContent());
            }
            ArrayList<String> arrayList = resConts;
            return arrayList;
        }
        catch (NetconfException e) {
            logger.error("getFeatureDataFromDevice fail:", (Throwable)e);
        }
        finally {
            NetconfClientFactory.close((INetconfClient)client);
        }
        return resConts;
    }

    private Map<String, Map<Integer, Collection<String>>> getSynFeatureDatas(int devID) {
        String devIP = "";
        DevTypeInfo devInfo = this.getDevTypeInfo(devID);
        String pathFile = MEDIATION_SYNC_DIR + File.separator + this.regularDevType(devInfo.getDevTypeName()) + File.separator + this.regularProductVersion(devInfo.getDevVersionName()) + File.separator + "syncInfo";
        HashMap<String, Map<Integer, Collection<String>>> featureDatas = new HashMap<String, Map<Integer, Collection<String>>>();
        List<String> bgpContents = this.getFeatureDataFromDevice(pathFile, "bgp.xml", devIP, devID);
        ArrayList<String> collection = new ArrayList<String>();
        HashMap<Integer, ArrayList<String>> mapFeature = new HashMap<Integer, ArrayList<String>>();
        collection.addAll(bgpContents);
        mapFeature.put(0, collection);
        featureDatas.put("bgp", mapFeature);
        List<String> isisCommContents = this.getFeatureDataFromDevice(pathFile, "isiscomm.xml", devIP, devID);
        ArrayList<String> isiscollection = new ArrayList<String>();
        HashMap<Integer, ArrayList<String>> isismapFeature = new HashMap<Integer, ArrayList<String>>();
        isiscollection.addAll(isisCommContents);
        isismapFeature.put(0, isiscollection);
        featureDatas.put("isiscomm", isismapFeature);
        List<String> staticrtContents = this.getFeatureDataFromDevice(pathFile, "staticrt.xml", devIP, devID);
        ArrayList<String> staticrtcollection = new ArrayList<String>();
        HashMap<Integer, ArrayList<String>> staticrtmapFeature = new HashMap<Integer, ArrayList<String>>();
        staticrtcollection.addAll(staticrtContents);
        staticrtmapFeature.put(0, staticrtcollection);
        featureDatas.put("staticrt", staticrtmapFeature);
        List<String> tnlmContents = this.getFeatureDataFromDevice(pathFile, "tnlm.xml", devIP, devID);
        ArrayList<String> tnlmcollection = new ArrayList<String>();
        HashMap<Integer, ArrayList<String>> tnlmmapFeature = new HashMap<Integer, ArrayList<String>>();
        tnlmcollection.addAll(tnlmContents);
        tnlmmapFeature.put(0, tnlmcollection);
        featureDatas.put("tnlm", tnlmmapFeature);
        List<String> l3vpnContents = this.getFeatureDataFromDevice(pathFile, "l3vpn.xml", devIP, devID);
        ArrayList<String> l3vpncollection = new ArrayList<String>();
        HashMap<Integer, ArrayList<String>> l3vpnmapFeature = new HashMap<Integer, ArrayList<String>>();
        l3vpncollection.addAll(l3vpnContents);
        l3vpnmapFeature.put(0, l3vpncollection);
        featureDatas.put("l3vpn", l3vpnmapFeature);
        List<String> rtpContents = this.getFeatureDataFromDevice(pathFile, "rtp.xml", devIP, devID);
        ArrayList<String> rtpcollection = new ArrayList<String>();
        HashMap<Integer, ArrayList<String>> rtpmapFeature = new HashMap<Integer, ArrayList<String>>();
        rtpcollection.addAll(rtpContents);
        rtpmapFeature.put(0, rtpcollection);
        featureDatas.put("rtp", rtpmapFeature);
        List<String> rmContents = this.getFeatureDataFromDevice(pathFile, "rm.xml", devIP, devID);
        ArrayList<String> rmcollection = new ArrayList<String>();
        HashMap<Integer, ArrayList<String>> rmmapFeature = new HashMap<Integer, ArrayList<String>>();
        rmcollection.addAll(rmContents);
        rmmapFeature.put(0, rmcollection);
        featureDatas.put("rm", rmmapFeature);
        List<String> ifmContents = this.getFeatureDataFromDevice(pathFile, "ifm.xml", devIP, devID);
        ArrayList<String> ifmcollection = new ArrayList<String>();
        HashMap<Integer, ArrayList<String>> ifmmapFeature = new HashMap<Integer, ArrayList<String>>();
        ifmcollection.addAll(ifmContents);
        ifmmapFeature.put(0, ifmcollection);
        featureDatas.put("ifm", ifmmapFeature);
        List<String> bfdContents = this.getFeatureDataFromDevice(pathFile, "bfd.xml", devIP, devID);
        ArrayList<String> bfdcollection = new ArrayList<String>();
        HashMap<Integer, ArrayList<String>> bfdmapFeature = new HashMap<Integer, ArrayList<String>>();
        bfdcollection.addAll(bfdContents);
        bfdmapFeature.put(0, bfdcollection);
        featureDatas.put("bfd", bfdmapFeature);
        return featureDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRpcReply notifySyncFull(int neID) {
        INetconfClient client = NetconfClientFactory.getNetconfClient((int)neID, (String)"full sync notify", (String)"", (boolean)true, null);
        IRpcReply rpcReply = null;
        try {
            ReqCmd req = new ReqCmd(null, (OperationArg)new NotifySyncFullArg(neID), false);
            rpcReply = client.execute((IRpc)req);
        }
        catch (NetconfException e) {
            logger.error("notify sync full failed!", (Throwable)e);
        }
        finally {
            NetconfClientFactory.close((INetconfClient)client);
        }
        return rpcReply;
    }

    private TEITransFeatureSyncHandle getFeatrueSyncHandle(String featureName) {
        FeatureName featureNameEnum = FeatureName.getFeatureName((String)featureName);
        Set featureTopMoClasses = MOAdditionalInfoMgr.getInstance().getFeatureTopMoClasses(featureNameEnum);
        TEITransFeatureSyncHandle featureExtSyncHandler = featureSyncHandleMap.get(featureName);
        if (featureExtSyncHandler != null) {
            return featureExtSyncHandler;
        }
        LinkedHashSet<Class<? extends VmfMO>> tmpFeatureTopMoClasses = new LinkedHashSet<Class<? extends VmfMO>>(featureTopMoClasses);
        TETransDefaultFeatureSyncHandler featureSyncHandler = new TETransDefaultFeatureSyncHandler(featureNameEnum, tmpFeatureTopMoClasses);
        return featureSyncHandler;
    }

    static {
        featureSyncHandleMap.put("bgp", new TETransBgpSyncHandler());
        featureSyncHandleMap.put("isiscomm", new TETransIsisSyncHandler());
        featureSyncHandleMap.put("staticrt", new TETransStaticRouteSyncHandler());
        featureSyncHandleMap.put("l3vpn", new TETransL3vpnSyncHandler());
        featureSyncHandleMap.put("ifm", new TETransInterfaceSyncHandler());
    }

    private class NotifySyncFullArg
    extends OperationArg {
        private String ip = "123.123.123.123";
        private String port = "21";

        public NotifySyncFullArg(int neID) {
        }

        public NotifySyncFullArg(String ip, String port) {
            this.ip = ip;
            this.port = port;
        }

        public String toCommand() throws NetconfException {
            StringBuilder buf = new StringBuilder("<sync-full xmlns=\"");
            buf.append("http://www.huawei.com/netconf/capability/base/1.0");
            buf.append("\"><target>");
            buf.append("<user-name>").append(TESysManagerBean.getInstance().getSysUser()).append("</user-name>");
            buf.append("<password>").append(PlatformCipherTool.markPwd((String)PlatformCipherTool.encrypt((byte[])TESysManagerBean.getInstance().getlanguage().getBytes()))).append("</password>");
            buf.append("<target-addr>").append(this.ip).append(':').append(this.port).append("</target-addr>");
            buf.append("</target>");
            buf.append("<filename-prefix>2</filename-prefix>");
            buf.append("</sync-full>");
            return buf.toString();
        }
    }
}

