/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.l3vpn.sync;

import com.huawei.nglct.l3vpn.sync.TEITransFeatureSyncHandle;
import com.huawei.nglct.l3vpn.sync.TETransFullSyncNode;
import com.huawei.nglct.l3vpn.sync.impl.TETransBgpSyncHandler;
import com.huawei.nglct.l3vpn.sync.impl.TETransDefaultFeatureSyncHandler;
import com.huawei.nglct.l3vpn.sync.impl.TETransInterfaceSyncHandler;
import com.huawei.nglct.l3vpn.sync.impl.TETransIsisSyncHandler;
import com.huawei.nglct.l3vpn.sync.impl.TETransL3vpnSyncHandler;
import com.huawei.nglct.l3vpn.sync.impl.TETransStaticRouteSyncHandler;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.uflight.ProcessInfoHelper;
import com.huawei.vmf.adapter.framework.model.MOAdditionalInfoMgr;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevTypeInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.common.tool.StringUtil;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.FilterType;
import com.huawei.vmf.netconf.service.INetconfClient;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.service.NetconfClientFactory;
import com.huawei.weblct.vmf_adapter.transition.Activator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class FullSyncAFeature {
    private static Logger logger = LoggerFactory.getLogger(FullSyncAFeature.class);
    public static final String MEDIATION_BUNDLE_PATH = ProcessInfoHelper.BUNDLE_PATH + File.separator + "com.huawei.vmf.adapter.mediation";
    public static final String MEDIATION_SYNC_DIR = MEDIATION_BUNDLE_PATH + File.separator + "conf" + File.separator + "SyncFeatureInfo";
    private static final Pattern VERSION_RE = Pattern.compile("^V[\\d]{3}R[\\d]{3}C[\\d]{2}[\\w]*", 2);
    private static final int RELEASE_VERSION_LENGTH = 11;
    private static final Map<String, TEITransFeatureSyncHandle> featureSyncHandleMap = new HashMap<String, TEITransFeatureSyncHandle>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void upload(int devID, String featureName, boolean needRpt) {
        block20: {
            IDeviceService service;
            int ret;
            long start;
            block18: {
                Context changeCollector;
                TETransFullSyncNode dataSyncProcessNode;
                Map<Integer, Collection<String>> featureDatas;
                block16: {
                    block17: {
                        featureDatas = this.getSynFeatureDatas(devID, featureName);
                        if (featureDatas.isEmpty()) {
                            logger.error("RtnSyncImplement upload(int devID) the feature Datas from the device is null");
                            return;
                        }
                        ArrayList<String> syncFeatures = new ArrayList<String>();
                        syncFeatures.add(featureName);
                        dataSyncProcessNode = new TETransFullSyncNode(devID, syncFeatures);
                        logger.info("Sync a feature begin neID=" + devID);
                        if (syncFeatures.isEmpty()) {
                            logger.error("no synchronize features info, devID={}", (Object)devID);
                            return;
                        }
                        start = System.currentTimeMillis();
                        ret = 0;
                        service = null;
                        changeCollector = new Context();
                        service = Activator.getDeviceService();
                        service.lockDevice(devID);
                        logger.debug("sync feature is " + featureName);
                        if (!CollectionUtils.isEmpty(featureDatas)) break block16;
                        logger.info("feature data is empty. featureName=" + featureName + ", devId=" + devID);
                        if (changeCollector.getAllChanges().isEmpty() || !needRpt) break block17;
                        logger.error("Begin notify changes of full-sync-one feature" + changeCollector);
                        MOChangePublisher.getInstance().notifyChanges(changeCollector);
                        logger.error("End notify changes of full-sync-one feature" + changeCollector);
                    }
                    if (service != null) {
                        service.unlockDevice(devID);
                    }
                    logger.info("SyncDataProcessorActionAdapter process end:[neID={}, result={}, elapse={}(ms)]", new Object[]{devID, ret, System.currentTimeMillis() - start});
                    return;
                }
                try {
                    TEITransFeatureSyncHandle featureSyncHandler = this.getFeatrueSyncHandle(featureName);
                    ret = featureSyncHandler.fullSyncHandler(dataSyncProcessNode, featureDatas, changeCollector);
                    if (0 != ret) {
                        logger.error("Feature SyncDataProcessor fail, devId=" + devID + ", FeaturName=" + featureName + ", featureSyncHandler=" + featureSyncHandler.getClass().getName());
                        ret = 1107497880;
                    }
                    if (changeCollector.getAllChanges().isEmpty() || !needRpt) break block18;
                }
                catch (VMFException e) {
                    block19: {
                        logger.error("Error occurs , device=" + devID, (Throwable)e);
                        ret = e.getErrorCode();
                        if (changeCollector.getAllChanges().isEmpty() || !needRpt) break block19;
                        logger.error("Begin notify changes of full-sync-one feature" + changeCollector);
                        MOChangePublisher.getInstance().notifyChanges(changeCollector);
                        logger.error("End notify changes of full-sync-one feature" + changeCollector);
                    }
                    if (service != null) {
                        service.unlockDevice(devID);
                    }
                    logger.info("SyncDataProcessorActionAdapter process end:[neID={}, result={}, elapse={}(ms)]", new Object[]{devID, ret, System.currentTimeMillis() - start});
                    break block20;
                }
                catch (Exception e2) {
                    block21: {
                        logger.error("Error occurs when internal exception, device=" + devID, (Throwable)e2);
                        ret = 1107498880;
                        if (changeCollector.getAllChanges().isEmpty() || !needRpt) break block21;
                        {
                            catch (Throwable throwable) {
                                if (!changeCollector.getAllChanges().isEmpty() && needRpt) {
                                    logger.error("Begin notify changes of full-sync-one feature" + changeCollector);
                                    MOChangePublisher.getInstance().notifyChanges(changeCollector);
                                    logger.error("End notify changes of full-sync-one feature" + changeCollector);
                                }
                                if (service != null) {
                                    service.unlockDevice(devID);
                                }
                                logger.info("SyncDataProcessorActionAdapter process end:[neID={}, result={}, elapse={}(ms)]", new Object[]{devID, ret, System.currentTimeMillis() - start});
                                throw throwable;
                            }
                        }
                        logger.error("Begin notify changes of full-sync-one feature" + changeCollector);
                        MOChangePublisher.getInstance().notifyChanges(changeCollector);
                        logger.error("End notify changes of full-sync-one feature" + changeCollector);
                    }
                    if (service != null) {
                        service.unlockDevice(devID);
                    }
                    logger.info("SyncDataProcessorActionAdapter process end:[neID={}, result={}, elapse={}(ms)]", new Object[]{devID, ret, System.currentTimeMillis() - start});
                }
                logger.error("Begin notify changes of full-sync-one feature" + changeCollector);
                MOChangePublisher.getInstance().notifyChanges(changeCollector);
                logger.error("End notify changes of full-sync-one feature" + changeCollector);
            }
            if (service != null) {
                service.unlockDevice(devID);
            }
            logger.info("SyncDataProcessorActionAdapter process end:[neID={}, result={}, elapse={}(ms)]", new Object[]{devID, ret, System.currentTimeMillis() - start});
        }
    }

    private DevTypeInfo getDevTypeInfo(int devID) {
        IDeviceService deviceSrv = Activator.getDeviceService();
        DevTypeInfo devInfo = null;
        try {
            devInfo = deviceSrv.getDevTypeAndVersion(devID);
        }
        catch (VMFException e) {
            logger.error("getDevTypeInfo() VMFException ", (Throwable)e);
        }
        return devInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContents(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            logger.error("the file " + filePath + "is not exist.");
            return null;
        }
        BufferedReader reader = null;
        StringBuffer contents = new StringBuffer();
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            if (reader != null) {
                String line = reader.readLine();
                while (line != null) {
                    contents.append("\n").append(line);
                    line = reader.readLine();
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("getContents() FileNotFoundException: file is " + filePath, (Throwable)e);
        }
        catch (IOException e) {
            logger.error("getContents() IOException: file is " + filePath, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("getContents() fail: file is " + filePath, (Throwable)e);
                }
            }
        }
        return contents.toString().trim();
    }

    private String regularDevType(String devType) {
        String tmpDevType = devType.replace("(V8)", "");
        if ((tmpDevType = tmpDevType.replaceAll("\\W", "_")).matches("^[\\d]+[\\w]*")) {
            tmpDevType = "_" + tmpDevType;
        }
        return StringUtil.toDefaultLocaleLowerCase((String)tmpDevType);
    }

    private String regularProductVersion(String productVersion) {
        if (null == productVersion || !VERSION_RE.matcher(productVersion).matches()) {
            return "";
        }
        return productVersion.substring(0, 11).toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getFeatureDataFromDevice(String pathFile, String featureFile, String devIP, int devID) {
        ArrayList<String> resConts = new ArrayList<String>();
        String content = this.getContents(pathFile + File.separator + featureFile);
        INetconfClient client = NetconfClientFactory.getNetconfClient((int)devID, (String)"SyncData", (String)devIP, (boolean)true, null);
        try {
            IRpcReply reply = client.get(FilterType.SUBTREE, content, content, true);
            resConts.add(reply.getContent());
            for (IRpcReply nextPackage : reply.getPackages()) {
                if (null == nextPackage) continue;
                resConts.add(nextPackage.getContent());
            }
            ArrayList<String> arrayList = resConts;
            return arrayList;
        }
        catch (NetconfException e) {
            logger.error("getFeatureDataFromDevice fail:", (Throwable)e);
        }
        finally {
            NetconfClientFactory.close((INetconfClient)client);
        }
        return resConts;
    }

    private Map<Integer, Collection<String>> getSynFeatureDatas(int devID, String featureName) {
        String devIP = "";
        DevTypeInfo devInfo = this.getDevTypeInfo(devID);
        String pathFile = MEDIATION_SYNC_DIR + File.separator + this.regularDevType(devInfo.getDevTypeName()) + File.separator + this.regularProductVersion(devInfo.getDevVersionName()) + File.separator + "syncInfo";
        HashMap<Integer, Collection<String>> featureDatas = new HashMap<Integer, Collection<String>>();
        List<String> tempConts = this.getFeatureDataFromDevice(pathFile, featureName + ".xml", devIP, devID);
        if (!tempConts.isEmpty()) {
            ArrayList<String> collection = new ArrayList<String>();
            collection.addAll(tempConts);
            featureDatas.put(0, collection);
        } else {
            logger.error("RtnSyncImplement get BGP schema info is null!");
        }
        return featureDatas;
    }

    private TEITransFeatureSyncHandle getFeatrueSyncHandle(String featureName) {
        FeatureName featureNameEnum = FeatureName.getFeatureName((String)featureName);
        Set featureTopMoClasses = MOAdditionalInfoMgr.getInstance().getFeatureTopMoClasses(featureNameEnum);
        TEITransFeatureSyncHandle featureExtSyncHandler = featureSyncHandleMap.get(featureName);
        if (featureExtSyncHandler != null) {
            return featureExtSyncHandler;
        }
        LinkedHashSet<Class<? extends VmfMO>> tmpFeatureTopMoClasses = new LinkedHashSet<Class<? extends VmfMO>>(featureTopMoClasses);
        TETransDefaultFeatureSyncHandler featureSyncHandler = new TETransDefaultFeatureSyncHandler(featureNameEnum, tmpFeatureTopMoClasses);
        return featureSyncHandler;
    }

    static {
        featureSyncHandleMap.put("bgp", new TETransBgpSyncHandler());
        featureSyncHandleMap.put("isiscomm", new TETransIsisSyncHandler());
        featureSyncHandleMap.put("staticrt", new TETransStaticRouteSyncHandler());
        featureSyncHandleMap.put("l3vpn", new TETransL3vpnSyncHandler());
        featureSyncHandleMap.put("ifm", new TETransInterfaceSyncHandler());
    }
}

