/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.trans.nglct.impl;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.session.LCTSession;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.vmtacc.LctIpProvider;
import com.huawei.vmf.extendpoint.framework.ISessionFactory;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.session.ISession;
import java.util.Hashtable;

public class TransSessionFactory
implements ISessionFactory {
    private String devIP;
    private boolean shared;
    private int devID = -1;
    private static Hashtable<Integer, ISession> sessionPool = new Hashtable();

    public TransSessionFactory(String devIP, Boolean shared) {
        this.devIP = devIP;
        this.shared = shared;
    }

    public TransSessionFactory() {
    }

    public ISession GetSession(Integer devID, String devIP, Boolean shared) {
        ISession session;
        this.devIP = devIP;
        this.shared = shared;
        this.devID = devID;
        try {
            int tempNeID = devID <= 0 ? LctIpProvider.getInstance().getNeIdByIdentityIp(this.devIP) : this.devID;
            session = sessionPool.get(tempNeID);
            if (session == null) {
                session = devID <= 0 ? new LCTSession(this.devIP) : new LCTSession(devID, devIP);
                sessionPool.put(tempNeID, session);
                TELogFactory.getNormalLogger().info("new session for ne " + tempNeID);
            }
            ((LCTSession)session).setE2EFlg(devID > 0);
        }
        catch (NetconfException e) {
            TELogFactory.getNormalLogger().error("get session failed!", (Throwable)e);
            session = null;
        }
        return session;
    }

    public int getConnectStatus(Integer devID) {
        if (null == devID || devID == -1) {
            return -1;
        }
        if (TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(devID.intValue())) {
            return 0;
        }
        return -1;
    }

    public static void clearSession(int neID) {
        sessionPool.remove(neID);
        TELogFactory.getNormalLogger().info("remove session for ne " + neID);
    }
}

