/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.trans.nglct.impl;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.mpls.rsvptunnel.mooperation.TERsvpTunnelDBMgr;
import com.huawei.nglct.po.embeddednemgrmo.rtn.rsvp.TEDynTunnelObjMOPO;
import com.huawei.nglct.po.embeddednemgrmo.rtn.rsvp.TEDynamicTunnelMoContainer;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.vmf.extendpoint.framework.ISwitchPortName;
import com.huawei.vmf.extendpoint.framework.ISwitchTunnelName;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;

public class TETransSwitchName
implements ISwitchPortName,
ISwitchTunnelName {
    private static final String GE_PORT_PFIX = "GigabitEthernet";
    private static final String FE_PORT_PFIX = "Ethernet";
    private static final String NM_TUNNEL_REG = "^[0-9]+$";
    private static final String TUNNEL_PRIX = "Tunnel";
    private static Logger logger = TELogFactory.getNormalLogger();
    private static final int VLAN_PORT_GAP = 10240;
    private static final String UN_LOGIN = "37889;37926;37126";
    private static final int NE_LEVEL_PTN_GE = 6;

    public String convertToVrpPortName(int neID, int slotID, int subCard, int port) {
        String preFix = this.isGEPortLevel(neID, slotID, port) ? GE_PORT_PFIX : FE_PORT_PFIX;
        return preFix + slotID + "/0/" + port;
    }

    public StrUIDFactory convertToPortFdnByDomain(int neID, int slotID, int port) {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)neID);
        factory.append("S", (long)slotID);
        factory.append("CP", -1L);
        StrLinker linker = new StrLinker();
        linker.append("16");
        linker.append("");
        linker.append((long)port);
        linker.append("");
        factory.append("PP", linker.getStr());
        return factory;
    }

    public StrUIDFactory convertToPortFdnByDomain(int neID, int vrID, int port, String ifName) {
        String VMT_TUNNEL_REG = "^Tunnel[0-9]+$";
        StrUIDFactory factory = null;
        if (ifName.matches("^Tunnel[0-9]+$")) {
            factory = this.getTunnelFdnStrUIDFactory(neID, vrID, ifName);
        }
        return factory;
    }

    public String convertToVrpVlanSubPortName(int neID, long vport) {
        StringBuilder portName = new StringBuilder();
        int vlanSubPort = 10240 + (int)vport;
        logger.info("the vport is " + vport);
        int[] portAttr = this.getMacSlotAndPort(neID, vlanSubPort);
        if (portAttr == null || portAttr[0] == 0 && portAttr[1] == 0) {
            logger.info("query mac port attr failed!" + vport);
            return portName.toString();
        }
        portName.append(this.convertToVrpPortName(neID, portAttr[0], 0, portAttr[1]));
        portName.append(".").append(vlanSubPort);
        return portName.toString();
    }

    private int[] getMacSlotAndPort(int neID, int vport) {
        int[] res = new int[2];
        Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_ETHN_PORT_GET_VLAN_VPORT");
        oper.getInput().setPartValue("port", String.valueOf(vport));
        ArrayList<Operation> opers = new ArrayList<Operation>();
        opers.add(oper);
        int result = TECommuNEMgr.getInstance().sendCommand((int)neID, opers, (int)10, null).retCode;
        result = this.checkLogin(result, neID, opers);
        if (result == 0) {
            Output output = opers.get(0).getOutput(0);
            if (String.valueOf(0).equals(output.getFault(0).getCode())) {
                res[0] = Integer.valueOf(output.getPartValue("slot"));
                res[1] = Integer.valueOf(output.getPartValue("portid"));
            }
        }
        return res;
    }

    private int checkLogin(int result, int neid, ArrayList<Operation> opers) {
        if (result != 0) {
            return result;
        }
        Operation oper = opers.get(0);
        String errCode = oper.getOutput(0).getFault(0).getCode();
        if (!errCode.equals(0) && UN_LOGIN.indexOf(errCode) >= 0) {
            if (!TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neid)) {
                return 1090609665;
            }
            return TECommuNEMgr.getInstance().sendCommand((int)neid, opers, (int)10, null).retCode;
        }
        return result;
    }

    public StrUIDFactory convertToVlanSubPortNameByDomain(int neID, int vrID, long vport) {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)neID);
        if (vrID != 0) {
            factory.append("VR", (long)vrID);
        }
        StrLinker linker = new StrLinker();
        linker.append("16").append(65550L).append(vport - 10240L).append("");
        factory.append("LP", linker.getStr());
        return factory;
    }

    public String convertToVrpTunnelName(String tunnel) {
        String res = tunnel;
        if (tunnel == null) {
            return res;
        }
        if (tunnel.matches(NM_TUNNEL_REG)) {
            res = TUNNEL_PRIX + tunnel;
        }
        return res;
    }

    public String convertToTunnelFdnByDomain(int neID, int vrID, String tunnelName) {
        return this.getTunnelFdnStrUIDFactory(neID, vrID, tunnelName).getStr();
    }

    private StrUIDFactory getTunnelFdnStrUIDFactory(int neID, int vrID, String tunnelName) {
        logger.info("the tunnelName is " + tunnelName);
        int tunnelID = 0;
        if (!tunnelName.startsWith(TUNNEL_PRIX)) {
            return null;
        }
        tunnelID = Integer.valueOf(tunnelName.substring(tunnelName.indexOf(TUNNEL_PRIX) + TUNNEL_PRIX.length()));
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)neID);
        if (0 != vrID && -1 != vrID) {
            factory.append("VR", (long)vrID);
        }
        StrLinker linker = new StrLinker();
        linker.append(1L).append(4L);
        TEDynTunnelObjMOPO dynTunnelObjMOPO = this.getDynTunnelObj(neID, tunnelID);
        if (dynTunnelObjMOPO == null) {
            logger.info("query dyntunnelmo is null! " + tunnelID);
            return null;
        }
        linker.append(TEConvertUtil.ipToString((long)dynTunnelObjMOPO.getIngressNode()));
        linker.append(TEConvertUtil.ipToString((long)dynTunnelObjMOPO.getEgressNode()));
        linker.append((long)tunnelID);
        linker.append("").append((long)dynTunnelObjMOPO.getPosition());
        factory.append("TUNNEL", linker.getStr());
        return factory;
    }

    private TEDynTunnelObjMOPO getDynTunnelObj(int neID, int tunnelID) {
        TEDynTunnelObjMOPO resObj = null;
        TEDynamicTunnelMoContainer dynamicTunnelMoContainer = TERsvpTunnelDBMgr.getContainer((int)neID);
        if (null == dynamicTunnelMoContainer) {
            logger.info("query dyntunnelmocontainer is null! " + tunnelID);
            return null;
        }
        TEDynTunnelObjMOPO dynTunnelObjMOPO2 = null;
        Set dynTunnelObjList = dynamicTunnelMoContainer.getDynamicTunnelList();
        if (dynTunnelObjList.isEmpty()) {
            logger.info("the dyntunnel records on dyntunnelmocontainer is 0! " + tunnelID);
        }
        for (TEDynTunnelObjMOPO dynTunnelObjMOPO2 : dynTunnelObjList) {
            if (dynTunnelObjMOPO2.getTunnelID() != tunnelID || dynTunnelObjMOPO2.getPosition() != 1) continue;
            resObj = dynTunnelObjMOPO2;
            break;
        }
        return resObj;
    }

    private boolean isGEPortLevel(int neid, int slotid, int portid) {
        int boardType;
        TEConfigurationDataMgr datamgr = TEConfigurationDataMgr.getInstance();
        if (datamgr.isIFboard(boardType = datamgr.getBoardType(neid, slotid))) {
            return true;
        }
        int level = -1;
        level = datamgr.isDynPort(neid, boardType, portid) ? datamgr.getCacheSpeed(neid, slotid, portid) : datamgr.getPortIterfaceLevel(neid, boardType, portid);
        return level == 16388 || level == 16388 || level == 6;
    }

    public static int[] getPortResByVRPPort(String vrpPortName) {
        try {
            int start;
            if (vrpPortName.startsWith(GE_PORT_PFIX)) {
                start = GE_PORT_PFIX.length();
            } else if (vrpPortName.startsWith(FE_PORT_PFIX)) {
                start = FE_PORT_PFIX.length();
            } else {
                return null;
            }
            String tempStr = vrpPortName.substring(start);
            String[] tempRes = tempStr.split("/");
            int[] res = new int[tempRes.length];
            int len = res.length;
            for (int i = 0; i < len; ++i) {
                res[i] = tempRes[i].indexOf(".") < 0 ? Integer.valueOf(tempRes[i]).intValue() : Integer.valueOf(tempRes[i].substring(0, tempRes[i].indexOf("."))).intValue();
            }
            return res;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("convert vrp port failed! " + vrpPortName, (Throwable)e);
            return null;
        }
    }
}

