/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.trans.nglct.impl;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.dao.TECommonDao;
import com.huawei.nglct.dao.TETransInvMgr;
import com.huawei.vmf.adapter.framework.dao.SQLHelper;
import com.huawei.vmf.adapter.framework.dao.imp.MOPropertyGetterIf;
import com.huawei.vmf.adapter.framework.dao.imp.SQLQueryWrapper;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.extendpoint.framework.IDefaultSubDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.metadata.ClassMetadata;
import org.slf4j.Logger;

public class TETransDefaultSubDao
implements IDefaultSubDao {
    private SessionFactory sf;
    private StatelessSession session;
    private TECommonDao daoService;
    private Logger logger = TELogFactory.getNormalLogger();

    public void init(SessionFactory sf, StatelessSession session) {
        this.sf = sf;
        this.session = session;
        this.daoService = new TECommonDao(session);
    }

    public <T> Collection<T> queryAll(SessionFactory sf, Class<T> moClazz, boolean cascade) {
        this.sf = sf;
        if (TETransInvMgr.isTransMo(moClazz)) {
            return TETransInvMgr.getTransInv(moClazz);
        }
        return this.getHBPos(moClazz);
    }

    public <T> Collection<T> queryAll(SessionFactory sf, Class<T> moClazz) {
        this.sf = sf;
        return this.getHBPos(moClazz);
    }

    public <T> Collection<T> queryByKey(SessionFactory sf, Class<T> clazz, Collection<T> conditions, boolean cascade) {
        this.sf = sf;
        if (clazz.isAssignableFrom(Interface.class)) {
            return null;
        }
        if (clazz.isAssignableFrom(RsvpTeTunnel.class)) {
            return conditions;
        }
        return null;
    }

    private <T> Collection<T> updateVMFInterface(Collection<T> conditions) {
        this.logger.info("start sync interface from trans to vmf. " + new Date().toLocaleString());
        ArrayList<Object> objs_save = new ArrayList<Object>();
        for (T obj : conditions) {
            Interface interfaceObj = (Interface)obj;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("param1", interfaceObj.getDevID());
            params.put("param2", interfaceObj.getVrID());
            List<Object> vmfIfms = this.daoService.getListByHql("FROM com.huawei.vmf.adapter.fservice.ifm.model.Interface WHERE devID = :param1 and vrID = :param2", params);
            if (this.isPortResExist(interfaceObj, vmfIfms)) continue;
            this.logger.info(interfaceObj.toString() + " need to be save.");
            objs_save.add(interfaceObj);
        }
        this.logger.info("saving start!");
        this.daoService.saveAll(objs_save);
        this.logger.info("saving end!");
        this.logger.info("end sync interface from trans to vmf. " + new Date().toLocaleString());
        return null;
    }

    private boolean isPortResExist(Interface ifm, List<Object> objs) {
        return objs.contains(ifm);
    }

    private <T> Collection<T> getHBPos(Class<T> moClazz) {
        SQLHelper sql = SQLHelper.query(moClazz, (SessionFactory)this.sf);
        sql.selectAll(moClazz);
        SQLQuery query = this.createSqlQuery(sql, true);
        return query.list();
    }

    private SQLQuery createSqlQuery(SQLHelper sql, boolean transform) {
        return SQLQueryWrapper.getInstance().getSqlQueryWrapper(sql.createExecuteSQLQuery(this.session, transform), new MOPropertyGetterIf(){

            public Collection<String> getPropertyNames(Class<?> moClass) {
                return TETransDefaultSubDao.this.getPersistentProperties(moClass);
            }
        });
    }

    private Collection<String> getPersistentProperties(Class<?> clazz) {
        assert (clazz != null);
        assert (this.hasMetaData(clazz));
        ClassMetadata meta = this.sf.getClassMetadata(clazz);
        return Arrays.asList(meta.getPropertyNames());
    }

    private boolean hasMetaData(Class<?> ... moTypes) {
        for (Class<?> moType : moTypes) {
            if (this.sf.getClassMetadata(moType) != null) continue;
            return false;
        }
        return true;
    }
}

