/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.trans.nglct.devicecache;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevTypeInfo;
import com.huawei.vmf.qat.persistence.service.DevChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TEDeviceCache {
    private static final int BTB = 3;
    private static final int MULTIPLE = 2;
    private final Map<Integer, DevSysInfo> deviceCache;
    private final Logger LOG = LoggerFactory.getLogger(TEDeviceCache.class);
    private Collection<DevTypeInfo> staticTypes;
    private static TEDeviceCache INSTANCE = null;

    private TEDeviceCache() {
        this.deviceCache = new ConcurrentHashMap<Integer, DevSysInfo>();
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection devices = dao.queryAll(DevSysInfo.class, true);
            ArrayList<DevChange.DevInfo> allDev = new ArrayList<DevChange.DevInfo>();
            for (DevSysInfo devSysInfo : devices) {
                this.deviceCache.put(devSysInfo.getDevID(), devSysInfo);
                DevChange.DevInfo devInfo = new DevChange.DevInfo(new DevChange.DevIdentify(devSysInfo.getDevIP(), devSysInfo.getDevID().intValue()), devSysInfo.getDevProductName(), devSysInfo.getDevProductVersion());
                allDev.add(devInfo);
            }
            this.staticTypes = dao.queryAll(DevTypeInfo.class, false);
            ConcurrentHashMap<Integer, String> devTypeNames = new ConcurrentHashMap<Integer, String>();
            for (DevTypeInfo devTypeInfo : this.staticTypes) {
                devTypeNames.put(devTypeInfo.getDevTypeID(), devTypeInfo.getDevTypeName());
            }
            for (DevTypeInfo devTypeInfo : this.staticTypes) {
                if (devTypeInfo.getDevTypeID().equals(devTypeInfo.getCompDevTypeID()) || devTypeInfo.getCompDevTypeID() == null) continue;
                String comDevTypeName = (String)devTypeNames.get(devTypeInfo.getCompDevTypeID());
                devTypeInfo.setCompDevTypeName(comDevTypeName);
            }
        }
        catch (VMFException e) {
            this.LOG.error("cann't load data, cacha is disabled.", (Throwable)e);
        }
    }

    public static TEDeviceCache getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new TEDeviceCache();
        }
        return INSTANCE;
    }

    public synchronized int addDecoupleDevType(DevTypeInfo devTypeInfo) {
        Context ctx = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
        ArrayList<DevTypeInfo> condition = new ArrayList<DevTypeInfo>();
        condition.add(devTypeInfo);
        try {
            Collection typeList = dao.queryByKey(DevTypeInfo.class, condition, false);
            if (typeList.size() > 0) {
                ArrayList<String> propList = new ArrayList<String>();
                propList.add("compSysOID");
                propList.add("compDevTypeID");
                propList.add("compDevVersionID");
                ctx.addChangeRecord(DevTypeInfo.class).addModify((Object)devTypeInfo, propList);
            } else {
                ctx.addChangeRecord(DevTypeInfo.class).addCreate((Object)devTypeInfo);
            }
            dao.merge(DevTypeInfo.class, false);
        }
        catch (VMFException e) {
            this.LOG.error("", (Throwable)e);
            return e.getErrorCode();
        }
        for (DevTypeInfo typeInfo : this.staticTypes) {
            if (!typeInfo.equals((Object)devTypeInfo)) continue;
            typeInfo.setCompDevTypeID(devTypeInfo.getCompDevTypeID());
            typeInfo.setCompDevVersionID(devTypeInfo.getCompDevVersionID());
            typeInfo.setCompSysOID(devTypeInfo.getCompSysOID());
            typeInfo.setCompDevTypeName(devTypeInfo.getCompDevTypeName());
            typeInfo.setCompProductVersion(devTypeInfo.getCompProductVersion());
            return 0;
        }
        this.staticTypes.add(devTypeInfo);
        return 0;
    }

    public void addDeviceType(DevTypeInfo typeInfo) {
        this.staticTypes.add(typeInfo);
    }

    public void removeDeviceTypeByID(int realID) {
        Iterator<DevTypeInfo> iter = this.staticTypes.iterator();
        while (iter.hasNext()) {
            DevTypeInfo type = iter.next();
            if (!type.getDevSysOID().equals(String.valueOf(realID))) continue;
            iter.remove();
        }
    }

    public void addDevice(DevSysInfo dev) {
        this.deviceCache.put(dev.getDevID(), dev);
    }

    public synchronized boolean containDevTypeId(int devTypeId) {
        for (DevTypeInfo type : this.staticTypes) {
            if (!type.getDevTypeID().equals(devTypeId)) continue;
            return true;
        }
        return false;
    }

    public Iterator<Map.Entry<Integer, DevSysInfo>> deviceDataIterator() {
        return this.deviceCache.entrySet().iterator();
    }

    public DevSysInfo getDevice(int devID) {
        return this.deviceCache.get(devID);
    }

    public DevSysInfo getDevice(String ip) {
        for (Map.Entry<Integer, DevSysInfo> entry : this.deviceCache.entrySet()) {
            DevSysInfo sys = entry.getValue();
            if (!sys.getDevIP().equals(ip)) continue;
            return sys;
        }
        return null;
    }

    public synchronized DevTypeInfo getDevTypeBySysOID(String oid) {
        for (DevTypeInfo type : this.staticTypes) {
            if (!type.getDevSysOID().equals(oid)) continue;
            return type;
        }
        return null;
    }

    public synchronized DevTypeInfo getDevTypeInfo(Integer devTypeId, Integer devVersionId) {
        for (DevTypeInfo type : this.staticTypes) {
            if (!type.getDevTypeID().equals(devTypeId) || !type.getDevVersionID().equals(devVersionId)) continue;
            return type;
        }
        return null;
    }

    public boolean isMultiChassisDevice(int devTypeId, int devVersionId) {
        return 2 == devVersionId || 3 == devVersionId;
    }

    public DevSysInfo removeDevice(int devID) {
        return this.deviceCache.remove(devID);
    }

    public int size() {
        return this.deviceCache.size();
    }
}

