/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.trans.nglct.devicecache;

import com.huawei.trans.nglct.devicecache.TEDeviceCache;
import com.huawei.uflight.platformadapter.EncapImapUtil;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevTypeInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class DeviceServiceImpl
implements IDeviceService {
    private static final Map<Integer, String> deviceBusyStates = new HashMap<Integer, String>();

    public List<DevSysInfo> getAllDevices() throws VMFException {
        ArrayList<DevSysInfo> devInfos = new ArrayList<DevSysInfo>();
        Iterator<Map.Entry<Integer, DevSysInfo>> it = TEDeviceCache.getInstance().deviceDataIterator();
        while (it.hasNext()) {
            Map.Entry<Integer, DevSysInfo> entry = it.next();
            devInfos.add(entry.getValue());
        }
        return devInfos;
    }

    public List<DevSysInfo> getDevices(List<Integer> devIDs) throws VMFException {
        ArrayList<DevSysInfo> devInfos = new ArrayList<DevSysInfo>();
        for (Integer devID : devIDs) {
            DevSysInfo devSysInfo = TEDeviceCache.getInstance().getDevice(devID);
            if (devSysInfo == null) continue;
            devInfos.add(devSysInfo);
        }
        return devInfos;
    }

    public int getDevIDByIP(String strDevIP) throws VMFException {
        DevSysInfo sysInfo = TEDeviceCache.getInstance().getDevice(strDevIP);
        if (sysInfo != null) {
            return sysInfo.getDevID();
        }
        return -1;
    }

    public String getDevIPByID(int devID) throws VMFException {
        DevSysInfo sysInfo = TEDeviceCache.getInstance().getDevice(devID);
        if (sysInfo != null) {
            return sysInfo.getDevIP();
        }
        return "";
    }

    public String getDevNameByEncapImap(int iDevID) {
        return EncapImapUtil.getDevName((int)iDevID);
    }

    public String getDevNameByID(int devID) throws VMFException {
        DevSysInfo sysInfo = TEDeviceCache.getInstance().getDevice(devID);
        if (sysInfo != null) {
            return sysInfo.getDevName();
        }
        return "";
    }

    public DevSysInfo getDevSysInfo(int devID) throws VMFException {
        return TEDeviceCache.getInstance().getDevice(devID);
    }

    public DevTypeInfo getDevTypeAndVersion(int devID) throws VMFException {
        DevSysInfo dev = TEDeviceCache.getInstance().getDevice(devID);
        if (dev != null) {
            return this.getDevTypeInfoBySysOID(dev.getDevSysOID());
        }
        return null;
    }

    public DevTypeInfo getDevTypeInfoBySysOID(String sysOID) throws VMFException {
        return TEDeviceCache.getInstance().getDevTypeBySysOID(sysOID);
    }

    public Map<String, List<String>> getManagedDeviceTypesAndVersions() throws VMFException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Iterator<Map.Entry<Integer, DevSysInfo>> it = TEDeviceCache.getInstance().deviceDataIterator();
        while (it.hasNext()) {
            String devProductVersion;
            List versions;
            Map.Entry<Integer, DevSysInfo> entry = it.next();
            String devProductName = entry.getValue().getDevProductName();
            if (!map.containsKey(devProductName)) {
                map.put(devProductName, new ArrayList());
            }
            if ((versions = (List)map.get(devProductName)).contains(devProductVersion = entry.getValue().getDevProductVersion())) continue;
            versions.add(devProductVersion);
        }
        return map;
    }

    public boolean isMultiChassisDevice(int iDevID) throws VMFException {
        DevSysInfo sys = TEDeviceCache.getInstance().getDevice(iDevID);
        if (sys == null) {
            return false;
        }
        return TEDeviceCache.getInstance().isMultiChassisDevice(sys.getDevTypeID(), sys.getDevVersionID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockDevice(int devId) throws VMFException {
        if (this.getDevSysInfo(devId) == null) {
            throw new VMFException(1107498886, "Device is not exist. devId=" + devId);
        }
        Map<Integer, String> map = deviceBusyStates;
        synchronized (map) {
            String busy = deviceBusyStates.get(devId);
            if (null != busy) {
                throw new VMFException(1107498877, "Device is busy now, may is synchronizing data or being deleted. devId=" + devId + ", owner thread=" + busy);
            }
            deviceBusyStates.put(devId, Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockDevice(int devId) {
        Map<Integer, String> map = deviceBusyStates;
        synchronized (map) {
            deviceBusyStates.remove(devId);
        }
    }

    public String transformDevSysOID(String originalDevSysOID) {
        if (!StringUtils.hasLength((String)originalDevSysOID)) {
            return "";
        }
        String sysOId = originalDevSysOID;
        return sysOId;
    }
}

