/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.vmtacc;

import java.util.Hashtable;
import java.util.Map;

public class LctIpProvider {
    private static LctIpProvider instance;
    private static Map<String, Integer> ipPool;
    private static long ipLongValueTemp;

    private LctIpProvider() {
    }

    public static synchronized LctIpProvider getInstance() {
        if (instance == null) {
            instance = new LctIpProvider();
            ipPool = new Hashtable<String, Integer>();
            ipLongValueTemp = 0L;
        }
        return instance;
    }

    public synchronized String getIdentityIpString(int neID) {
        String ip = "";
        for (Map.Entry<String, Integer> ipPare : ipPool.entrySet()) {
            if (ipPare.getValue() != neID) continue;
            ip = ipPare.getKey();
            break;
        }
        if ("".equals(ip)) {
            ip = this.ipGenerator();
        }
        ipPool.put(ip, neID);
        return ip;
    }

    public synchronized void addIpToIpPool(String ip, int neID) {
        if (!ipPool.containsKey(ip)) {
            ipPool.put(ip, neID);
        }
    }

    public synchronized int getNeIdByIdentityIp(String ip) {
        int neID = -1;
        if (ipPool.containsKey(ip)) {
            neID = ipPool.get(ip);
        }
        return neID;
    }

    public synchronized void removeIdentityIp(int neID) {
        for (Map.Entry<String, Integer> ipPare : ipPool.entrySet()) {
            if (ipPare.getValue() != neID) continue;
            ipPool.remove(ipPare.getKey());
            break;
        }
    }

    private String ipGenerator() {
        if (ipLongValueTemp == new Long("4228250625")) {
            ipLongValueTemp = 0L;
        }
        return this.longToIP(++ipLongValueTemp);
    }

    private String longToIP(long longIp) {
        StringBuffer sb = new StringBuffer(15);
        sb.append(String.valueOf(longIp >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIp & 0xFFL));
        return sb.toString();
    }
}

